/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosArrayList;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;

public class PDFFileSpecificationList
extends PDFCosArrayList<PDFFileSpecification> {
    private PDFFileSpecificationList(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFileSpecificationList getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFileSpecificationList pdfObject = (PDFFileSpecificationList)PDFCosObject.getCachedInstance(cosObject, PDFFileSpecificationList.class);
        if (pdfObject == null) {
            pdfObject = new PDFFileSpecificationList(cosObject);
        }
        return pdfObject;
    }

    @Override
    protected PDFFileSpecification itemInstantiator(CosObject cosObject) throws PDFInvalidDocumentException {
        return PDFFileSpecification.getInstance(cosObject);
    }

    public static PDFFileSpecificationList newInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosArray cosObject = PDFCosObject.newCosArray(pdfDocument);
        return new PDFFileSpecificationList(cosObject);
    }

    public static PDFFileSpecificationList newInstance(PDFDocument pdfDocument, PDFFileSpecificationList configs) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (configs.size() > 0) {
            CosArray cosObject = PDFCosObject.makeCosArray(pdfDocument, configs);
            return PDFFileSpecificationList.getInstance(cosObject);
        }
        return PDFFileSpecificationList.newInstance(pdfDocument);
    }
}

