/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEmbeddedFile;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFThumbnailImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.navigation.collection.PDFCollectionItem;

public class PDFFileSpecification
extends PDFCosObject {
    public static final ASName k_CI = ASName.create("CI");
    public static final ASName k_UF = ASName.create("UF");

    private PDFFileSpecification(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFFileSpecification getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFFileSpecification pdfObject = (PDFFileSpecification)PDFCosObject.getCachedInstance(cosObject, PDFFileSpecification.class);
        if (pdfObject == null) {
            pdfObject = new PDFFileSpecification(cosObject);
        }
        return pdfObject;
    }

    public static PDFFileSpecification newSkeletonInstance(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary dict = PDFCosObject.newCosDictionary(pdfDocument);
        dict.put(ASName.k_Type, ASName.k_Filespec);
        return new PDFFileSpecification(dict);
    }

    public static PDFFileSpecification newInstance(PDFDocument pdfDocument, byte[] filename) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.newInstance(pdfDocument, new ASString(filename), null);
    }

    public static PDFFileSpecification newInstance(PDFDocument pdfDocument, byte[] filename, PDFEmbeddedFile pdfEmbeddedFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.newInstance(pdfDocument, new ASString(filename), pdfEmbeddedFile);
    }

    public static PDFFileSpecification newInstance(PDFDocument pdfDocument, ASString filename, PDFEmbeddedFile pdfEmbeddedFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFileSpecification pdfFS = PDFFileSpecification.newSkeletonInstance(pdfDocument);
        pdfFS.setFileName(filename);
        pdfFS.setEmbeddedFile(pdfEmbeddedFile);
        return pdfFS;
    }

    public ASName getFSType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).getName(ASName.k_FS);
        }
        return null;
    }

    public void setFSType(ASName fsType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        ((CosDictionary)this.getCosObject()).put(ASName.k_FS, fsType);
    }

    public boolean hasFilename() {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).containsKey(ASName.k_F);
        }
        return true;
    }

    public ASString getFilename() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).getString(ASName.k_F);
        }
        return ((CosString)this.getCosObject()).stringValue();
    }

    public void setFileName(ASString name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        ((CosDictionary)this.getCosObject()).put(ASName.k_F, name);
    }

    public void setFileName(byte[] name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        ((CosDictionary)this.getCosObject()).put(ASName.k_F, new ASString(name));
    }

    public String getUnicodeName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            CosObject nameDict = ((CosDictionary)this.getCosObject()).get(k_UF);
            if (nameDict == null) {
                return null;
            }
            PDFText textName = PDFText.getInstance(nameDict);
            return textName.stringValue();
        }
        return null;
    }

    public void setUnicodeName(String fileName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText name = PDFText.createString(this.getPDFDocument(), fileName);
        ((CosDictionary)this.getCosObject()).put(k_UF, name.getCosObject());
    }

    public ASString getDOSFilename() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).getString(ASName.k_DOS);
        }
        return null;
    }

    public void setDOSFileName(byte[] name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        ((CosDictionary)this.getCosObject()).put(ASName.k_DOS, new ASString(name));
    }

    public ASString getUnixFilename() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).getString(ASName.k_Unix);
        }
        return null;
    }

    public void setUnixFileName(byte[] name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        ((CosDictionary)this.getCosObject()).put(ASName.k_Unix, new ASString(name));
    }

    public ASString getMacFilename() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).getString(ASName.k_Mac);
        }
        return null;
    }

    public void setMacFileName(byte[] name) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        ((CosDictionary)this.getCosObject()).put(ASName.k_Mac, new ASString(name));
    }

    public boolean hasThumbnail() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            return ((CosDictionary)this.getCosObject()).containsKey(ASName.k_Thumb);
        }
        return false;
    }

    public PDFXObject getThumbnail() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary thumb;
        if (this.isDictionaryFS() && (thumb = ((CosDictionary)this.getCosObject()).getCosDictionary(ASName.k_Thumb)) != null) {
            return PDFXObjectFactory.getInstance(thumb);
        }
        return null;
    }

    public void setThumbnail(PDFXObject xObj) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            if (xObj == null) {
                ((CosDictionary)this.getCosObject()).remove(ASName.k_Thumb);
            } else {
                CosObject thumb = xObj.getCosObject();
                ((CosDictionary)this.getCosObject()).put(ASName.k_Thumb, thumb);
            }
        }
    }

    public boolean hasEmbeddedFile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            CosDictionary efDict = ((CosDictionary)this.getCosObject()).getCosDictionary(ASName.k_EF);
            return efDict != null ? efDict.containsKey(ASName.k_F) : false;
        }
        return false;
    }

    public PDFEmbeddedFile getEmbeddedFile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary efDict;
        if (this.isDictionaryFS() && (efDict = ((CosDictionary)this.getCosObject()).getCosDictionary(ASName.k_EF)) != null) {
            return PDFEmbeddedFile.getInstance(efDict.get(ASName.k_F));
        }
        return null;
    }

    public PDFEmbeddedFile procureEmbeddedFile() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        if (this.hasEmbeddedFile()) {
            return this.getEmbeddedFile();
        }
        return PDFEmbeddedFile.newInstance(this.getPDFDocument());
    }

    public void setEmbeddedFile(PDFEmbeddedFile embeddedFile) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        if (embeddedFile != null) {
            CosDictionary efDict = ((CosDictionary)this.getCosObject()).getCosDictionary(ASName.k_EF);
            if (efDict == null) {
                efDict = PDFCosObject.newCosDictionary(this.getPDFDocument());
            }
            efDict.put(ASName.k_F, embeddedFile.getCosObject());
            ((CosDictionary)this.getCosObject()).put(ASName.k_EF, efDict);
        }
    }

    public PDFCollectionItem getCollectionItem() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS()) {
            CosDictionary ciDict = ((CosDictionary)this.getCosObject()).getCosDictionary(k_CI);
            return PDFCollectionItem.getInstance(ciDict);
        }
        return null;
    }

    public void setCollectionItem(PDFCollectionItem colItem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.isDictionaryFS() && colItem != null) {
            this.ensureFSIsDictionary();
        }
        if (this.isDictionaryFS()) {
            if (colItem == null) {
                ((CosDictionary)this.getCosObject()).remove(k_CI);
            } else {
                ((CosDictionary)this.getCosObject()).put(k_CI, colItem.getCosObject());
            }
        }
    }

    private boolean isDictionaryFS() {
        return this.getCosObject() instanceof CosDictionary;
    }

    private void ensureFSIsDictionary() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject cosObj = this.getCosObject();
        if (cosObj instanceof CosString) {
            CosDictionary cosFS = PDFCosObject.newCosDictionary(this.getPDFDocument());
            cosFS.put(ASName.k_Type, ASName.k_Filespec);
            this.replaceCosObject(cosFS);
            cosFS.put(ASName.k_F, cosObj);
        }
    }

    public void setDescription(String description) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.ensureFSIsDictionary();
        PDFText textValue = PDFText.newInstance(this.getPDFDocument(), description);
        ((CosDictionary)this.getCosObject()).put(ASName.k_Desc, textValue.getCosObject());
    }

    public String getDescription() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFText textValue;
        if (this.isDictionaryFS() && (textValue = PDFText.getInstance(((CosDictionary)this.getCosObject()).get(ASName.k_Desc))) != null) {
            return textValue.stringValue();
        }
        return null;
    }

    public PDFThumbnailImage getThumbnailStream() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFThumbnailImage.getInstance(((CosDictionary)this.getCosObject()).getCosStream(ASName.k_Thumb));
    }

    public void setThumbnailStream(PDFThumbnailImage thumbnailStream) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ((CosDictionary)this.getCosObject()).put(ASName.k_Thumb, thumbnailStream.getCosObject());
    }

    public ASName getAFRelationship() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName name = ((CosDictionary)this.getCosObject()).getName(ASName.k_AFRelationship);
        if (name != null) {
            return name;
        }
        return ASName.k_Source;
    }

    public void setAFRelationship(ASName name) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ((CosDictionary)this.getCosObject()).put(ASName.k_AFRelationship, name);
    }
}

