/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.document;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import java.util.ArrayList;

public class PDFCosUtils {
    public static CosArray newCosArray(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosArray();
    }

    public static CosDictionary newCosDictionary(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosDictionary();
    }

    public static CosStream newCosStream(PDFDocument pdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosStream();
    }

    public static CosObject checkNullCosObject(CosObject cosObject) {
        if (cosObject == null) {
            return null;
        }
        if (cosObject.getType() == 0) {
            return null;
        }
        return cosObject;
    }

    public static CosArray newCosArray(PDFDocument pdfDocument, ArrayList<?> list) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return pdfDocument.getCosDocument().createCosArray(list);
    }

    public static CosObject getInheritableValue(ASName name, ASName parentKey, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value;
        if (!(dict.getCosObject() instanceof CosDictionary)) {
            return null;
        }
        CosDictionary cosDict = (CosDictionary)dict.getCosObject();
        while ((value = cosDict.get(name)) == null || value instanceof CosNull) {
            CosObject parent = cosDict.get(parentKey);
            if (parent == null || parent instanceof CosNull) {
                return null;
            }
            if (parent instanceof CosDictionary) {
                cosDict = (CosDictionary)parent;
                continue;
            }
            return null;
        }
        return value;
    }

    public static boolean containsInheritableKey(ASName key, ASName parentKey, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!(dict.getCosObject() instanceof CosDictionary)) {
            return false;
        }
        CosDictionary cosDict = (CosDictionary)dict.getCosObject();
        while (true) {
            boolean keyFound;
            if (keyFound = cosDict.containsKey(key)) {
                return keyFound;
            }
            CosObject parent = cosDict.get(parentKey);
            if (parent == null || parent instanceof CosNull) {
                return false;
            }
            if (!(parent instanceof CosDictionary)) break;
            cosDict = (CosDictionary)parent;
        }
        return false;
    }

    public static CosDictionary getInheritableValueDictionary(ASName key, ASName parentKey, PDFCosDictionary dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject value;
        if (!(dict.getCosObject() instanceof CosDictionary)) {
            return null;
        }
        CosDictionary cosDict = (CosDictionary)dict.getCosObject();
        while ((value = cosDict.get(key)) == null || value instanceof CosNull) {
            CosObject parent = cosDict.get(parentKey);
            if (parent == null || parent instanceof CosNull) {
                return null;
            }
            if (parent instanceof CosDictionary) {
                cosDict = (CosDictionary)parent;
                continue;
            }
            return null;
        }
        return cosDict;
    }
}

