/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;

public enum PDFSignatureSubFilter {
    X509RSASha1(PDFSignature.k_adbe_x509_rsa_sha1.asString(true)),
    PKCS7Detached(PDFSignature.k_adbe_pkcs7_detached.asString(true)),
    PKCS7Sha1(PDFSignature.k_adbe_pkcs7_sha1.asString(true)),
    ETSIRFC3161(PDFSignature.k_ETSI_RFC3161.asString(true)),
    ETSICADESDetached(PDFSignature.k_ETSI_CADES_detached.asString(true));

    private String subFilter;

    private PDFSignatureSubFilter() {
    }

    private PDFSignatureSubFilter(String subFilter) {
        this.subFilter = subFilter;
    }

    public static PDFSignatureSubFilter getInstance(ASName subFilter) throws PDFInvalidParameterException {
        if (subFilter == PDFSignature.k_adbe_x509_rsa_sha1) {
            return X509RSASha1;
        }
        if (subFilter == PDFSignature.k_adbe_pkcs7_detached) {
            return PKCS7Detached;
        }
        if (subFilter == PDFSignature.k_adbe_pkcs7_sha1) {
            return PKCS7Sha1;
        }
        if (subFilter == PDFSignature.k_ETSI_RFC3161) {
            return ETSIRFC3161;
        }
        if (subFilter == PDFSignature.k_ETSI_CADES_detached) {
            return ETSICADESDetached;
        }
        throw new PDFInvalidParameterException("The subfilter value " + subFilter + " cannot be used");
    }

    public String getValue() {
        return this.subFilter;
    }

    public String toString() {
        return this.subFilter;
    }
}

