/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.digsig;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParameters;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersDocMDP;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersFieldMDP;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFTransformParametersUR;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;

public class PDFSignatureReference
extends PDFCosDictionary {
    public static final ASName k_SigRef = ASName.create("SigRef");
    public static final ASName k_TransformParams = ASName.create("TransformParams");
    public static final ASName k_TransformMethod = ASName.create("TransformMethod");
    public static final ASName k_DigestMethod = ASName.create("DigestMethod");
    public static final ASName k_DigestValue = ASName.create("DigestValue");
    public static final ASName k_DigestLocation = ASName.create("DigestLocation");

    protected PDFSignatureReference(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static PDFSignatureReference getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject(cosObject) == null) {
            return null;
        }
        PDFSignatureReference pdfObject = (PDFSignatureReference)PDFCosObject.getCachedInstance(cosObject, PDFSignatureReference.class);
        if (pdfObject == null) {
            pdfObject = new PDFSignatureReference(cosObject);
        }
        return pdfObject;
    }

    public static PDFSignatureReference newInstance(PDFDocument pdfDocument, ASName transformMethod) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDirectDictionary(pdfDocument);
        PDFSignatureReference pdfObject = new PDFSignatureReference(cosObject);
        pdfObject.setDictionaryNameValue(ASName.k_Type, k_SigRef);
        pdfObject.setDictionaryNameValue(k_TransformMethod, transformMethod);
        return pdfObject;
    }

    public ASName getType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Type);
    }

    public ASName getTransformMethodName() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryNameValue(k_TransformMethod);
    }

    public void setTransformMethodName(String transformMethod) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryNameValue(k_TransformMethod, transformMethod);
    }

    public PDFTransformParameters getPDFTransformParameters() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        ASName transformMethod = this.getTransformMethodName();
        if (transformMethod == PDFSignature.k_DocMDP) {
            return PDFTransformParametersDocMDP.getInstance(this.getDictionaryCosObjectValue(k_TransformParams));
        }
        if (transformMethod == PDFSignature.k_UR || transformMethod == PDFSignature.k_UR3) {
            return PDFTransformParametersUR.getInstance(this.getDictionaryCosObjectValue(k_TransformParams));
        }
        if (transformMethod == PDFSignature.k_FieldMDP) {
            return PDFTransformParametersFieldMDP.getInstance(this.getDictionaryCosObjectValue(k_TransformParams));
        }
        return null;
    }

    public void setPDFTransformParameters(PDFTransformParameters params) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryValue(k_TransformParams, params);
    }

    public CosObject getData() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryCosObjectValue(ASName.k_Data);
    }

    public void setData(CosObject data) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        if (data == null && (this.getTransformMethodName() == PDFSignature.k_FieldMDP || this.getTransformMethodName() == PDFSignature.k_Identity)) {
            throw new PDFInvalidDocumentException("Invalid Parameter: data can not be null");
        }
        this.setDictionaryValue(ASName.k_Data, data);
    }

    public String getDigestMethod() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryNameValueAsString(k_DigestMethod);
    }

    public ASName getDigestMethodName() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        return this.getDictionaryNameValue(k_DigestMethod);
    }

    public void setDigestMethod(String method) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryNameValue(k_DigestMethod, method);
    }

    public byte[] getDigest() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        CosString digestStr = this.getCosDictionary().getCosString(k_DigestValue);
        if (digestStr != null) {
            if (digestStr.getIsEncrypted()) {
                digestStr.setIsEncrypted(false);
            }
            return digestStr.byteArrayValue();
        }
        return null;
    }

    public void setDigest(byte[] value) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.setDictionaryByteArrayValue(k_DigestValue, value);
        CosString digestStr = this.getCosDictionary().getCosString(k_DigestValue);
        digestStr.setWriteHex(true);
        if (digestStr.getToEncrypt()) {
            digestStr.setToEncrypt(false);
        }
        this.setDigestLocation(1234567890L, 1234567890L);
    }

    public long[] getDigestLocation() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        CosArray cosArray = this.getDictionaryArrayValue(k_DigestLocation);
        if (cosArray != null) {
            return cosArray.getArrayLong();
        }
        return null;
    }

    public void setDigestLocation(long offset, long length) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        CosArray cosArray = null;
        if (this.getCosDictionary().containsKey(k_DigestLocation)) {
            cosArray = this.getDictionaryArrayValue(k_DigestLocation);
            cosArray.clear();
        } else {
            cosArray = PDFCosObject.newCosArray(this.getPDFDocument());
            this.setDictionaryArrayValue(k_DigestLocation, cosArray);
        }
        cosArray.addLong(0, offset);
        cosArray.addLong(1, length);
    }
}

