/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterWidthEstimator;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PDFSimpleFontData;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListener;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerProperties;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentMessage;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import java.util.WeakHashMap;

public class SimpleFontDataCache
implements DocumentListener {
    private CharacterWidthEstimator characterWidthEstimator;
    private boolean enabled = false;
    private WeakHashMap<PDFFontSimple, PDFSimpleFontData> simpleFontDataCache = new WeakHashMap();

    private SimpleFontDataCache() {
    }

    public static SimpleFontDataCache getInstance(PDFDocument document) {
        DocumentListener existingListener = document.getListenerRegistry().getListener(SimpleFontDataCache.class);
        if (existingListener == null) {
            SimpleFontDataCache fontDataCache = new SimpleFontDataCache();
            fontDataCache.characterWidthEstimator = new CharacterWidthEstimator(fontDataCache);
            document.getListenerRegistry().registerListener(SimpleFontDataCache.class, fontDataCache);
            return fontDataCache;
        }
        return (SimpleFontDataCache)existingListener;
    }

    public PDFSimpleFontData getPDFSimpleFontData(PDFFontSimple font) {
        if (!this.enabled) {
            return null;
        }
        PDFSimpleFontData simpleFontData = this.simpleFontDataCache.get(font);
        if (simpleFontData == null) {
            simpleFontData = new PDFSimpleFontData();
            this.simpleFontDataCache.put(font, simpleFontData);
        }
        return simpleFontData;
    }

    public CharacterWidthEstimator getCharacterWidthEstimator() {
        return this.characterWidthEstimator;
    }

    @Override
    public DocumentListenerProperties getProperties() {
        return null;
    }

    @Override
    public void message(DocumentMessage message) throws PDFUnableToCompleteOperationException {
        if (message.getMessageType() == DocumentMessage.SAVE || message.getMessageType() == DocumentMessage.CLOSE || message.getMessageType() == DocumentMessage.FINISH || message.getMessageType() == DocumentMessage.FLUSH_FONTS) {
            this.simpleFontDataCache.clear();
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

