/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content.processor;

import com.adobe.agl.lang.UScript;
import com.adobe.fontengine.font.Font;
import com.adobe.fontengine.font.FontImpl;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASQuad;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import com.adobe.internal.pdftoolkit.pdf.content.processor.CharacterScript;
import com.adobe.internal.pdftoolkit.pdf.content.processor.PUASubHubEntry;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRun;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType0;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontType3;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFWritingMode;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PDFCharacter
implements Comparable<Object> {
    private TextRun textRun;
    private int index;
    private byte[] charCodeBytes;
    private int[] unicodes;
    private ASCoordinate origin;
    private ASCoordinate end;
    private ASCoordinate center;
    private CharacterScript script;
    private boolean isRTL;
    private String unicodeString;
    private long id;
    private Double baselineangle = null;
    private static Map<Integer, CharacterScript> scriptToLocaleMap = new HashMap<Integer, CharacterScript>();
    private GeneralPath glyphOutline = null;
    private ASCoordinate sortCordinate;
    private static final int[] gPUATable_Thai;
    private static PUASubHubEntry[] gPUASubTable;

    public static int getPUASubstituteHost(char baseChar, char puaChar) {
        if (puaChar < '\ue000' || puaChar > '\uf8ff') {
            return -1;
        }
        PUASubHubEntry subEntry = null;
        for (int i = 0; i < gPUASubTable.length; ++i) {
            if (baseChar > PDFCharacter.gPUASubTable[i].baseRangeEnd || baseChar < PDFCharacter.gPUASubTable[i].baseRangeBegin || puaChar > PDFCharacter.gPUASubTable[i].puaRangeEnd || puaChar < PDFCharacter.gPUASubTable[i].puaRangeBegin) continue;
            subEntry = gPUASubTable[i];
            break;
        }
        if (subEntry != null && subEntry.uCSSubEntry.length > 0) {
            return subEntry.uCSSubEntry[puaChar - subEntry.puaRangeBegin];
        }
        return -1;
    }

    public PDFCharacter(TextRun textRun, int index, byte[] charCodeBytes, ASCoordinate origin, ASCoordinate end, long id) {
        this.textRun = textRun;
        this.index = index;
        this.charCodeBytes = charCodeBytes;
        this.origin = origin;
        this.end = end;
        this.center = new ASCoordinate((this.getEnd().x() - this.getOrigin().x()) / 2.0 + this.getOrigin().x(), (this.getEnd().y() - this.getOrigin().y()) / 2.0 + this.getOrigin().y());
        this.id = id;
        try {
            this.glyphOutline = this.generateGlyphOutline();
        }
        catch (Exception e) {
            this.glyphOutline = null;
        }
    }

    public GeneralPath getGlyphOutline() {
        if (this.glyphOutline == null) {
            try {
                this.glyphOutline = this.generateGlyphOutline();
            }
            catch (Exception e) {
                this.glyphOutline = null;
            }
        }
        return this.glyphOutline;
    }

    public PDFCharacter(TextRun textRun, int index, byte[] charCodeBytes, int[] unicodes, ASCoordinate origin, ASCoordinate end, long id) {
        this.textRun = textRun;
        this.index = index;
        this.charCodeBytes = charCodeBytes;
        this.unicodes = unicodes;
        this.origin = origin;
        this.end = end;
        this.script = this.getCharacterScript(unicodes);
        this.isRTL = TextRun.isCharacterRTL(unicodes);
        this.center = new ASCoordinate((this.getEnd().x() - this.getOrigin().x()) / 2.0 + this.getOrigin().x(), (this.getEnd().y() - this.getOrigin().y()) / 2.0 + this.getOrigin().y());
        this.id = id;
        try {
            this.glyphOutline = this.generateGlyphOutline();
        }
        catch (Exception e) {
            this.glyphOutline = null;
        }
    }

    private GeneralPath generateGlyphOutline() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, FontLoadingException, InvalidFontException, UnsupportedFontException, PDFFontException {
        GeneralPath glyphOutline = null;
        PDFFont font = null;
        font = this.getFont();
        if (font instanceof PDFFontType3) {
            return null;
        }
        Font afeFont = this.getAFEFont(font);
        byte[] charCodeBytes = this.getCharCode();
        int charCode = this.getCharCodeFromBytes(charCodeBytes);
        int gid = this.getGID(font, afeFont, charCode);
        ASCoordinate pt = this.getOrigin();
        if (!this.textRun.isHorizontalWritingMode() && font instanceof PDFFontType0 && ((PDFFontType0)font).getWritingMode() == PDFWritingMode.VERTICAL) {
            PDFFontType0 fontType0 = (PDFFontType0)font;
            int[] dw2 = fontType0.getDescendantFont().getDW2();
            pt = pt.translate(0.0, this.getHorizontalFontSize() * (double)(-dw2[0]) / 1000.0);
        }
        Glyph glyph = new Glyph(charCode, gid, pt.x(), pt.y(), (int)this.id);
        glyphOutline = this.getTransformedGlyphsOutlines(null, gid, this.getHorizontalFontSize(), this.textRun.getRise(), glyph, afeFont);
        return glyphOutline;
    }

    private int getGID(PDFFont font, Font afeFont, int charCode) throws InvalidFontException, UnsupportedFontException, FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        if (afeFont != null) {
            if (font instanceof PDFFontSimple) {
                return PDFFontUtils.getSimpleFontGidFromCharCode(charCode, PDFFontUtils.charCode2glyphName(charCode, (PDFFontSimple)font, ((FontImpl)afeFont).getFontData()), ((PDFFontSimple)font).getEncoding(), ((FontImpl)afeFont).getFontData(), font.getFontDescriptor());
            }
            if (font instanceof PDFFontType0) {
                return PDFFontUtils.charCode2gid(charCode, (PDFFontType0)font, ((FontImpl)afeFont).getFontData());
            }
        }
        return 0;
    }

    private Font getAFEFont(PDFFont font) throws FontLoadingException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Font afeFont = null;
        afeFont = font.getAFEFont(false);
        if (afeFont == null) {
            afeFont = font.getAFEFont(true);
        }
        return afeFont;
    }

    private int getCharCodeFromBytes(byte[] charCodeBytes) {
        int charCode = 0;
        for (int i = 0; i < charCodeBytes.length; ++i) {
            if (i > 0) {
                charCode <<= 8;
            }
            charCode |= charCodeBytes[i] & 0xFF;
        }
        return charCode;
    }

    private GeneralPath getTransformedGlyphsOutlines(GeneralPath glyphOutline, int gid, double fontSize, double textRise, Glyph glyph, Font font) throws InvalidFontException, UnsupportedFontException, FontLoadingException {
        ASMatrix textRunTM = this.textRun.getTextSpaceToDeviceSpaceCTM().setTranslate(0.0, 0.0).preScale(this.textRun.getH(), 1.0);
        ASCoordinate textRiseCoord = new ASCoordinate(0.0, textRise).transform(textRunTM);
        ASMatrix transformationMatrix = textRunTM.getUnitRotationMatrix().scale(fontSize).setTranslate(glyph.getXPos(), glyph.getYPos()).translate(textRiseCoord.x(), textRiseCoord.y());
        if (glyphOutline == null) {
            glyphOutline = GraphicsUtils.getGlyphsOulines(gid, font);
        }
        glyphOutline.transform(new AffineTransform(transformationMatrix.getValues()));
        glyph.setGlyphOutline(glyphOutline);
        return glyphOutline;
    }

    public TextRun getTextRun() {
        return this.textRun;
    }

    int getIndex() {
        return this.index;
    }

    public byte[] getCharCode() {
        return this.charCodeBytes;
    }

    public ASCoordinate getOrigin() {
        return this.origin;
    }

    public ASCoordinate getEnd() {
        return this.end;
    }

    public void setSortCoordinate(ASCoordinate coordinate) {
        this.sortCordinate = coordinate;
    }

    public ASCoordinate getSortCordinate() {
        return this.sortCordinate;
    }

    public int[] getUnicodes() {
        return this.unicodes;
    }

    public String toString() {
        try {
            return this.getUnicodeString();
        }
        catch (PDFException e) {
            return "";
        }
    }

    public String getUnicodeString() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.unicodeString == null) {
            try {
                this.unicodeString = this.textRun.getUnicodeString(this.charCodeBytes);
            }
            catch (PDFInvalidDocumentException e) {
                if (this.textRun.ignoreErrors()) {
                    return "";
                }
                throw e;
            }
        }
        return this.unicodeString;
    }

    public void setUnicodeString(String unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.unicodeString = unicode;
    }

    public double getHorizontalFontSize() {
        return this.textRun.getScaledFontSizeHorizontal();
    }

    public double getVerticalFontSize() {
        return this.textRun.getScaledFontSizeVertical();
    }

    public PDFFont getFont() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextState tState = this.textRun.getTextState();
        return tState.getFont();
    }

    public double getSpaceCharWidth(byte[] spaceCharCode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.textRun.getScaledCharWidth(spaceCharCode);
    }

    public double getSpaceCharWidth() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextState tState = this.textRun.getTextState();
        PDFFont font = tState.getFont();
        byte[] spaceCharCode = font.getSpaceCharCode();
        return this.textRun.getScaledCharWidth(spaceCharCode);
    }

    public double getSpaceCharWidth(PDFCharacter nextChar) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextState tState = this.textRun.getTextState();
        PDFFont font = tState.getFont();
        byte[] spaceCharCode = font.getSpaceCharCode();
        return this.textRun.getScaledCharWidth(spaceCharCode);
    }

    public double getSpaceCharHeight() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextState tState = this.textRun.getTextState();
        PDFFont font = tState.getFont();
        byte[] spaceCharCode = font.getSpaceCharCode();
        return this.textRun.getScaledCharHeight(spaceCharCode);
    }

    public double getWidth() {
        return this.origin.distanceTo(this.end);
    }

    public double getBaselineAngle() {
        if (this.baselineangle == null) {
            this.baselineangle = this.origin.angleTo(this.end);
        }
        return this.baselineangle;
    }

    double getBaselineAngleDelta(PDFCharacter pdeChar) {
        double angle1 = this.getBaselineAngle();
        double angle2 = pdeChar.getBaselineAngle();
        return angle2 - angle1;
    }

    public double getXDistanceTo(PDFCharacter pdeChar) {
        if (this.getEnd().x() != pdeChar.getEnd().x() && this.areCentersAlignedinYDir(pdeChar) || pdeChar.getTextRun().isHorizontalWritingMode() && !pdeChar.getTextRun().isRotatedOrSkewed() && this.areCentersAlignedinYDir(pdeChar)) {
            return this.getCenterLineXDistance(pdeChar);
        }
        if (!pdeChar.getTextRun().isHorizontalWritingMode() && pdeChar.getTextRun().getTsBaselineAngle() == 0.0 && this.getEnd().x() == pdeChar.getEnd().x()) {
            return this.getCenterLineXDistance(pdeChar);
        }
        if (!pdeChar.getTextRun().isHorizontalWritingMode() && this.areCentersAlignedinXDir(pdeChar)) {
            return this.getCenterLineYDistance(pdeChar) / 2.0;
        }
        double angle1 = this.getBaselineAngle();
        if (angle1 == 0.0 && angle1 == pdeChar.getBaselineAngle()) {
            return pdeChar.origin.x() - this.end.x();
        }
        double angle2 = this.end.angleTo(pdeChar.origin);
        double distance = this.end.distanceTo(pdeChar.origin);
        if (angle1 == angle2) {
            return distance;
        }
        return distance * Math.cos(angle2 - angle1);
    }

    private double getCenterLineXDistance(PDFCharacter pdeChar) {
        double angle1 = this.getBaselineAngle();
        ASCoordinate center1 = this.center;
        ASCoordinate center2 = pdeChar.center;
        double angle2 = center1.angleTo(center2);
        double distance = center1.distanceTo(center2);
        return distance * Math.cos(angle2 - angle1);
    }

    private double getCenterLineYDistance(PDFCharacter pdeChar) {
        double angle1 = this.getBaselineAngle();
        ASCoordinate center1 = this.center;
        ASCoordinate center2 = pdeChar.center;
        double angle2 = center1.angleTo(center2);
        double distance = center1.distanceTo(center2);
        return distance * Math.sin(angle2 - angle1);
    }

    public boolean areCentersAlignedinYDir(PDFCharacter pdeChar) {
        ASCoordinate center1 = this.center;
        ASCoordinate center2 = pdeChar.center;
        return center1.x() == center2.x() || Math.abs(center1.y() - center2.y()) != 0.0 && Math.abs(center1.y() - center2.y()) == this.getVerticalFontSize();
    }

    private boolean areCentersAlignedinXDir(PDFCharacter pdeChar) {
        ASCoordinate center1 = new ASCoordinate((this.getEnd().x() - this.getOrigin().x()) / 2.0 + this.getOrigin().x(), (this.getEnd().y() - this.getOrigin().y()) / 2.0 + this.getOrigin().y());
        ASCoordinate center2 = new ASCoordinate((pdeChar.getEnd().x() - pdeChar.getOrigin().x()) / 2.0 + pdeChar.getOrigin().x(), (pdeChar.getEnd().y() - pdeChar.getOrigin().y()) / 2.0 + pdeChar.getOrigin().y());
        return center1.y() == center2.y();
    }

    public double getAbsXDistanceTo(PDFCharacter pdeChar) {
        return Math.abs(this.getXDistanceTo(pdeChar));
    }

    public double getYDistanceTo(PDFCharacter pdeChar) {
        if (this.getEnd().x() != pdeChar.getEnd().x() && this.areCentersAlignedinYDir(pdeChar) || pdeChar.getTextRun().isHorizontalWritingMode() && !pdeChar.getTextRun().isRotatedOrSkewed() && this.areCentersAlignedinYDir(pdeChar)) {
            return this.getCenterLineYDistance(pdeChar);
        }
        if (!pdeChar.getTextRun().isHorizontalWritingMode() && this.areCentersAlignedinXDir(pdeChar)) {
            return this.getCenterLineXDistance(pdeChar);
        }
        if (!pdeChar.getTextRun().isHorizontalWritingMode() && pdeChar.getTextRun().getTsBaselineAngle() == 0.0 && this.getEnd().x() == pdeChar.getEnd().x()) {
            return this.getCenterLineXDistance(pdeChar);
        }
        double angle1 = this.getBaselineAngle();
        if (angle1 == 0.0 && angle1 == pdeChar.getBaselineAngle()) {
            return pdeChar.origin.y() - this.end.y();
        }
        double angle2 = this.end.angleTo(pdeChar.origin);
        double distance = this.end.distanceTo(pdeChar.origin);
        if (angle2 == angle1) {
            return 0.0;
        }
        return distance * Math.sin(angle2 - angle1);
    }

    public double getAbsYDistanceTo(PDFCharacter pdeChar) {
        return Math.abs(this.getYDistanceTo(pdeChar));
    }

    public double getMaxVerticalDistanceTo(PDFCharacter pdeChar) {
        double currentOrigin = this.getOrigin().y();
        double currentEnd = this.getEnd().y();
        double nextOrigin = pdeChar.getOrigin().y();
        double nextEnd = pdeChar.getEnd().y();
        double origToOrig = Math.abs(currentOrigin - nextOrigin);
        double origToEnd = Math.abs(currentOrigin - nextEnd);
        double endToOrig = Math.abs(currentEnd - nextOrigin);
        double endToEnd = Math.abs(currentEnd - nextEnd);
        double maxDistance = origToOrig;
        if (origToEnd > maxDistance) {
            maxDistance = origToEnd;
        }
        if (endToOrig > maxDistance) {
            maxDistance = endToOrig;
        }
        if (endToEnd > maxDistance) {
            maxDistance = endToEnd;
        }
        return maxDistance;
    }

    private static ASQuad mergeQuads(ArrayList<ASQuad> quads) {
        double left = 0.0;
        double right = 0.0;
        double top = 0.0;
        double bottom = 0.0;
        int arraySize = quads.size();
        ASQuad[] quadsArray = quads.toArray(new ASQuad[arraySize]);
        ASCoordinate aCorner = quadsArray[0].p1();
        right = left = aCorner.x();
        bottom = top = aCorner.y();
        for (int i = 0; i < arraySize; ++i) {
            ASQuad quad = quadsArray[i];
            double p1x = quad.p1().x();
            double p3x = quad.p3().x();
            double p1y = quad.p1().y();
            double p3y = quad.p3().y();
            if (p1x < left) {
                left = p1x;
            }
            if (p3x < left) {
                left = p3x;
            }
            if (p1x > right) {
                right = p1x;
            }
            if (p3x > right) {
                right = p3x;
            }
            if (p1y > top) {
                top = p1y;
            }
            if (p3y > top) {
                top = p3y;
            }
            if (p1y < bottom) {
                bottom = p1y;
            }
            if (!(p3y < bottom)) continue;
            bottom = p3y;
        }
        ASRectangle rect = new ASRectangle(left, bottom, right, top);
        return new ASQuad(rect);
    }

    public static List<ASQuad> createBoundingQuads(List<PDFCharacter> chars) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ArrayList<ASQuad> quads = new ArrayList<ASQuad>();
        ArrayList<ASQuad> tempRegQuads = new ArrayList<ASQuad>();
        TextRun currentTextRun = null;
        ASMatrix currentTextRunCTM = null;
        int startIndex = 0;
        int lastIndex = 0;
        for (PDFCharacter pdeChar : chars) {
            if (currentTextRun == null) {
                currentTextRun = pdeChar.getTextRun();
                currentTextRunCTM = currentTextRun.getTextSpaceToDeviceSpaceCTM();
                lastIndex = startIndex = pdeChar.getIndex();
                continue;
            }
            if (pdeChar.getTextRun() == currentTextRun && pdeChar.getIndex() == lastIndex + 1) {
                ++lastIndex;
                continue;
            }
            ASQuad quad = currentTextRun.getTextSpaceBoundingQuad(startIndex, lastIndex - startIndex + 1, false);
            quad = quad.transform(currentTextRunCTM);
            if (currentTextRun.isRotatedOrSkewed()) {
                if (!tempRegQuads.isEmpty()) {
                    if (tempRegQuads.size() > 1) {
                        ASQuad regQuad = PDFCharacter.mergeQuads(tempRegQuads);
                        quads.add(regQuad);
                    } else {
                        quads.add(tempRegQuads.get(0));
                    }
                    tempRegQuads.clear();
                }
                quads.add(quad);
            } else {
                tempRegQuads.add(quad);
            }
            currentTextRun = pdeChar.getTextRun();
            currentTextRunCTM = currentTextRun.getTextSpaceToDeviceSpaceCTM();
            lastIndex = startIndex = pdeChar.getIndex();
        }
        if (currentTextRun != null) {
            ASQuad regQuad;
            ASQuad quad = currentTextRun.getTextSpaceBoundingQuad(startIndex, lastIndex - startIndex + 1, false);
            quad = quad.transform(currentTextRunCTM);
            if (currentTextRun.isRotatedOrSkewed()) {
                if (!tempRegQuads.isEmpty()) {
                    if (tempRegQuads.size() > 1) {
                        regQuad = PDFCharacter.mergeQuads(tempRegQuads);
                        quads.add(regQuad);
                    } else {
                        quads.add(tempRegQuads.get(0));
                    }
                    tempRegQuads.clear();
                }
                quads.add(quad);
            } else {
                tempRegQuads.add(quad);
            }
            if (!tempRegQuads.isEmpty()) {
                if (tempRegQuads.size() > 1) {
                    regQuad = PDFCharacter.mergeQuads(tempRegQuads);
                    quads.add(regQuad);
                } else {
                    quads.add(tempRegQuads.get(0));
                }
            }
        }
        return quads;
    }

    public static String createUnicodeString(ArrayList<?> chars) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        StringBuilder unicodeBuffer = new StringBuilder();
        int listSize = chars.size();
        for (int i = 0; i < listSize; ++i) {
            PDFCharacter nextCharacter;
            PDFCharacter currentCharacter;
            PDFCharacter baseCharacter = currentCharacter = (PDFCharacter)chars.get(i);
            PDFCharacter pDFCharacter = nextCharacter = i < listSize - 1 ? (PDFCharacter)chars.get(i + 1) : null;
            if (listSize > 1) {
                baseCharacter = i == listSize - 1 ? (PDFCharacter)chars.get(i - 1) : (PDFCharacter)chars.get(i + 1);
            }
            char[] charArr = currentCharacter.getUnicodeString().toCharArray();
            String baseUnicodeString = baseCharacter.getUnicodeString();
            if (baseUnicodeString.length() != 0) {
                for (int idx = 0; idx < charArr.length; ++idx) {
                    int sub = PDFCharacter.getPUASubstituteHost(baseCharacter.getUnicodeString().charAt(0), charArr[idx]);
                    if (sub != -1) {
                        charArr[idx] = (char)sub;
                    }
                    char currentChar = charArr[0];
                    if (nextCharacter == null || currentChar < '\u0e00' || currentChar > '\u0e7f') continue;
                    char nextChar = nextCharacter.getUnicodeString().charAt(0);
                    if (currentChar != '\u0e4d' || nextChar != '\u0e32') continue;
                    charArr[idx] = 3635;
                    chars.remove(i + 1);
                    --listSize;
                }
            }
            unicodeBuffer.append(charArr);
        }
        return unicodeBuffer.toString();
    }

    public char getUnicodeChar(int[] unicodes) {
        return (char)unicodes[0];
    }

    public CharacterScript useLegacyCharacterScriptComputation(int[] unicodes) {
        int uniChar = 0;
        for (int i = 0; i < unicodes.length; ++i) {
            if (unicodes[i] == -1) continue;
            uniChar = (char)unicodes[i];
        }
        if (uniChar <= 127) {
            return CharacterScript.ROMAN;
        }
        if (uniChar >= 1536 && uniChar <= 1791 || uniChar >= 1872 && uniChar <= 1919 || uniChar >= 64336 && uniChar <= 65023 || uniChar >= 65136 && uniChar <= 65279) {
            return CharacterScript.ARABIC;
        }
        if (uniChar >= 1424 && uniChar <= 1535) {
            return CharacterScript.HEBREW;
        }
        if (uniChar >= 3584 && uniChar <= 3711) {
            return CharacterScript.THAI;
        }
        if (uniChar >= 768 && uniChar <= 879 || uniChar >= 7616 && uniChar <= 7679 || uniChar >= 8400 && uniChar <= 8447 || uniChar >= 65056 && uniChar <= 65071) {
            return CharacterScript.UNKNOWN;
        }
        return CharacterScript.ROMAN;
    }

    public CharacterScript getCharacterScript(int[] unicodes) {
        int uniChar = 0;
        for (int i = 0; i < unicodes.length; ++i) {
            if (unicodes[i] == -1) continue;
            uniChar = (char)unicodes[i];
        }
        if (scriptToLocaleMap.get(UScript.getScript(uniChar)) != null) {
            return scriptToLocaleMap.get(UScript.getScript(uniChar));
        }
        return this.useLegacyCharacterScriptComputation(unicodes);
    }

    public CharacterScript getScript() {
        return this.script;
    }

    public boolean isRTL() {
        return this.isRTL;
    }

    @Override
    public int compareTo(Object o) {
        if (o instanceof PDFCharacter) {
            PDFCharacter c = (PDFCharacter)o;
            if (this.id < c.id) {
                return -1;
            }
            if (this.id > c.id) {
                return 1;
            }
            return 0;
        }
        throw new PDFRuntimeException("Expected comparisons only of objects of class Character");
    }

    static {
        scriptToLocaleMap.put(20, CharacterScript.HIRAGANA);
        scriptToLocaleMap.put(22, CharacterScript.KATAKANA);
        scriptToLocaleMap.put(17, CharacterScript.HANI);
        scriptToLocaleMap.put(73, CharacterScript.SIMPLIFIED_HAN);
        scriptToLocaleMap.put(74, CharacterScript.TRADITIONAL_HAN);
        scriptToLocaleMap.put(105, CharacterScript.JAPANESE);
        scriptToLocaleMap.put(18, CharacterScript.HANGUL);
        scriptToLocaleMap.put(19, CharacterScript.HEBREW);
        scriptToLocaleMap.put(25, CharacterScript.ROMAN);
        scriptToLocaleMap.put(38, CharacterScript.THAI);
        scriptToLocaleMap.put(2, CharacterScript.ARABIC);
        scriptToLocaleMap.put(19, CharacterScript.HEBREW);
        scriptToLocaleMap.put(0, CharacterScript.ROMAN);
        gPUATable_Thai = new int[]{3600, 3636, 3637, 3638, 3639, 3656, 3657, 3658, 3659, 3660, 3656, 3657, 3658, 3659, 3660, 3597, 3633, 3661, 3655, 3656, 3657, 3658, 3659, 3660, 3640, 3641, 3642};
        gPUASubTable = new PUASubHubEntry[]{new PUASubHubEntry(3584, 3711, 63232, 63258, gPUATable_Thai)};
    }
}

