/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.pdf.content;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import java.util.ArrayList;
import java.util.Iterator;

public class OperandStack
implements Cloneable {
    protected ArrayList<Object> mStack;

    public OperandStack() {
        this.mStack = new ArrayList();
    }

    protected OperandStack(ArrayList<Object> aList) {
        this.mStack = aList;
    }

    public Iterator<Object> iterator() {
        return this.mStack.iterator();
    }

    public void pushBoolean(ASBoolean bool) {
        this.mStack.add(bool);
    }

    public void pushArray(ASArray bool) {
        this.mStack.add(bool);
    }

    public void pushDictionary(ASDictionary dictionary) {
        this.mStack.add(dictionary);
    }

    public void pushName(ASName name) {
        this.mStack.add(name);
    }

    public void pushString(ASString string) {
        this.mStack.add(string);
    }

    public void pushASNumber(ASNumber number) {
        this.mStack.add(number);
    }

    public void pushInputByteStream(InputByteStream ibs) {
        this.mStack.add(ibs);
    }

    public boolean peekTypeIsNumber() {
        Object object = this.peek();
        return object instanceof ASNumber;
    }

    public boolean peekTypeIsInputByteStream() {
        Object object = this.peek();
        return object instanceof InputByteStream;
    }

    public boolean peekTypeIsBoolean() {
        Object object = this.peek();
        return object instanceof ASBoolean;
    }

    public boolean peekTypeIsDictionary() {
        Object object = this.peek();
        return object instanceof ASDictionary;
    }

    public boolean peekTypeIsArray() {
        Object object = this.peek();
        return object instanceof ASArray;
    }

    public boolean peekTypeIsName() {
        Object object = this.peek();
        return object instanceof ASName;
    }

    public boolean peekTypeIsString() {
        Object object = this.peek();
        return object instanceof ASString;
    }

    public ASNumber peekNumber() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof ASNumber)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASNumber was expected for the object " + object);
        }
        return (ASNumber)object;
    }

    public InputByteStream peekInputByteStream() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof InputByteStream)) {
            throw new PDFInvalidContentException("Unexpected operand type: InputByteStream was expected for the object " + object);
        }
        return (InputByteStream)object;
    }

    public String toString() {
        StringBuilder str = new StringBuilder("");
        for (int i = 0; i < this.mStack.size(); ++i) {
            Object operand = this.mStack.get(i);
            if (operand instanceof ASString) {
                str.append("(").append(((ASString)operand).asString()).append(") ");
                continue;
            }
            if (operand instanceof ASHexString) {
                str.append("<").append(((ASHexString)operand).asString()).append("> ");
                continue;
            }
            str.append(this.mStack.get(i).toString()).append(" ");
        }
        return str.toString();
    }

    public ASBoolean peekBoolean() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof ASBoolean)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASBoolean was expected for the object " + object);
        }
        return (ASBoolean)object;
    }

    public ASArray peekArray() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof ASArray)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASArray was expected for the object " + object);
        }
        return (ASArray)object;
    }

    public ASDictionary peekDictionary() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof ASDictionary)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASDictionary was expected for the object " + object);
        }
        return (ASDictionary)object;
    }

    public ASName peekName() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof ASName)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASName was expected for the object " + object);
        }
        return (ASName)object;
    }

    public ASString peekString() throws PDFInvalidContentException {
        Object object = this.peek();
        if (!(object instanceof ASString)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASString was expected for the object " + object);
        }
        return (ASString)object;
    }

    public ASNumber popNumber() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof ASNumber)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASNumber was expected for the object " + object);
        }
        return (ASNumber)object;
    }

    public InputByteStream popInputByteStream() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof InputByteStream)) {
            throw new PDFInvalidContentException("Unexpected operand type: InputByteStream was expected for the object " + object);
        }
        return (InputByteStream)object;
    }

    public ASBoolean popBoolean() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof ASBoolean)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASBoolean was expected for the object " + object);
        }
        return (ASBoolean)object;
    }

    public ASDictionary popDictionary() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof ASDictionary)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASDictionary was expected for the object " + object);
        }
        return (ASDictionary)object;
    }

    public ASArray popArray() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof ASArray)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASArray was expected for the object " + object);
        }
        return (ASArray)object;
    }

    public ASName popName() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof ASName)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASName was expected for the object " + object);
        }
        return (ASName)object;
    }

    public ASString popString() throws PDFInvalidContentException {
        Object object = this.pop();
        if (!(object instanceof ASString)) {
            throw new PDFInvalidContentException("Unexpected operand type: ASString was expected for the object " + object);
        }
        return (ASString)object;
    }

    public ASDictionary stackToImageDictionary() throws PDFInvalidContentException {
        ASDictionary dict = new ASDictionary();
        int i = this.mStack.size() - 1;
        while (i > 0) {
            Object operand;
            if ((operand = this.mStack.get(i--)) instanceof InputByteStream) continue;
            Object value = operand;
            ASName key = (ASName)this.mStack.get(i--);
            dict.put(key, (ASObject)value);
        }
        return dict;
    }

    public Object peek() {
        return this.mStack.get(this.mStack.size() - 1);
    }

    public Object pop() {
        return this.mStack.remove(this.mStack.size() - 1);
    }

    public void push(Object obj) {
        this.mStack.add(obj);
    }

    public boolean isEmpty() {
        return this.mStack.isEmpty();
    }

    public int getSize() {
        return this.mStack.size();
    }

    protected OperandStack clone() {
        if (this.mStack != null) {
            ArrayList copy = (ArrayList)this.mStack.clone();
            return new OperandStack(copy);
        }
        return null;
    }
}

