/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.graphicsDOM.utils;

import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.image.ImageInputSource;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidParameterException;

public class ImageInputSourceImpl<T>
implements ImageInputSource {
    private static final int readLimit = 0x4000000;
    private T inputSource;
    private ResettableInputStream ris = null;
    private boolean mark = false;

    public ImageInputSourceImpl(T inputSource, boolean mark) {
        if (!(inputSource instanceof CosStream) && !(inputSource instanceof InputStream)) {
            throw new InvalidParameterException("CosStream or InputStream was expected.");
        }
        this.inputSource = inputSource;
        this.mark = mark;
    }

    @Override
    public InputStream getImageInputStream() throws IOException {
        try {
            if (this.ris != null) {
                if (this.ris.totalBytesRead == 0L) {
                    return this.ris;
                }
                if (this.mark && this.ris.markSupported() && this.ris.totalBytesRead < 0x4000000L) {
                    this.ris.reset();
                    return this.ris;
                }
            }
            InputStream decodedStream = null;
            if (this.inputSource instanceof InputStream) {
                decodedStream = (InputStream)this.inputSource;
            } else if (this.inputSource instanceof CosStream) {
                CosStream cosObj = (CosStream)this.inputSource;
                decodedStream = cosObj.getStreamDecodedNoCopying();
            }
            this.ris = new ResettableInputStream(decodedStream);
            if (this.mark && this.ris.markSupported()) {
                this.ris.mark(0x4000000);
            }
            return this.ris;
        }
        catch (PDFSecurityException e) {
            throw new IOException(e);
        }
        catch (PDFCosParseException e) {
            throw new IOException(e);
        }
        catch (PDFIOException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.ris != null) {
            this.ris.close();
        }
        this.inputSource = null;
    }

    private static class ResettableInputStream
    extends InputStream {
        private InputStream sourceIS = null;
        private long totalBytesRead = 0L;

        private ResettableInputStream(InputStream is) {
            this.sourceIS = is;
        }

        @Override
        public int read() throws IOException {
            ++this.totalBytesRead;
            return this.sourceIS.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int bytesRead = this.sourceIS.read(b, off, len);
            this.totalBytesRead += (long)bytesRead;
            return bytesRead;
        }

        @Override
        public long skip(long n) throws IOException {
            long bytesRead = this.sourceIS.skip(n);
            this.totalBytesRead += bytesRead;
            return bytesRead;
        }

        @Override
        public int available() throws IOException {
            return this.sourceIS.available();
        }

        @Override
        public void close() throws IOException {
            this.sourceIS.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            this.sourceIS.mark(readlimit);
        }

        @Override
        public synchronized void reset() throws IOException {
            this.sourceIS.reset();
        }

        @Override
        public boolean markSupported() {
            return this.sourceIS.markSupported();
        }
    }
}

