/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.DoubleToStringFormatter;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;

public class ASNumber
extends ASObject {
    private static final DecimalFormat mDecimalFormat;
    private static final DoubleToStringFormatter customFormatter;
    private ASString strVal;
    private Number numVal;

    public ASNumber(ASString value) throws PDFParseException {
        this.strVal = value;
        this.numVal = ASNumber.convertString(value);
    }

    public ASNumber(String value) throws PDFParseException {
        this.strVal = new ASString(value);
        this.numVal = ASNumber.convertString(this.strVal);
    }

    void compareTo(ASString value) throws PDFParseException {
        Number oldVal = null;
        try {
            NumberFormat parser = NumberFormat.getInstance(Locale.US);
            oldVal = parser.parse(value.asString());
        }
        catch (ParseException e) {
            throw new PDFParseException(e);
        }
        boolean bad = false;
        if (oldVal == null) {
            if (this.numVal != null) {
                bad = true;
            }
        } else if (oldVal instanceof Long) {
            if (!(this.numVal instanceof Long)) {
                bad = true;
            } else if (((Long)oldVal).compareTo((Long)this.numVal) != 0) {
                bad = true;
            }
        } else if (oldVal instanceof Double) {
            if (!(this.numVal instanceof Double)) {
                bad = true;
            } else if (((Double)oldVal).compareTo((Double)this.numVal) != 0) {
                bad = true;
            }
        } else {
            bad = true;
        }
        if (bad) {
            System.out.println("ASNumber value compare error");
        }
    }

    public ASNumber(ASNumber value) {
        this.strVal = value.strValue();
        this.numVal = value.numberValue();
    }

    public ASNumber(Number value) {
        this.strVal = new ASString(String.valueOf(value.longValue()));
        this.numVal = value;
    }

    public ASNumber(Float value) {
        this.strVal = new ASString(ASNumber.doubleToString(value.doubleValue()));
        this.numVal = value;
    }

    public ASNumber(Double value) {
        this.strVal = new ASString(ASNumber.doubleToString(value));
        this.numVal = value;
    }

    public ASNumber(int value) {
        this.strVal = new ASString(String.valueOf(value));
        this.numVal = value;
    }

    public ASNumber(long value) {
        this.strVal = new ASString(String.valueOf(value));
        this.numVal = value;
    }

    public ASNumber(float value) {
        this.strVal = new ASString(ASNumber.doubleToString(value));
        this.numVal = Float.valueOf(value);
    }

    public ASNumber(double value) {
        this.strVal = new ASString(ASNumber.doubleToString(value));
        this.numVal = value;
    }

    public ASString strValue() {
        return this.strVal;
    }

    public String toString() {
        return this.strVal.asString();
    }

    public int intValue() {
        return this.numVal.intValue();
    }

    public long longValue() {
        return this.numVal.longValue();
    }

    public float floatValue() {
        return this.numVal.floatValue();
    }

    public double doubleValue() {
        return this.numVal.doubleValue();
    }

    public Number numberValue() {
        return this.numVal;
    }

    public static String doubleToString(double value) {
        String str = customFormatter.appendFormatted(value);
        if (str != null) {
            return str;
        }
        return mDecimalFormat.format(value);
    }

    private static Number convertString(ASString value) throws PDFParseException {
        int i;
        byte[] bytes = value.getBytes();
        long numVal = 0L;
        int strBeg = 0;
        int strEnd = bytes.length;
        boolean negative = false;
        int decimalAt = -1;
        if (bytes[0] == 45) {
            negative = true;
            ++strBeg;
        } else if (bytes[0] == 43) {
            negative = false;
            ++strBeg;
        }
        while (strBeg < strEnd && bytes[strBeg] == 48) {
            ++strBeg;
        }
        for (i = strBeg; i < strEnd; ++i) {
            if (bytes[i] != 46) continue;
            decimalAt = i;
            break;
        }
        if (decimalAt >= 0) {
            while (bytes[strEnd - 1] == 48) {
                --strEnd;
            }
            if (strEnd - strBeg > 16) {
                try {
                    NumberFormat parser = NumberFormat.getInstance(Locale.US);
                    return bytes[0] == 43 ? (Number)parser.parse(new String(bytes), new ParsePosition(1)) : (Number)parser.parse(new String(bytes));
                }
                catch (ParseException e) {
                    throw new PDFParseException(e);
                }
            }
        }
        for (i = strBeg; i < strEnd; ++i) {
            if (i == decimalAt) continue;
            byte digit = bytes[i];
            if (digit < 48 || digit > 57) {
                throw new PDFParseException("Not a decimal number");
            }
            numVal *= 10L;
            numVal += (long)(digit - 48);
        }
        if (numVal == 0L && negative) {
            return new Double(-0.0);
        }
        if (negative) {
            numVal = 0L - numVal;
        }
        if (decimalAt < 0) {
            if (numVal >= Integer.MIN_VALUE && numVal <= Integer.MAX_VALUE) {
                return (int)numVal;
            }
            return numVal;
        }
        double dblVal = numVal;
        long baseVal = 1L;
        for (int i2 = decimalAt + 1; i2 < strEnd; ++i2) {
            baseVal *= 10L;
        }
        return new Double(dblVal /= (double)baseVal);
    }

    @Override
    public void write(OutputByteStream outputByteStream) throws PDFIOException {
        try {
            outputByteStream.write(this.strValue().getBytes());
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    static {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
        dfs.setZeroDigit('0');
        dfs.setDecimalSeparator('.');
        dfs.setMinusSign('-');
        mDecimalFormat = new DecimalFormat("#0.0####", dfs);
        mDecimalFormat.setGroupingUsed(false);
        customFormatter = new DoubleToStringFormatter(5, '.', '-', true);
    }
}

