/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.types;

import com.adobe.internal.pdftoolkit.core.types.ASName;

class ASNameTrie {
    private ASNameTrie[] childNodes = new ASNameTrie[256];
    private ASName name = null;

    ASNameTrie() {
    }

    private ASNameTrie addChild(ASNameTrie child, byte ch) {
        this.childNodes[ch + 128] = child;
        return child;
    }

    private ASNameTrie getNode(byte ch) {
        return this.childNodes[ch + 128];
    }

    private void setName(ASName name) {
        this.name = name;
    }

    private ASName getName() {
        return this.name;
    }

    void add(ASName name) {
        byte[] nameBytes = name.getBytes();
        this.add(name, nameBytes, 0, nameBytes.length);
    }

    private void add(ASName name, byte[] nameBytes, int start, int end) {
        if (start >= end) {
            return;
        }
        byte ch = nameBytes[start];
        ASNameTrie n = this.getNode(ch);
        if (n == null) {
            ASNameTrie child = new ASNameTrie();
            if ((child = this.addChild(child, ch)) != null) {
                if (start + 1 == end) {
                    child.setName(name);
                } else {
                    child.add(name, nameBytes, start + 1, end);
                }
            }
        } else {
            n.add(name, nameBytes, start + 1, end);
        }
    }

    public ASName get(byte[] nameBytes, int start, int end) {
        if (start >= end) {
            return null;
        }
        byte byteToLook = nameBytes[start];
        ASNameTrie node = this.getNode(byteToLook);
        if (node != null) {
            if (start + 1 == end) {
                return node.getName();
            }
            return node.get(nameBytes, start + 1, end);
        }
        return null;
    }
}

