/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.pdftoolkit.core.filter.DecodeInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.TIFFEngine;
import com.adobe.internal.pdftoolkit.core.filter.TIFFFilterException;
import java.io.IOException;
import java.io.InputStream;

public class TIFFInputStream
extends DecodeInputStream {
    private TIFFEngine tiff;

    public TIFFInputStream(InputStream in, int inSize, int outSize, FilterParams diparams) {
        super(in, inSize, outSize, 1, diparams);
        this.tiff = new TIFFEngine(in, diparams);
    }

    public TIFFInputStream(InputStream in, FilterParams p) {
        super(in, 1, p);
        this.tiff = new TIFFEngine(this, p);
    }

    public TIFFInputStream(InputStream in) {
        this(in, null);
    }

    @Override
    public void fill() {
        int bitsPerComponents = this.tiff.getBitsPerComponent();
        if (bitsPerComponents == 16) {
            while (this.outCount <= this.outBuf.length - 1 && !this.pendingEOF && this.pendingException == null && !this.isByteAvailable()) {
                int channel = 0;
                int result = 0;
                short newChar = (short)(this.inBuf[this.inPos++] & 0xFF);
                channel = (short)(channel | newChar << 8);
                if (this.isByteAvailable()) break;
                newChar = (short)(this.inBuf[this.inPos++] & 0xFF);
                channel = (short)(channel | newChar);
                try {
                    result = this.tiff.applyTIFFPredictor(channel);
                    this.outBuf[this.outCount++] = (byte)((result & 0xFF00) >> 8);
                    this.outBuf[this.outCount++] = (byte)(result & 0xFF);
                }
                catch (IOException e) {
                    this.pendingException = new TIFFFilterException("TIFF error: " + e.getMessage());
                    break;
                }
            }
        } else {
            while (this.outCount <= this.outBuf.length - 1 && !this.pendingEOF && this.pendingException == null) {
                if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
                    this.pendingEOF = true;
                    break;
                }
                char newChar = (char)(this.inBuf[this.inPos++] & 0xFF);
                try {
                    this.outBuf[this.outCount++] = (byte)this.tiff.applyTIFFPredictor(newChar);
                }
                catch (IOException e) {
                    this.pendingException = new TIFFFilterException("TIFF error: " + e.getMessage());
                    break;
                }
            }
        }
    }

    int read1() {
        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
            this.pendingEOF = true;
            return -1;
        }
        return this.inBuf[this.inPos++] & 0xFF;
    }

    private boolean isByteAvailable() {
        if (this.inCount <= this.inPos && !this.fillInputBuffer()) {
            this.pendingEOF = true;
            return true;
        }
        return false;
    }
}

