/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.filter;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.filter.ASCII85InputStream;
import com.adobe.internal.pdftoolkit.core.filter.ASCII85OutputStream;
import com.adobe.internal.pdftoolkit.core.filter.ASCIIHexInputStream;
import com.adobe.internal.pdftoolkit.core.filter.ASCIIHexOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.CCITTFaxInputStream;
import com.adobe.internal.pdftoolkit.core.filter.CCITTFaxOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.DCTInputStream;
import com.adobe.internal.pdftoolkit.core.filter.FilterParams;
import com.adobe.internal.pdftoolkit.core.filter.JPXInputStream;
import com.adobe.internal.pdftoolkit.core.filter.LZWInputStream;
import com.adobe.internal.pdftoolkit.core.filter.LZWOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.RunLengthInputStream;
import com.adobe.internal.pdftoolkit.core.filter.RunLengthOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.TIFFInputStream;
import com.adobe.internal.pdftoolkit.core.filter.TIFFOutputStream;
import com.adobe.internal.pdftoolkit.core.filter.spi.CustomFilterException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASBoolean;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class FilterStream {
    public static FilterParams buildFilterParams(CosObject parmsObj) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        FilterParams result = null;
        if (parmsObj instanceof CosDictionary) {
            result = FilterStream.addToParms(new FilterParams(), (CosDictionary)parmsObj);
        } else if (parmsObj instanceof CosArray) {
            result = new FilterParams();
            for (int i = 0; i < ((CosArray)parmsObj).size(); ++i) {
                CosObject arrayItem = ((CosArray)parmsObj).get(i);
                if (!(arrayItem instanceof CosDictionary)) continue;
                result = FilterStream.addToParms(result, (CosDictionary)arrayItem);
            }
        }
        return result;
    }

    public static FilterParams buildFilterParams(ASObject parmsObj) throws PDFInvalidParameterException {
        FilterParams result = null;
        if (parmsObj instanceof ASDictionary) {
            result = FilterStream.addToParms(new FilterParams(), (ASDictionary)parmsObj);
        } else if (parmsObj instanceof ASArray) {
            result = new FilterParams();
            for (int i = 0; i < ((ASArray)parmsObj).size(); ++i) {
                ASObject arrayItem = ((ASArray)parmsObj).get(i);
                if (!(arrayItem instanceof ASDictionary)) continue;
                result = FilterStream.addToParms(result, (ASDictionary)arrayItem);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FilterParams addToParms(FilterParams result, CosDictionary parmsDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject jbig2Globals;
        CosObject colorspace;
        CosObject bitsPerComponent;
        CosObject drbe;
        CosObject blackIs1;
        CosObject eob;
        CosObject rows;
        CosObject eba;
        CosObject eol;
        CosObject k;
        CosObject earlyChange;
        CosObject colors;
        CosObject columns;
        CosObject predictor = parmsDict.get(ASName.k_Predictor);
        if (predictor != null) {
            result.put("Predictor", ((CosNumeric)predictor).getValue());
        }
        if ((columns = parmsDict.get(ASName.k_Columns)) != null) {
            result.put("Columns", ((CosNumeric)columns).getValue());
        }
        if ((colors = parmsDict.get(ASName.k_Colors)) != null) {
            result.put("Components", ((CosNumeric)colors).getValue());
        }
        if ((earlyChange = parmsDict.get(ASName.k_EarlyChange)) != null) {
            result.put("EarlyChange", ((CosNumeric)earlyChange).getValue());
        }
        if ((k = parmsDict.get(ASName.k_K)) != null) {
            result.put("K", ((CosNumeric)k).getValue());
        }
        if ((eol = parmsDict.get(ASName.k_EndOfLine)) != null) {
            result.put("DoEOL", ((CosBoolean)eol).getValue());
        }
        if ((eba = parmsDict.get(ASName.k_EncodedByteAlign)) != null) {
            result.put("ByteAlign", ((CosBoolean)eba).getValue());
        }
        if ((rows = parmsDict.get(ASName.k_Rows)) != null) {
            result.put("Rows", ((CosNumeric)rows).getValue());
        }
        if ((eob = parmsDict.get(ASName.k_EndOfBlock)) != null) {
            result.put("DoRTC", ((CosBoolean)eob).getValue());
        }
        if ((blackIs1 = parmsDict.get(ASName.k_BlackIs1)) != null) {
            result.put("BlackIs1", ((CosBoolean)blackIs1).getValue());
        }
        if ((drbe = parmsDict.get(ASName.k_DamagedRowsBeforeError)) != null) {
            result.put("DamagedRowsBeforeError", ((CosNumeric)drbe).getValue());
        }
        if ((bitsPerComponent = parmsDict.get(ASName.k_BitsPerComponent)) != null) {
            result.put("BitsPerComponent", ((CosNumeric)bitsPerComponent).getValue());
        }
        if ((colorspace = parmsDict.get(ASName.k_ColorSpace)) != null) {
            result.put("ColorSpace", colorspace);
        }
        if ((jbig2Globals = parmsDict.get(ASName.k_JBIG2Globals)) instanceof CosStream) {
            InputByteStream ibs = null;
            try {
                try {
                    ibs = ((CosStream)jbig2Globals).getStreamDecoded();
                    byte[] data = new byte[(int)ibs.length()];
                    ibs.read(data);
                    result.put("JBIG2Globals", data);
                }
                finally {
                    if (ibs != null) {
                        ibs.close();
                    }
                }
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
        return result;
    }

    private static FilterParams addToParms(FilterParams result, ASDictionary parmsDict) throws PDFInvalidParameterException {
        try {
            ASNumber bitsPerComponent;
            ASNumber drbe;
            ASBoolean blackIs1;
            ASBoolean eob;
            ASNumber rows;
            ASBoolean eba;
            ASBoolean eol;
            ASNumber k;
            ASNumber earlyChange;
            ASNumber colors;
            ASNumber columns;
            ASNumber predictor = parmsDict.getNumber(ASName.k_Predictor);
            if (predictor != null) {
                result.put("Predictor", predictor.intValue());
            }
            if ((columns = parmsDict.getNumber(ASName.k_Columns)) != null) {
                result.put("Columns", columns.intValue());
            }
            if ((colors = parmsDict.getNumber(ASName.k_Colors)) != null) {
                result.put("Components", colors.intValue());
            }
            if ((earlyChange = parmsDict.getNumber(ASName.k_EarlyChange)) != null) {
                result.put("EarlyChange", earlyChange.intValue());
            }
            if ((k = parmsDict.getNumber(ASName.k_K)) != null) {
                result.put("K", k.intValue());
            }
            if ((eol = parmsDict.getBoolean(ASName.k_EndOfLine)) != null) {
                result.put("DoEOL", eol.isTrue());
            }
            if ((eba = parmsDict.getBoolean(ASName.k_EncodedByteAlign)) != null) {
                result.put("ByteAlign", eba.isTrue());
            }
            if ((rows = parmsDict.getNumber(ASName.k_Rows)) != null) {
                result.put("Rows", rows.intValue());
            }
            if ((eob = parmsDict.getBoolean(ASName.k_EndOfBlock)) != null) {
                result.put("DoRTC", eob.isTrue());
            }
            if ((blackIs1 = parmsDict.getBoolean(ASName.k_BlackIs1)) != null) {
                result.put("BlackIs1", blackIs1.isTrue());
            }
            if ((drbe = parmsDict.getNumber(ASName.k_DamagedRowsBeforeError)) != null) {
                result.put("DamagedRowsBeforeError", drbe.intValue());
            }
            if ((bitsPerComponent = parmsDict.getNumber(ASName.k_BitsPerComponent)) != null) {
                result.put("BitsPerComponent", bitsPerComponent.intValue());
            }
            return result;
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException("Invalid decode paramaters dictionary", e);
        }
    }

    public static InputStream applyFilter(InputStream inStm, ASName filterName, FilterParams params, CustomFilterRegistry filterRegistry) throws PDFCosParseException, IOException {
        if (filterRegistry != null) {
            try {
                if (filterRegistry.isDecodeFilterRegistered(filterName)) {
                    return filterRegistry.decode(filterName, inStm, params);
                }
            }
            catch (CustomFilterException e) {
                throw new PDFCosParseException("Unable to use filter registry to decode stream that uses " + filterName, e);
            }
        }
        if (filterName.equals(ASName.k_FlateDecode) || filterName.equals(ASName.k_Fl)) {
            inStm.skip(2L);
            InflaterInputStream result = new InflaterInputStream(inStm, new Inflater(true));
            if (params != null && params.containsKey("Predictor") && (Integer)params.get("Predictor") != 1) {
                return new TIFFInputStream(result, params);
            }
            return result;
        }
        if (filterName.equals(ASName.k_ASCII85Decode) || filterName.equals(ASName.k_A85)) {
            return new ASCII85InputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_ASCIIHexDecode) || filterName.equals(ASName.k_AHx)) {
            return new ASCIIHexInputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_LZWDecode) || filterName.equals(ASName.k_LZW)) {
            return new LZWInputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_Crypt)) {
            return inStm;
        }
        if (filterName.equals(ASName.k_CCITTFaxDecode) || filterName.equals(ASName.k_CCF)) {
            return new CCITTFaxInputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_DCTDecode) || filterName.equals(ASName.k_DCT)) {
            return new DCTInputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_RunLengthDecode) || filterName.equals(ASName.k_RL)) {
            return new RunLengthInputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_JPXDecode)) {
            return JPXInputStream.getJPXInputStream(inStm);
        }
        throw new PDFCosParseException("Undefined filter - " + filterName.asString(true));
    }

    public static OutputStream applyFilter(OutputStream inStm, ASName filterName, FilterParams params, CustomFilterRegistry filterRegistry) throws PDFCosParseException {
        if (filterRegistry != null) {
            try {
                if (filterRegistry.isEncodeFilterRegistered(filterName)) {
                    return filterRegistry.encode(filterName, inStm, params);
                }
            }
            catch (CustomFilterException e) {
                throw new PDFCosParseException("Unable to use filter registry to encode stream that uses " + filterName, e);
            }
        }
        if (filterName.equals(ASName.k_FlateDecode) || filterName.equals(ASName.k_Fl)) {
            FilterOutputStream result = new FilterOutputStream(inStm, new Deflater(9));
            if (params != null && params.containsKey("Predictor") && (Integer)params.get("Predictor") != 1) {
                return new TIFFOutputStream(result, params);
            }
            return result;
        }
        if (filterName.equals(ASName.k_ASCII85Decode) || filterName.equals(ASName.k_A85)) {
            return new ASCII85OutputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_ASCIIHexDecode) || filterName.equals(ASName.k_AHx)) {
            return new ASCIIHexOutputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_LZWDecode) || filterName.equals(ASName.k_LZW)) {
            return new LZWOutputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_RunLengthDecode) || filterName.equals(ASName.k_RL)) {
            return new RunLengthOutputStream(inStm);
        }
        if (filterName.equals(ASName.k_CCITTFaxDecode) || filterName.equals(ASName.k_CCF)) {
            return new CCITTFaxOutputStream(inStm, params);
        }
        if (filterName.equals(ASName.k_Crypt)) {
            return inStm;
        }
        throw new PDFCosParseException("Undefined filter - " + filterName.asString(true));
    }

    public static InputStream applyFilter(InputStream srcStm, ASName curFilter, FilterParams params) throws PDFCosParseException, IOException {
        return FilterStream.applyFilter(srcStm, curFilter, params, null);
    }

    public static OutputStream applyFilter(OutputStream inStm, ASName filterName, FilterParams params) throws PDFCosParseException {
        return FilterStream.applyFilter(inStm, filterName, params, null);
    }

    public static CosObject updateCustomFilterParams(ASName filterName, CosObject params, CustomFilterRegistry filterRegistry) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (filterRegistry != null && filterRegistry.isEncodeFilterRegistered(filterName)) {
            FilterParams fParams = FilterStream.buildFilterParams(params);
            if ((fParams = filterRegistry.updateFilterParams(filterName, fParams)) == null) {
                return null;
            }
            return fParams.toCosObject(params.getDocument());
        }
        return params;
    }

    public static ASDictionary updateCustomFilterParams(ASName filterName, ASDictionary params, CustomFilterRegistry filterRegistry) throws PDFInvalidParameterException {
        if (filterRegistry != null && filterRegistry.isEncodeFilterRegistered(filterName)) {
            FilterParams fParams = FilterStream.buildFilterParams(params);
            if ((fParams = filterRegistry.updateFilterParams(filterName, fParams)) == null) {
                return null;
            }
            return fParams.toASDictionary();
        }
        return params;
    }

    static class FilterOutputStream
    extends DeflaterOutputStream {
        FilterOutputStream(OutputStream out, Deflater def) {
            super(out, def);
        }

        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                if (this.def != null) {
                    this.def.end();
                }
            }
        }
    }
}

