/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.encryption.GeneralSecurityManager;
import com.adobe.internal.pdftoolkit.core.encryption.PBSHStandardCipher;
import com.adobe.internal.pdftoolkit.core.encryption.PKISecurityHandler;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import java.util.Map;

public class StandardCipherSecurityManager
extends GeneralSecurityManager
implements SecurityManager {
    public static final String FILTER = "Filter";
    private byte[] password;
    private byte[] owner;
    private byte[] user;
    private SecurityHandler standardMgr = null;

    public StandardCipherSecurityManager(byte[] password, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.password = password;
        this.owner = null;
        this.user = null;
        this.standardMgr = PBSHStandardCipher.newInstance(this.password, providers);
        super.addSecurityHandler("Standard", this.standardMgr);
    }

    public StandardCipherSecurityManager(Credentials recipient, Map encryptParams, SecurityProvidersImpl providers) {
        this.standardMgr = new PKISecurityHandler(recipient, providers);
        String handlerName = (String)encryptParams.get(FILTER);
        if (handlerName == null) {
            handlerName = "";
        }
        super.addSecurityHandler(handlerName, this.standardMgr);
    }

    public StandardCipherSecurityManager(Map encryptParams, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.standardMgr = new PKISecurityHandler(encryptParams, providers);
        String handlerName = (String)encryptParams.get(FILTER);
        if (handlerName == null) {
            handlerName = "";
        }
        super.addSecurityHandler(handlerName, this.standardMgr);
    }

    public StandardCipherSecurityManager(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        this.owner = owner;
        this.user = user;
        this.password = null;
        this.standardMgr = PBSHStandardCipher.newInstance(this.owner, this.user, encrypt, encryptionPermissions, providers);
        super.addSecurityHandler("Standard", this.standardMgr);
    }

    public static StandardCipherSecurityManager newInstance(byte[] password) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(password, null);
    }

    public static StandardCipherSecurityManager newInstance(byte[] password, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(password, providers);
    }

    public static StandardCipherSecurityManager newInstance(Credentials recipient, Map encryptParams) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(recipient, encryptParams, null);
    }

    public static StandardCipherSecurityManager newInstance(Credentials recipient, Map encryptParams, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(recipient, encryptParams, providers);
    }

    public static StandardCipherSecurityManager newInstance(Map encryptParams) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(encryptParams, null);
    }

    public static StandardCipherSecurityManager newInstance(Map encryptParams, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(encryptParams, providers);
    }

    public static StandardCipherSecurityManager newInstance(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(owner, user, encrypt, encryptionPermissions, null);
    }

    public static StandardCipherSecurityManager newInstance(byte[] owner, byte[] user, PermissionProvider encryptionPermissions) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(owner, user, null, encryptionPermissions, null);
    }

    public static StandardCipherSecurityManager newInstance(byte[] owner, byte[] user, Map encrypt, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(owner, user, encrypt, encryptionPermissions, providers);
    }

    public static StandardCipherSecurityManager newInstance(byte[] owner, byte[] user, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        return new StandardCipherSecurityManager(owner, user, null, encryptionPermissions, providers);
    }
}

