/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.encryption;

import com.adobe.internal.pdftoolkit.core.encryption.JCEAESEncryptionHandler;
import com.adobe.internal.pdftoolkit.core.encryption.JCECipherEncryptionHandler;
import com.adobe.internal.pdftoolkit.core.encryption.JCERC4EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityAuthorizationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.impl.SecurityProvidersImpl;
import java.security.MessageDigest;
import java.util.Map;

final class EncryptionKeyImpl {
    static final String LENGTH = "Length";
    static final String CF = "CF";
    static final String AES_TRANSFORM = "AES/CBC/PKCS5Padding";
    static final String AESV3_TRANSFORM = "AES/CBC/NoPadding";
    static final String AES = "AES/CBC/PKCS5Padding".substring(0, "AES/CBC/PKCS5Padding".indexOf(47));
    static final String V2 = "V2";
    static final String METADATA = "EncryptMetadata";
    static final String AUTH_EVENT = "AuthEvent";
    static final String RC4 = "RC4";
    static final String DOC_OPEN = "DocOpen";
    static final String IDENTITY = "Identity";
    static final String CFM = "CFM";
    static final String AESV2 = "AESV2";
    static final String AESV3 = "AESV3";
    static final String STMF = "StmF";
    static final String EFF = "EFF";
    static final String REVISION = "R";
    static final String VERSION = "V";
    static final byte[] defaultMetadataMark = new byte[]{-1, -1, -1, -1};

    private EncryptionKeyImpl() {
    }

    static int calculateEncryptionKey(Map encryptParms, String cryptName, int defaultLength) {
        Map cryptDict;
        int length;
        int n = length = encryptParms.containsKey(LENGTH) ? ((Number)encryptParms.get(LENGTH)).intValue() : defaultLength;
        if (cryptName != null && encryptParms.containsKey(CF) && (cryptDict = EncryptionKeyImpl.getCryptDict(encryptParms, cryptName)) != null && cryptDict.containsKey(LENGTH) && (length = ((Number)cryptDict.get(LENGTH)).intValue()) < 40) {
            length *= 8;
        }
        return length;
    }

    static Map getCFDict(Map encryptParams) {
        return (Map)encryptParams.get(CF);
    }

    static Map getCryptDict(Map encryptParams, String cryptName) {
        Map cfDict = EncryptionKeyImpl.getCFDict(encryptParams);
        return cfDict != null ? (Map)cfDict.get(cryptName) : null;
    }

    static String getEncryptionAlgorithm(Map encryptParams, String cryptName) throws PDFSecurityConfigurationException, PDFSecurityAuthorizationException {
        String algorithm = RC4;
        Map cryptDict = EncryptionKeyImpl.getCryptDict(encryptParams, cryptName);
        if (cryptDict != null) {
            String cfmVal = (String)cryptDict.get(CFM);
            if (!(cfmVal == null || AESV2.equals(cfmVal) || AESV3.equals(cfmVal) || V2.equals(cfmVal))) {
                throw new PDFSecurityConfigurationException("Illegal CFM value " + cfmVal);
            }
            if (AESV2.equals(cfmVal) || AESV3.equals(cfmVal)) {
                algorithm = AES_TRANSFORM;
            }
        }
        return algorithm;
    }

    static boolean toEncryptMetadata(Map encryptParams, String cryptFilter) {
        Map cryptDict;
        Boolean toEncrypt = (Boolean)encryptParams.get(METADATA);
        if (toEncrypt == null && cryptFilter != null && (cryptDict = EncryptionKeyImpl.getCryptDict(encryptParams, cryptFilter)) != null) {
            toEncrypt = (Boolean)cryptDict.get(METADATA);
        }
        return toEncrypt == null || toEncrypt != false;
    }

    static EncryptionHandler getEncryptionHandler(byte[] encryptKey, String algorithm, MessageDigest md5Digest, Map encryptParams, SecurityProvidersImpl providers) throws PDFSecurityConfigurationException {
        JCECipherEncryptionHandler encryptionHandler;
        JCECipherEncryptionHandler jCECipherEncryptionHandler = AES_TRANSFORM.equals(algorithm) ? new JCEAESEncryptionHandler(encryptKey, md5Digest, providers == null ? null : providers.requireAES(), providers == null ? null : providers.getSHA1PRNG(), providers == null ? null : providers.getRandomGenerator()) : (RC4.equals(algorithm) ? new JCERC4EncryptionHandler(encryptKey, md5Digest, false, providers == null ? null : providers.getRC4()) : (encryptionHandler = null));
        if (encryptionHandler == null) {
            throw new PDFSecurityConfigurationException(algorithm + " encryption handler is not available.");
        }
        return encryptionHandler;
    }

    static void verifyEncryptionVersion(Map encryptParams, boolean checkRevision) throws PDFSecurityConfigurationException {
        Object verObj = encryptParams.get(VERSION);
        int verInt = -1;
        if (verObj instanceof Number) {
            verInt = ((Number)verObj).intValue();
        }
        if (verInt != 1 && verInt != 2 && verInt != 4 && verInt != 5) {
            throw new PDFSecurityConfigurationException("Unsupported encryption version");
        }
        if (checkRevision) {
            verObj = encryptParams.get(REVISION);
            verInt = -1;
            if (verObj instanceof Number) {
                verInt = ((Number)verObj).intValue();
            }
            if (verInt < 2 || verInt > 6) {
                throw new PDFSecurityConfigurationException("Unsupported encryption version");
            }
        }
    }
}

