/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandler;
import com.adobe.internal.pdftoolkit.core.securityframework.EncryptionHandlerState;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import java.io.IOException;
import java.io.OutputStream;

public class EncryptingOutputStream
extends OutputStream {
    private EncryptionHandlerState mEncryptionHandler;
    private boolean mNeedsEncryption;
    private byte[] mStreamKey;
    private OutputByteStream mOutStream;
    boolean mInitialized;
    boolean mDone;

    EncryptingOutputStream(CosStream cosStream, OutputByteStream destination, EncryptionHandlerState encryptionHandler) throws PDFIOException, PDFSecurityException, PDFCosParseException, IOException {
        this.mNeedsEncryption = cosStream.needsEncryption();
        this.mEncryptionHandler = encryptionHandler;
        this.initialize(cosStream, destination);
    }

    EncryptingOutputStream(CosStream cosStream, OutputByteStream destination) throws PDFIOException, PDFSecurityException, PDFCosParseException, IOException {
        this.mNeedsEncryption = cosStream.needsEncryption();
        if (this.mNeedsEncryption) {
            ASName cryptFilter = cosStream.getCryptFilter();
            EncryptionHandler streamEncryption = cosStream.getDocument().getEncryption().getStreamEncryptionHandler(cryptFilter == null ? null : cryptFilter.asString(true));
            if (streamEncryption == null) {
                throw new PDFSecurityConfigurationException("Cannot find Security Handler for a stream");
            }
            this.mEncryptionHandler = streamEncryption.createEncryptionHandlerState();
        }
        this.initialize(cosStream, destination);
    }

    private void initialize(CosStream cosStream, OutputByteStream destination) throws IOException, PDFSecurityException, PDFCosParseException, PDFIOException {
        if (this.mNeedsEncryption) {
            if (this.mEncryptionHandler == null) {
                throw new PDFSecurityConfigurationException("Cannot find Security Handler for a stream");
            }
            this.mStreamKey = cosStream.getDocument().getEncryption().getStreamEncryptionKey(cosStream, true);
        }
        this.mOutStream = destination;
        this.mInitialized = false;
        this.mDone = false;
    }

    @Override
    public void write(int buffer) throws IOException {
        byte[] in = new byte[]{(byte)buffer};
        this.write(in);
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        this.write(buffer, 0, buffer.length);
    }

    @Override
    public void write(byte[] buffer, int off, int len) throws IOException {
        if (this.mDone) {
            throw new IOException("Cannot write to a closed stream");
        }
        byte[] decrypted = buffer;
        int offset = off;
        int bufLen = len;
        try {
            if (this.mNeedsEncryption) {
                byte[] byArray = decrypted = this.mInitialized ? this.mEncryptionHandler.update(buffer, off, len) : this.mEncryptionHandler.init(buffer, off, len, this.mStreamKey, 1);
                if (decrypted == null) {
                    decrypted = new byte[]{};
                }
                offset = 0;
                bufLen = decrypted.length;
                this.mInitialized = true;
            }
            this.mOutStream.write(decrypted, offset, bufLen);
        }
        catch (PDFSecurityException e) {
            IOException excp = new IOException();
            excp.initCause(e);
            throw excp;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.mDone) {
            throw new IOException("Cannot flush closed stream");
        }
        this.mOutStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.mDone) {
            throw new IOException("Cannot close already closed stream");
        }
        if (this.mNeedsEncryption) {
            byte[] encrypted;
            try {
                encrypted = this.mEncryptionHandler.finish();
            }
            catch (PDFSecurityException e) {
                IOException excp = new IOException();
                excp.initCause(e);
                throw excp;
            }
            if (encrypted.length > 0) {
                this.mNeedsEncryption = false;
                this.write(encrypted);
            }
        }
        this.mDone = false;
    }
}

