/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Iterator;

public final class CosUtils {
    private CosUtils() {
    }

    public static CosDictionary cloneOrdinaryKeys(CosDictionary cloned, CosCloneMgr cloneHandler, CosDictionary dict, ASName[] specialKeys) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        Iterator<ASName> keyIterator = dict.keyIterator();
        while (keyIterator.hasNext()) {
            ASName curKey = keyIterator.next();
            if (Utility.nameInArray(curKey, specialKeys)) continue;
            cloned.put(curKey, cloneHandler.clone(dict.get(curKey)));
        }
        return cloned;
    }

    public static CosDictionary cloneOrdinaryKeys(CosDocument toDoc, CosCloneMgr cloneHandler, CosDictionary dict, ASName[] specialKeys) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary cloned = toDoc.createCosDictionary();
        return CosUtils.cloneOrdinaryKeys(cloned, cloneHandler, dict, specialKeys);
    }

    static byte[] digestStream(InputByteStream ibs, String digestAlgorithm) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        byte[] byteStream = new byte[8192];
        MessageDigest digester = null;
        try {
            digester = MessageDigest.getInstance(digestAlgorithm);
            while (ibs.bytesAvailable() > 0L) {
                int numBytesRead = ibs.read(byteStream);
                digester.update(byteStream, 0, numBytesRead);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFSecurityException(e);
        }
        finally {
            try {
                if (ibs != null) {
                    ibs.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException("Problem occured while closing the input byte stream.", e);
            }
        }
        return digester.digest();
    }

    public static <T extends CosObject> int indexOfCosObjectRef(Collection<T> objectList, T obj) {
        int index = 0;
        Iterator<T> itr = objectList.iterator();
        while (itr.hasNext()) {
            if (obj == itr.next()) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

