/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.NullOutputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosEncryption;
import com.adobe.internal.pdftoolkit.core.cos.CosLinearization;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosListInt;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectStream;
import com.adobe.internal.pdftoolkit.core.cos.CosOpenOptions;
import com.adobe.internal.pdftoolkit.core.cos.CosOptimizer;
import com.adobe.internal.pdftoolkit.core.cos.CosPDFOptimizer;
import com.adobe.internal.pdftoolkit.core.cos.CosRepairList;
import com.adobe.internal.pdftoolkit.core.cos.CosSaveParams;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.cos.CosToken;
import com.adobe.internal.pdftoolkit.core.cos.PDFCore;
import com.adobe.internal.pdftoolkit.core.cos.REPAIRTYPE;
import com.adobe.internal.pdftoolkit.core.cos.XRefTable;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.core.util.PDFDocEncoding;
import com.adobe.internal.pdftoolkit.core.util.StringOps;
import com.adobe.internal.pdftoolkit.core.util.Utility;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.rmi.server.UID;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CosDocument {
    private static final String XREF = "xref\n";
    private static final String EOF = "\n%%EOF\n";
    private static final String STARTXREF = "startxref\n";
    private static final int OBJSTM_MAXNUMOBJS = 200;
    private static final byte[] PDF_MARKER = new byte[]{37, 80, 68, 70, 45};
    private static final int[] PDF_MARKER_KMPARRAY = Utility.ComputeKMPNextArray(PDF_MARKER);
    private static final byte[] FDF_MARKER = new byte[]{37, 70, 68, 70, 45};
    private static final int[] FDF_MARKER_KMPARRAY = Utility.ComputeKMPNextArray(FDF_MARKER);
    static final HashSet<ASName> dictionariesNotToBeCompressed = new HashSet();
    private CosOpenOptions mOptions;
    private StreamManager mStreamManager;
    private ByteReader mByteReader;
    private CosEncryption mEncryption;
    private InputByteStream mBuf;
    private XRefTable mXRef;
    private Object[] mUserData = new Object[2];
    private CosList mObjectInfos;
    private CosList mCompObjInfos;
    private int mNumObjects;
    private int mOrigNumObjects;
    private CosLinearization mCosLin;
    private String mToSaveVersion;
    private Map mToSaveExtensions;
    private boolean mToSaveExtensionsInit;
    private static final String MAX_VERSION = "1.7";
    private String mHeader = "%PDF-1.7\r\n";
    private String mHeaderToken;
    private CosDictionary mTrailer;
    private CosDictionary mRoot;
    private boolean mIsFDF;
    private boolean mCacheEnabled = true;
    private int mHeaderTrashCount;
    private int mTrailerTrashCount;
    private boolean mDocIsDirty;
    private boolean mSaveToCopy;
    private boolean mIsLinearized;
    private boolean mWasLinearized;
    private boolean mForceCompress;
    private long garbageLength = 0L;
    private CosRepairList cosRepairList;
    private boolean documentCosLevelRepaired;
    private boolean useRepairList = true;
    private long nextIncrementalSectionOffset = -1L;
    private static String mLoggingPath;
    private EnumSet<REPAIRTYPE> repairTypes = EnumSet.noneOf(REPAIRTYPE.class);

    private CosDocument(CosOpenOptions options) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mOptions = options;
        this.mStreamManager = StreamManager.newInstance(options.getByteWriterFactory(), null);
        this.mEncryption = new CosEncryption(null);
        this.init();
        this.mEncryption.setupDecryption();
    }

    private CosDocument(ByteReader byteReader, CosOpenOptions options) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mOptions = options;
        this.mByteReader = byteReader;
        this.mStreamManager = StreamManager.newInstance(options.getByteWriterFactory(), byteReader);
        this.init(byteReader);
    }

    public static CosDocument newDocument(ByteReader byteReader, CosOpenOptions options) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return new CosDocument(byteReader, options);
    }

    public static CosDocument newDocument(CosOpenOptions options) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return new CosDocument(options);
    }

    public static CosDocument newDocument(PDFCore pdfCore) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (pdfCore == null) {
            throw new PDFUnsupportedFeatureException("PDFCore must be non-null");
        }
        return pdfCore.getCosDoc();
    }

    public StreamManager getStreamManager() {
        return this.mStreamManager;
    }

    /*
     * WARNING - void declaration
     */
    private int[] setWidthsArray(Object list, CosStream xrefStream, long xrefStmPos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        void var14_13;
        ArrayList<Object> secList;
        int[] widths = new int[3];
        long maxW2 = xrefStmPos;
        int maxW3 = 0;
        if (list instanceof ArrayList) {
            secList = (ArrayList<Object>)list;
        } else {
            secList = new ArrayList<Object>();
            secList.add(list);
        }
        for (CosList cosList : secList) {
            Iterator<Object> infoIter = cosList.iterator();
            while (infoIter.hasNext()) {
                int thisW3;
                long thisW2;
                CosObjectInfo info = (CosObjectInfo)infoIter.next();
                if (info.isFree()) continue;
                if (info.isCompressed()) {
                    thisW2 = info.getStreamInfo().getObjNum();
                    thisW3 = info.getStreamNdx();
                } else {
                    thisW2 = info.getPos();
                    thisW3 = info.getObjGen();
                }
                if (thisW2 > maxW2) {
                    maxW2 = thisW2;
                }
                if (thisW3 <= maxW3) continue;
                maxW3 = thisW3;
            }
        }
        widths[0] = 1;
        boolean bl = true;
        while (maxW2 > 255L) {
            ++var14_13;
            maxW2 >>= 8;
        }
        widths[1] = var14_13;
        int widthW3 = 1;
        while (maxW3 > 255) {
            ++widthW3;
            maxW3 >>= 8;
        }
        widths[2] = widthW3;
        CosArray wValues = this.createCosArray();
        wValues.addInt(widths[0]);
        wValues.addInt(widths[1]);
        wValues.addInt(widths[2]);
        xrefStream.put(ASName.k_W, wValues);
        CosDictionary parmsDict = this.createDirectCosDictionary();
        parmsDict.put(ASName.k_Columns, 1 + var14_13 + widthW3);
        parmsDict.put(ASName.k_Predictor, 12);
        xrefStream.put(ASName.k_DecodeParms, parmsDict);
        return widths;
    }

    public PDFCore finish() {
        return new PDFCore(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws PDFIOException, PDFCosParseException, PDFSecurityException {
        try {
            try {
                if (this.mBuf != null) {
                    this.mBuf.close();
                }
            }
            finally {
                try {
                    if (this.mObjectInfos != null) {
                        this.closeAllCosObjects();
                    }
                }
                finally {
                    try {
                        if (this.mXRef != null) {
                            this.mXRef.close();
                        }
                    }
                    finally {
                        if (this.mStreamManager != null) {
                            this.mStreamManager.close();
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        this.mBuf = null;
        this.mEncryption = null;
        this.mObjectInfos = null;
        this.mRoot = null;
        this.mTrailer = null;
        this.mXRef = null;
        this.mStreamManager = null;
    }

    private long headerPos(InputByteStream byteStream) throws IOException {
        byte[] pdfMarker = new byte[]{37, 80, 68, 70, 45};
        int size = 1024;
        if ((long)size > byteStream.length()) {
            size = (int)byteStream.length();
        }
        byte[] header = new byte[size];
        byteStream.seek(0L);
        byteStream.read(header);
        long result = Utility.KMPFindFirst(pdfMarker, Utility.ComputeKMPNextArray(pdfMarker), header);
        if (result >= 0L) {
            byte[] linearizationMarker = new byte[]{47, 76, 105, 110, 101, 97, 114, 105, 122, 101, 100, 32, 49};
            this.mIsLinearized = Utility.KMPFindFirst(linearizationMarker, Utility.ComputeKMPNextArray(linearizationMarker), header) >= 0;
            this.mWasLinearized = this.mIsLinearized;
        }
        return result;
    }

    private long fdfHeaderPos(InputByteStream byteStream) throws IOException {
        byte[] fdfMarker = new byte[]{37, 70, 68, 70, 45};
        int size = 1024;
        if ((long)size > byteStream.length()) {
            size = (int)byteStream.length();
        }
        byte[] header = new byte[size];
        byteStream.seek(0L);
        byteStream.read(header);
        return Utility.KMPFindFirst(fdfMarker, Utility.ComputeKMPNextArray(fdfMarker), header);
    }

    private void init(ByteReader byteReader) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            long eof;
            InputByteStream byteStream = this.mStreamManager.getInputByteStream(byteReader);
            this.initObjectList();
            long hdr = this.headerPos(byteStream);
            this.mHeaderTrashCount = (int)hdr;
            if (hdr < 0L && (hdr = this.fdfHeaderPos(byteStream)) >= 0L) {
                this.mIsFDF = true;
            }
            if ((eof = this.mOptions.getEofValue()) > byteStream.length()) {
                eof = byteStream.length();
                this.mOptions.setEofValue(eof);
            }
            if (hdr < 0L) {
                throw new PDFCosParseException("Stream does not represent a PDF document.");
            }
            if (hdr == 0L && eof == byteStream.length()) {
                this.mBuf = byteStream;
            } else {
                this.mBuf = this.mStreamManager.getInputByteStream(byteReader, hdr, eof - hdr);
                byteStream.close();
            }
            this.mEncryption = new CosEncryption(this);
            this.mXRef = new XRefTable(this, this.mBuf.slice(), this.mOptions.getNoPreloadXRef(), this.mIsFDF);
            try {
                this.mXRef.loadMainInfos();
                this.mXRef.loadUpdateInfos();
                if (this.mOptions != null && this.mOptions.skipCorruptObjects()) {
                    this.linkInfos();
                }
                if (this.garbageLength > 0L) {
                    this.repairTypes.add(REPAIRTYPE.garbageRepair);
                }
            }
            catch (PDFCosParseException e) {
                if (this.mOptions.getRepairEnabled()) {
                    this.mXRef.rebuild();
                    this.repairTypes.add(REPAIRTYPE.xrefRepair);
                }
                throw new PDFCosParseException("XRef repair required but not enabled", e);
            }
            this.mXRef.setupTrailerEncryption();
            CosDictionary trailer = this.mXRef.getTrailer();
            if (!this.mIsFDF) {
                CosObject sz = trailer.get(ASName.k_Size);
                int size = ((CosNumeric)sz).intValue();
                int numObjectsDefinedInXRefEntries = this.mXRef.getNumObjectsDefinedInXRefEntries();
                if (this.mOptions.getRepairEnabled()) {
                    if (size >= numObjectsDefinedInXRefEntries) {
                        this.mOrigNumObjects = this.mNumObjects = size;
                    } else {
                        this.mOrigNumObjects = this.mNumObjects = numObjectsDefinedInXRefEntries;
                        this.repairTypes.add(REPAIRTYPE.sizeEntryRepair);
                    }
                } else {
                    this.mOrigNumObjects = this.mNumObjects = size;
                }
                this.getEncryption().setupDecryption();
            }
            this.mTrailerTrashCount = (int)(this.mBuf.length() - this.mXRef.getRevisionEOF(this.mXRef.getNumRevisions() - 1));
            if (this.mXRef.getNumRevisions() != 1) {
                this.mIsLinearized = false;
            }
            this.mTrailer = trailer;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void linkInfos() {
        Iterator<Object> itr = this.mObjectInfos.iterator();
        CosObjectInfo[] infos = new CosObjectInfo[this.mObjectInfos.count()];
        int index = 0;
        while (itr.hasNext()) {
            infos[index++] = (CosObjectInfo)itr.next();
        }
        Arrays.sort(infos, new Comparator<CosObjectInfo>(){

            @Override
            public int compare(CosObjectInfo o1, CosObjectInfo o2) {
                long pos2;
                long pos1 = o1.getPos();
                if (pos1 == 0L && o1.getStreamInfo() != null) {
                    pos1 = o1.getStreamInfo().getPos();
                }
                if ((pos2 = o2.getPos()) == 0L && o2.getStreamInfo() != null) {
                    pos2 = o2.getStreamInfo().getPos();
                }
                return Long.valueOf(pos1).compareTo(pos2);
            }
        });
        for (int i = 0; i < infos.length - 1; ++i) {
            if (infos[i + 1].getPos() == 0L) {
                if (infos[i + 1].getStreamInfo() == null) continue;
                infos[i].setNextObjPos(infos[i + 1].getStreamInfo().getPos());
                continue;
            }
            infos[i].setNextObjPos(infos[i + 1].getPos());
        }
    }

    private void init() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.initObjectList();
        this.mBuf = null;
        this.mXRef = new XRefTable(this);
        ++this.mNumObjects;
        CosDictionary cosCatalog = this.createCosDictionary(1);
        cosCatalog.put(ASName.k_Type, ASName.k_Catalog);
        this.mXRef.getTrailer().put(ASName.k_Root, cosCatalog);
        this.mEncryption = new CosEncryption(this);
        this.mTrailer = this.mXRef.getTrailer();
    }

    private void initObjectList() {
        this.mNumObjects = 0;
        this.mObjectInfos = new CosList();
        CosObjectInfo freeInfo = this.getObjectInfo(0, 65535);
        freeInfo.markFree();
    }

    public String getOriginalVersion() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String result = null;
        String catalogVersion = null;
        String headerVersion = null;
        CosObject version = this.getRoot().get(ASName.k_Version);
        if (version instanceof CosName) {
            catalogVersion = ((CosName)version).nameValue().asString(true);
        }
        try {
            if (catalogVersion != null) {
                Float.parseFloat(catalogVersion);
                if (catalogVersion.charAt(0) != '1') {
                    catalogVersion = null;
                }
            }
        }
        catch (NumberFormatException e) {
            catalogVersion = null;
        }
        try {
            if (this.mBuf != null) {
                String headerVersionLine;
                int startindx;
                InputByteStream firstK;
                long verpos;
                long size = 1024L;
                if (size > this.mBuf.length()) {
                    size = this.mBuf.length();
                }
                if ((verpos = Utility.KMPFindFirst(PDF_MARKER, PDF_MARKER_KMPARRAY, firstK = this.mBuf.slice(0L, size))) < 0L) {
                    firstK.seek(0L);
                    verpos = Utility.KMPFindFirst(FDF_MARKER, FDF_MARKER_KMPARRAY, firstK);
                }
                if ((startindx = (headerVersionLine = CosToken.readLine(firstK.seek(verpos), true)).indexOf("1.")) == -1) {
                    startindx = headerVersionLine.indexOf("2.");
                }
                if (startindx > 0) {
                    headerVersion = headerVersionLine.substring(startindx, startindx + 3);
                }
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        if (catalogVersion != null && headerVersion != null) {
            int decision = Float.compare(Float.parseFloat(catalogVersion), Float.parseFloat(headerVersion));
            result = decision > 0 ? catalogVersion : headerVersion;
        } else if (catalogVersion != null) {
            result = catalogVersion;
        } else if (headerVersion != null) {
            result = headerVersion;
        }
        return result;
    }

    public String procureOriginalVersion() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String version = this.getOriginalVersion();
        if (version == null) {
            version = MAX_VERSION;
        }
        return version;
    }

    public Map getToSaveExtensions() {
        return this.mToSaveExtensions;
    }

    public void setToSaveExtensions(Map extensions) {
        this.mToSaveExtensions = extensions;
        this.mToSaveExtensionsInit = true;
    }

    public boolean isToSaveExtensionsInitialized() {
        return this.mToSaveExtensionsInit;
    }

    public String getToSaveVersion() {
        return this.mToSaveVersion;
    }

    public void setToSaveVersion(String version) {
        this.mToSaveVersion = version;
    }

    public String procureToSaveVersion() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        String version = this.getToSaveVersion();
        if (version == null) {
            version = this.getOriginalVersion();
        }
        if (version == null) {
            version = MAX_VERSION;
        }
        return version;
    }

    private CosSaveParams normalizeParams(CosSaveParams params) throws PDFCosParseException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        String toSaveVersion;
        params = (CosSaveParams)params.clone();
        String originalVersion = this.getOriginalVersion();
        if (originalVersion == null) {
            originalVersion = MAX_VERSION;
        }
        String string = toSaveVersion = this.mToSaveVersion == null ? params.getVersion() : this.mToSaveVersion;
        if (toSaveVersion == null) {
            toSaveVersion = originalVersion;
        }
        int xrefStyle = params.getXrefStyle();
        int saveStyle = params.getSaveStyle();
        boolean saveToCopy = params.getSaveToCopy();
        if (saveStyle == 0) {
            saveStyle = 2;
        }
        if (saveStyle == 1) {
            int xrefType = this.mXRef.getType();
            xrefStyle = xrefType == 0 ? 1 : (xrefType == 1 ? 2 : 3);
            if (!originalVersion.equals(toSaveVersion)) {
                String[] originalVersionElements = originalVersion.split("\\.");
                int originalVersionMajorVal = Integer.parseInt(originalVersionElements[0]);
                int originalVersionMinorVal = 0;
                if (originalVersionElements.length > 1) {
                    originalVersionMinorVal = Integer.parseInt(originalVersionElements[1]);
                }
                String[] toSaveVersionElements = toSaveVersion.split("\\.");
                int toSaveVersionMajorVal = Integer.parseInt(toSaveVersionElements[0]);
                int toSaveVersionMinorVal = 0;
                if (toSaveVersionElements.length > 1) {
                    toSaveVersionMinorVal = Integer.parseInt(toSaveVersionElements[1]);
                }
                if (toSaveVersionMajorVal == 1 && toSaveVersionMinorVal < 4) {
                    throw new PDFInvalidParameterException("Cannot change the version during an incremental save to PDF 1.3 and earlier");
                }
                if (toSaveVersionMajorVal < originalVersionMajorVal) {
                    throw new PDFInvalidParameterException("Cannot lower version in incremental save");
                }
                if (toSaveVersionMajorVal == originalVersionMajorVal && toSaveVersionMinorVal < originalVersionMinorVal) {
                    throw new PDFInvalidParameterException("Cannot lower version in incremental save");
                }
                this.getRoot().put(ASName.k_Version, ASName.create(toSaveVersion));
            }
        } else {
            if (saveToCopy && saveStyle == 3) {
                throw new PDFInvalidParameterException("SaveToCopy mode does not support linear save");
            }
            if (params.getHeader() != null) {
                this.mHeader = params.getHeader();
            } else {
                this.mHeaderToken = params.getHeaderToken();
                if (this.mHeaderToken != null) {
                    if (this.mHeaderToken.length() > 10) {
                        throw new PDFInvalidParameterException("Header token too long");
                    }
                    for (int i = 0; i < this.mHeaderToken.length(); ++i) {
                        char c = this.mHeaderToken.charAt(i);
                        if (c != '\r' && c != '\n' && (c & 0xFF00) == 0) continue;
                        throw new PDFInvalidParameterException("Illegal header token");
                    }
                }
                this.buildHeaderString(toSaveVersion);
            }
            if (xrefStyle == 0) {
                int xrefType;
                xrefStyle = this.mXRef.isNew() ? 1 : ((xrefType = this.mXRef.getType()) == 0 ? 1 : (xrefType == 1 ? 2 : 3));
            }
            if (xrefStyle == 2) {
                float versionVal = 0.0f;
                versionVal = Float.parseFloat(toSaveVersion);
                if ((double)versionVal < 1.5) {
                    xrefStyle = 3;
                }
            }
            if (xrefStyle == 3 && this.getRoot().get(ASName.k_StructTreeRoot) == null) {
                xrefStyle = 1;
            }
            this.getRoot().remove(ASName.k_Version);
        }
        if (this.mHeader.indexOf("%FDF-") >= 0) {
            this.mIsFDF = true;
        }
        if (this.mIsFDF) {
            if (saveStyle != 2) {
                throw new PDFInvalidParameterException("FDF mode supports full save only");
            }
            xrefStyle = 1;
        }
        params.setHeader(this.mHeader);
        params.setVersion(toSaveVersion);
        params.setXrefStyle(xrefStyle);
        params.setSaveStyle(saveStyle);
        this.mForceCompress = params.getForceCompress();
        this.mSaveToCopy = saveToCopy;
        return params;
    }

    public CosDictionary getTrailer() {
        if (this.mTrailer == null && this.mXRef != null) {
            this.mTrailer = this.mXRef.getTrailer();
        }
        return this.mTrailer;
    }

    public CosDictionary[] getTrailerList() {
        CosDictionary[] list = null;
        if (this.mXRef != null) {
            list = this.mXRef.getTrailerList();
        }
        return list;
    }

    public CosDictionary getRoot() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject catalog;
        if (this.mRoot != null) {
            catalog = this.mRoot;
        } else {
            CosDictionary trailer = this.getTrailer();
            catalog = trailer.get(ASName.k_Root);
            if (!(catalog instanceof CosDictionary)) {
                throw new PDFCosParseException("Document does not have a catalog of type dictionary.");
            }
            this.mRoot = catalog;
        }
        return catalog;
    }

    public CosDictionary getInfo() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject docInfo = this.getTrailer().get(ASName.k_Info);
        if (docInfo instanceof CosDictionary) {
            return (CosDictionary)docInfo;
        }
        return null;
    }

    public InputByteStream getStream(long start, long length) throws PDFIOException {
        try {
            return this.mBuf.slice(start, length);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public InputByteStream getStream() throws PDFIOException {
        try {
            return this.mBuf.slice();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    InputByteStream getStreamRaw() {
        return this.mBuf;
    }

    public int getNumObjects() {
        return this.mNumObjects;
    }

    int getNumObjectsInternal() {
        return this.mObjectInfos.size();
    }

    public CosOpenOptions getOptions() {
        return this.mOptions;
    }

    public boolean isLinearized() {
        return this.mIsLinearized;
    }

    public boolean wasLinearized() {
        return this.mWasLinearized;
    }

    public boolean wasRepaired() {
        return !this.repairTypes.isEmpty() || this.documentCosLevelRepaired;
    }

    public EnumSet<REPAIRTYPE> getRepairTypes() {
        return this.repairTypes;
    }

    void setGarbageLength(long garbageLength) {
        this.garbageLength = garbageLength;
    }

    boolean forceCompress() {
        return this.mForceCompress;
    }

    XRefTable getXRef() {
        return this.mXRef;
    }

    CosObjectInfo getIndexedInfo(int index) {
        return (CosObjectInfo)this.mObjectInfos.get(index);
    }

    void putIndexedInfo(int index, CosObjectInfo info) {
        this.mObjectInfos.add(index, info);
    }

    void putRebuiltInfo(int index, CosObjectInfo info) {
        CosObjectInfo oldInfo;
        if (index >= this.mNumObjects) {
            this.mNumObjects = index + 1;
        }
        if ((oldInfo = this.getIndexedInfo(index)) == null) {
            this.putIndexedInfo(index, info);
        } else if (!oldInfo.isLoaded() && !oldInfo.isDirty()) {
            oldInfo.markAddressed();
            oldInfo.setObjGen(info.getObjGen());
            oldInfo.setPos(info.getPos());
        }
    }

    CosObjectInfo getObjectInfo(int objNum, int objGen) {
        if (objNum == 0 && objGen != 65535) {
            return null;
        }
        CosObjectInfo info = this.getIndexedInfo(objNum);
        if (objGen < 0) {
            return info;
        }
        if (info != null) {
            if (objNum != info.getObjNum() || objGen != info.getObjGen()) {
                info = null;
            }
        } else {
            info = new CosObjectInfo(this, objNum, objGen);
            this.putIndexedInfo(objNum, info);
        }
        return info;
    }

    CosObjectRef getObjectRef(CosObjectInfo info) {
        CosObjectRef ref = info.getRef();
        if (ref == null) {
            ref = new CosObjectRef(this, info);
            info.setRef(ref);
        }
        return ref;
    }

    CosObjectInfo newObjectInfo() {
        return this.getObjectInfo(this.mNumObjects++, 0);
    }

    public void setFDFDocument(Object fdfDocument) {
        this.mUserData[1] = fdfDocument;
    }

    public Object getFdfDocument() {
        return this.mUserData[1];
    }

    public void setPDFDocument(Object pdfdocument) {
        this.mUserData[0] = pdfdocument;
    }

    public Object getPdfDocument() {
        return this.mUserData[0];
    }

    CosObject resolveReference(CosObjectRef ref) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        CosObjectInfo refInfo = ref.getInfo();
        CosObject result = refInfo.getObject();
        if (result == null) {
            result = this.getIndirectObject(refInfo);
        }
        if (result == null) {
            result = this.createCosNull();
        }
        return result;
    }

    void buildHeaderString(String version) {
        int vindx;
        StringBuilder result = new StringBuilder("%PDF-");
        result.append(version);
        result.append("\r%");
        result.append('\u00e2').append('\u00e3').append('\u00cf').append('\u00d3').append("\r\n");
        if (this.mHeaderToken != null) {
            result.append('%').append(this.mHeaderToken).append("\r\n");
        }
        if ((vindx = result.indexOf("1.")) > 0) {
            this.mHeader = result.toString();
        }
    }

    public void freeDuplicateResources() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosPDFOptimizer pdfOptimizer = CosPDFOptimizer.newInstance(this);
        try {
            pdfOptimizer.freeDuplicateResources();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public boolean freeUnreferencedObjects() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosContainer[] roots = new CosContainer[]{this.getRoot(), this.getInfo(), this.getEncryptionDictionary(), this.getTrailer()};
        try {
            return CosOptimizer.freeUnreferencedObjects(this, roots, false);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObject[] getUnreferencedObjects() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosContainer[] roots = new CosContainer[]{this.getRoot(), this.getInfo(), this.getEncryptionDictionary(), this.getTrailer()};
        try {
            return CosOptimizer.getUnreferencedObjects(this, roots);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public void save(ByteWriter byteWriter, CosSaveParams params) throws PDFCosParseException, PDFInvalidParameterException, PDFIOException, PDFSecurityException {
        OutputByteStream outputByteStream = null;
        try {
            CosObjectStream objStm;
            CosObjectInfo stmInfo;
            Iterator<Object> iter;
            CosList objStmInfos;
            long timer = 0L;
            if (mLoggingPath != null) {
                timer = System.currentTimeMillis();
            }
            long base = 0L;
            String style = null;
            CosList saveObjectInfos = null;
            this.mCompObjInfos = new CosList();
            if (byteWriter == this.mByteReader) {
                byteWriter = null;
            }
            params = this.normalizeParams(params);
            int saveStyle = params.getSaveStyle();
            if (this.mSaveToCopy || this.mIsFDF) {
                saveObjectInfos = this.cloneObjectInfos();
            }
            if (byteWriter != null) {
                outputByteStream = this.getStreamManager().getOutputByteStream(byteWriter);
            }
            if (saveStyle == 1) {
                if (byteWriter == null) {
                    byteWriter = this.getInPlaceByteWriter();
                    if (byteWriter == null) {
                        throw new PDFInvalidParameterException("In-place incremental save requires ByteWriter as source ByteReader");
                    }
                    if (this.mBuf != null && mLoggingPath != null) {
                        base = this.mBuf.length();
                    }
                    style = "In-place incremental save";
                    outputByteStream = this.getStreamManager().getOutputByteStream(byteWriter);
                } else {
                    style = "Incremental save";
                }
                if (this.repairTypes.contains((Object)REPAIRTYPE.xrefRepair)) {
                    throw new PDFInvalidParameterException("File cannot be saved incrementally if xref in original PDF stream was damaged.");
                }
                this.incrementalSave(outputByteStream, params, byteWriter);
            } else if (saveStyle == 2) {
                style = "Full save";
                this.fullSave(outputByteStream, params);
            } else if (saveStyle == 3) {
                this.linearSave(outputByteStream, params);
                style = params.getTempByteWriter() != null ? "Linear save with temp file" : "Linear save without temp file";
            } else {
                style = "Full save";
                this.fullSave(outputByteStream, params);
            }
            if (!(params.getCloseAfterSave() || this.mSaveToCopy || this.mIsFDF)) {
                objStmInfos = this.getObjStmInfos();
                iter = objStmInfos.iterator();
                while (iter.hasNext()) {
                    stmInfo = (CosObjectInfo)iter.next();
                    objStm = (CosObjectStream)stmInfo.getObject();
                    objStm.update();
                }
                outputByteStream.flush();
                this.postSaveCleanup(outputByteStream, byteWriter);
                this.getEncryption().setDecryptionAsEncryption();
            }
            if (this.mSaveToCopy || this.mIsFDF) {
                this.restoreObjectInfos(saveObjectInfos);
                objStmInfos = this.getObjStmInfos();
                iter = objStmInfos.iterator();
                while (iter.hasNext()) {
                    stmInfo = (CosObjectInfo)iter.next();
                    objStm = (CosObjectStream)stmInfo.getObject();
                    objStm.update();
                }
            }
            if (mLoggingPath != null) {
                timer = System.currentTimeMillis() - timer;
                StringBuilder styleBuilder = new StringBuilder(style);
                styleBuilder.append(" took ").append(timer).append("ms");
                if (this.mBuf != null) {
                    styleBuilder.append(", ").append(this.mBuf.length() - base).append(" bytes");
                }
                CosDocument.LogString(styleBuilder.toString());
            }
            boolean bl = this.mIsLinearized = params.getSaveStyle() == 3;
        }
        catch (IOException e) {
            try {
                throw new PDFIOException(e);
            }
            catch (Throwable throwable) {
                boolean bl = this.mIsLinearized = params.getSaveStyle() == 3;
                if (params.getSaveStyle() != 1) {
                    this.mWasLinearized = this.mIsLinearized;
                }
                this.mCompObjInfos = null;
                params.setTempByteWriter(null);
                if (params.getCloseAfterSave()) {
                    this.close();
                }
                if ((params.getCloseAfterSave() || this.mSaveToCopy) && outputByteStream != null) {
                    try {
                        outputByteStream.close();
                    }
                    catch (IOException e2) {
                        throw new PDFIOException(e2);
                    }
                }
                throw throwable;
            }
        }
        if (params.getSaveStyle() != 1) {
            this.mWasLinearized = this.mIsLinearized;
        }
        this.mCompObjInfos = null;
        params.setTempByteWriter(null);
        if (params.getCloseAfterSave()) {
            this.close();
        }
        if ((params.getCloseAfterSave() || this.mSaveToCopy) && outputByteStream != null) {
            try {
                outputByteStream.close();
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        }
    }

    static void LogString(String logItem) {
        if (mLoggingPath != null) {
            RandomAccessFile logFile = null;
            try {
                logFile = new RandomAccessFile(new File(mLoggingPath + "CosDocument.log"), "rw");
                logFile.seek(logFile.length());
                logFile.writeBytes(logItem + "\r\n");
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot make logger entry", e);
            }
            finally {
                if (logFile != null) {
                    try {
                        logFile.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error closing log file", e);
                    }
                }
            }
        }
    }

    private CosList cloneObjectInfos() {
        CosList cloneList = new CosList();
        int end = this.mObjectInfos.size();
        for (int i = 0; i < end; ++i) {
            CosObjectInfo info = (CosObjectInfo)this.mObjectInfos.get(i);
            if (info == null) continue;
            CosObjectInfo clone = new CosObjectInfo(this, 0, 0);
            clone.copyValuesFrom(info);
            cloneList.add(i, clone);
        }
        return cloneList;
    }

    private void restoreObjectInfos(CosList savedInfos) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int end = savedInfos.size();
        while (this.mObjectInfos.size() > end) {
            this.mObjectInfos.delete(this.mObjectInfos.size() - 1);
        }
        for (int i = 0; i < end; ++i) {
            CosObjectInfo info = (CosObjectInfo)this.mObjectInfos.get(i);
            if (info == null) continue;
            CosObjectInfo clone = (CosObjectInfo)savedInfos.get(i);
            info.copyValuesFrom(clone);
        }
        this.mNumObjects = end;
        this.mRoot = null;
    }

    CosList getObjStmInfos() {
        CosList objStmInfos = new CosList();
        Iterator<Object> iter = this.mObjectInfos.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            if (!info.isObjStm() || info.isFree()) continue;
            objStmInfos.add(info);
        }
        return objStmInfos;
    }

    boolean willBeCompressed(int objNum) {
        if (this.mCompObjInfos == null) {
            return false;
        }
        return this.mCompObjInfos.containsIndex(objNum);
    }

    public static void setLoggingPath(String loggingPath) {
        mLoggingPath = loggingPath;
    }

    public static String getLoggingPath() {
        return mLoggingPath;
    }

    public ByteWriter getInPlaceByteWriter() {
        if (this.mByteReader instanceof ByteWriter && this.mOptions.getSaveInPlace()) {
            return (ByteWriter)this.mByteReader;
        }
        return null;
    }

    public ByteReader getByteReader() {
        return this.mByteReader;
    }

    public void setNextIncrementalSectionOffset(long nextIncrementalSectionOffset) {
        this.nextIncrementalSectionOffset = nextIncrementalSectionOffset;
    }

    private void updateDocumentStream(OutputByteStream outputByteStream, boolean inPlaceSave) throws PDFCosParseException, PDFSecurityException, PDFIOException {
        try {
            if (inPlaceSave) {
                outputByteStream.seek(this.nextIncrementalSectionOffset);
            } else {
                IO.copy(this.mBuf, 0L, this.nextIncrementalSectionOffset, outputByteStream);
            }
            InputByteStream mBufCopy = this.mBuf.slice(0L, this.nextIncrementalSectionOffset);
            this.mBuf.close();
            this.mBuf = mBufCopy;
            this.mXRef.resetXRef(this.mBuf);
            this.nextIncrementalSectionOffset = -1L;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    private void incrementalSave(OutputByteStream outputByteStream, CosSaveParams params, ByteWriter byteWriter) throws PDFCosParseException, PDFInvalidParameterException, IOException, PDFIOException, PDFSecurityException {
        if (this.mBuf == null) {
            throw new PDFInvalidParameterException("Incremental save can be used with existing files only");
        }
        if (this.documentCosLevelRepaired) {
            this.documentCosLevelRepaired = false;
            if (this.cosRepairList != null) {
                this.cosRepairList.clear();
            }
        }
        int xrefstyle = params.getXrefStyle();
        this.getEncryption().setupEncryption();
        if (byteWriter != this.mByteReader) {
            this.mBuf.seek(0L);
            if (this.nextIncrementalSectionOffset != -1L) {
                this.updateDocumentStream(outputByteStream, false);
            } else {
                IO.copy(this.mBuf, 0L, this.mBuf.length() - this.garbageLength, outputByteStream);
            }
        } else if (this.nextIncrementalSectionOffset != -1L) {
            this.updateDocumentStream(outputByteStream, true);
        } else {
            outputByteStream.seek(outputByteStream.length() - this.garbageLength);
        }
        if (this.garbageLength > 0L) {
            outputByteStream.write(13);
            outputByteStream.write(10);
        }
        CosArray updateID = this.createUpdateDocID(false);
        this.getTrailer().put(ASName.k_ID, updateID);
        CosOptimizer.freeUnreferencedObjectsIncremental(this, this.mOrigNumObjects);
        CosList dirtyCompObjInfos = this.buildCompObjList(xrefstyle);
        Iterator<Object> iter = dirtyCompObjInfos.iterator();
        while (iter.hasNext()) {
            CosList stmObjList = (CosList)iter.next();
            CosObjectStream newStm = this.createCosObjectStream();
            newStm.setObjectStreamList(stmObjList);
        }
        CosList dirtyObjectInfos = this.buildObjectList(true);
        if (dirtyObjectInfos.isEmpty()) {
            return;
        }
        CosList stripped = null;
        CosList updateInfos = null;
        long curpos = outputByteStream.getPosition();
        if (xrefstyle == 3) {
            updateInfos = this.prepareHybridInfoList(dirtyObjectInfos, null, null);
            stripped = dirtyObjectInfos;
        } else {
            stripped = dirtyObjectInfos.copy();
            iter = stripped.iterator();
            while (iter.hasNext()) {
                CosObjectInfo info = (CosObjectInfo)iter.next();
                int objNum = info.getObjNum();
                if (!info.isCompressed() && !this.mCompObjInfos.containsIndex(objNum)) continue;
                iter.remove();
            }
        }
        curpos = this.writeIndirectObjects(stripped, outputByteStream, params.getSaveToCopy());
        long paddedDataLength = outputByteStream.length() - outputByteStream.getPosition();
        if (paddedDataLength > 0L) {
            byte[] spacePadding = new byte[(int)paddedDataLength];
            Arrays.fill(spacePadding, (byte)32);
            outputByteStream.write(spacePadding);
            curpos = outputByteStream.getPosition();
        }
        long xrefPos = curpos;
        long lastXrefPos = 0L;
        ArrayList sections = this.prepareXRef(dirtyObjectInfos, false);
        if (xrefstyle == 1) {
            this.writeXRefTable(sections, outputByteStream);
            CosDictionary trailer = this.createCosDictionary(0);
            this.copyTrailerFields(trailer, this.getNumObjects());
            lastXrefPos = this.mXRef.getLastXRefSectionPosition();
            trailer.put(ASName.k_Prev, lastXrefPos);
            this.writeTrailer(trailer, outputByteStream);
            if (!this.mSaveToCopy) {
                this.mTrailer = trailer;
            }
            this.writeEOF(xrefPos, outputByteStream);
        } else {
            if (xrefstyle == 2) {
                this.buildXRefStream(sections, outputByteStream, null);
                try {
                    outputByteStream.write(StringOps.toByteArray(STARTXREF));
                    outputByteStream.write(StringOps.toByteArray(Long.toString(xrefPos)));
                    outputByteStream.write(StringOps.toByteArray(EOF));
                }
                catch (IOException e) {
                    throw new PDFIOException("Unable to write the XRef.", e);
                }
            }
            if (xrefstyle == 3) {
                CosObjectInfo info;
                this.writeXRefTable(sections, outputByteStream);
                CosDictionary trailer = this.createCosDictionary(0);
                this.copyTrailerFields(trailer, this.getNumObjects());
                lastXrefPos = this.mXRef.getLastXRefSectionPosition();
                trailer.put(ASName.k_Prev, lastXrefPos);
                this.writeTrailer(trailer, outputByteStream);
                if (updateInfos.isEmpty()) {
                    this.writeEOF(xrefPos, outputByteStream);
                    return;
                }
                int xindx = updateInfos.size() - 1;
                CosObjectInfo xinfo = (CosObjectInfo)updateInfos.get(xindx);
                CosStream xrefstm = (CosStream)xinfo.getObject();
                xrefstm.put(ASName.k_Prev, xrefPos);
                stripped = updateInfos.copy();
                iter = stripped.iterator();
                while (iter.hasNext()) {
                    CosObjectInfo info2 = (CosObjectInfo)iter.next();
                    if (!info2.isCompressed() && info2 != xinfo) continue;
                    iter.remove();
                }
                long updatexrefpos = this.writeIndirectObjects(stripped, outputByteStream, params.getSaveToCopy());
                ArrayList<CosList> hybridSections = new ArrayList<CosList>();
                int sectionindx = 0;
                hybridSections.add(sectionindx, new CosList());
                int lastObjNum = 0;
                CosList seclist = (CosList)hybridSections.get(sectionindx);
                iter = updateInfos.iterator();
                while (iter.hasNext()) {
                    info = (CosObjectInfo)iter.next();
                    int thisObjNum = info.getObjNum();
                    if (thisObjNum - lastObjNum != 1 && lastObjNum != 0) {
                        seclist = new CosList();
                        hybridSections.add(++sectionindx, seclist);
                    }
                    seclist.add(info);
                    lastObjNum = thisObjNum;
                }
                CosArray indexVal = this.createCosArray();
                for (CosList nextsec : hybridSections) {
                    CosObjectInfo firstObjInfo = (CosObjectInfo)nextsec.get(0);
                    int firstObjNum = firstObjInfo.getObjNum();
                    int secsize = nextsec.size();
                    indexVal.addInt(firstObjNum);
                    indexVal.addInt(secsize);
                }
                xrefstm.put(ASName.k_Index, indexVal);
                int[] widths = this.setWidthsArray(updateInfos, xrefstm, outputByteStream.getPosition());
                OutputByteStream buf = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                Iterator<Object> iterator = updateInfos.iterator();
                while (iterator.hasNext()) {
                    info = (CosObjectInfo)iterator.next();
                    info.writeXRefStreamEntry(buf, widths);
                }
                xrefstm.newDataDecoded(buf.closeAndConvert());
                try {
                    updatexrefpos = xinfo.writeIndirectObject(outputByteStream, updatexrefpos);
                    outputByteStream.write(StringOps.toByteArray(XREF));
                }
                catch (PDFIOException e) {
                    throw new PDFIOException("Unable to write the XRef stream.", e);
                }
                try {
                    outputByteStream.write(48);
                    outputByteStream.write(32);
                    outputByteStream.write(48);
                    outputByteStream.write(32);
                    outputByteStream.write(10);
                }
                catch (IOException e) {
                    throw new PDFIOException("Unable to write the header info.", e);
                }
                long xstmPos = xinfo.getPos();
                CosDictionary updateTrailer = this.createCosDictionary(0);
                this.copyTrailerFields(updateTrailer, this.getNumObjects());
                updateTrailer.put(ASName.k_Prev, xrefPos);
                updateTrailer.put(ASName.k_XRefStm, xstmPos);
                this.writeTrailer(updateTrailer, outputByteStream);
                if (!this.mSaveToCopy) {
                    this.mTrailer = updateTrailer;
                }
                this.writeEOF(updatexrefpos, outputByteStream);
            }
        }
    }

    private void fullSave(OutputByteStream outputByteStream, CosSaveParams params) throws PDFCosParseException, PDFInvalidParameterException, IOException, PDFIOException, PDFSecurityException {
        CosDictionary trailer;
        try {
            outputByteStream.write(StringOps.toByteArray(this.mHeader));
        }
        catch (IOException e) {
            throw new PDFIOException("Unable to write the header.", e);
        }
        if (this.mIsFDF) {
            this.getRoot().remove(ASName.k_Type);
        }
        CosArray updatedID = this.createUpdateDocID(false);
        this.getTrailer().put(ASName.k_ID, updatedID);
        int xrefstyle = params.getXrefStyle();
        this.getEncryption().setupEncryption();
        CosContainer[] roots = new CosContainer[]{this.getRoot(), this.getInfo(), this.getEncryptionDictionary(), null};
        long lastXrefPos = 0L;
        if (!this.mXRef.isNew()) {
            if (this.mXRef.getType() == 2) {
                CosDictionary trailer2 = this.getTrailer();
                if (trailer2.containsKey(ASName.k_XRefStm)) {
                    lastXrefPos = trailer2.getInt(ASName.k_XRefStm).intValue();
                }
            } else if (this.mXRef.getType() == 1) {
                lastXrefPos = this.mXRef.getLastXRefSectionPosition();
            }
        }
        if (lastXrefPos == 0L) {
            roots[3] = this.getTrailer();
        }
        CosOptimizer.freeUnreferencedObjects(this, roots, true);
        this.mCompObjInfos = this.buildFullSaveCompList(xrefstyle);
        CosList objStmInfos = this.getObjStmInfos();
        Iterator<Object> iter = objStmInfos.iterator();
        Iterator<Object> compIter = this.mCompObjInfos.iterator();
        CosObjectStream curObjStm = null;
        int curIndex = 200;
        while (compIter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)compIter.next();
            CosObject obj = info.getObject();
            if (curIndex == 200) {
                curIndex = 0;
                if (iter != null && iter.hasNext()) {
                    CosObjectInfo stmInfo = (CosObjectInfo)iter.next();
                    curObjStm = (CosObjectStream)stmInfo.getObject();
                    curObjStm.remove(ASName.k_Extends);
                } else {
                    iter = null;
                    curObjStm = this.createCosObjectStream();
                }
            }
            curObjStm.addObjectToStream(obj);
            ++curIndex;
        }
        CosList objStmsToBeDeleted = new CosList();
        if (iter != null) {
            while (iter.hasNext()) {
                CosObjectInfo stmInfo = (CosObjectInfo)iter.next();
                objStmsToBeDeleted.add(stmInfo.getObjNum(), stmInfo);
            }
        }
        CosList stripped = null;
        CosList updateInfos = null;
        CosList objectInfos = this.buildObjectList(false);
        if (xrefstyle == 3) {
            updateInfos = this.prepareHybridInfoList(objectInfos, this.mCompObjInfos, objStmsToBeDeleted);
            stripped = objectInfos;
        } else {
            stripped = objectInfos.copy();
            iter = stripped.iterator();
            while (iter.hasNext()) {
                CosObjectInfo info = (CosObjectInfo)iter.next();
                int objNum = info.getObjNum();
                if (!this.mCompObjInfos.containsIndex(objNum) && !objStmsToBeDeleted.containsIndex(objNum)) continue;
                iter.remove();
            }
        }
        long xrefPos = this.writeIndirectObjects(stripped, outputByteStream, params.getSaveToCopy());
        CosDictionary encryptDict = null;
        if (this.needsEncryption()) {
            Map encryptData = this.getEncryption().getEncryptionMap();
            if (encryptData == null) {
                throw new PDFInvalidParameterException("New encryption data not provided.");
            }
            encryptDict = this.createCosDictionaryFromNonCosData(encryptData);
            encryptDict.setEncryptionState(false);
            CosObjectInfo encryptInfo = encryptDict.getInfo();
            if (encryptInfo != null) {
                xrefPos = encryptInfo.writeIndirectObject(outputByteStream, xrefPos);
                objectInfos.add(encryptInfo.getObjNum(), encryptInfo);
            }
        }
        if (objStmsToBeDeleted.isEmpty()) {
            stripped = objectInfos;
        } else {
            stripped = objectInfos.copy();
            iter = stripped.iterator();
            while (iter.hasNext()) {
                CosObjectInfo info = (CosObjectInfo)iter.next();
                int objNum = info.getObjNum();
                if (!objStmsToBeDeleted.containsIndex(objNum)) continue;
                iter.remove();
            }
        }
        ArrayList sections = this.prepareXRef(stripped, true);
        if (!this.needsEncryption()) {
            this.removeEncryptionDictionary();
        } else {
            this.setEncryptionDictionary(encryptDict);
        }
        if (xrefstyle == 1) {
            if (!this.mIsFDF) {
                this.writeXRefTable(sections, outputByteStream);
            }
            trailer = this.createCosDictionary(0);
            this.copyTrailerFields(trailer, this.getNumObjects());
            this.writeTrailer(trailer, outputByteStream);
            if (!this.mSaveToCopy) {
                this.mTrailer = trailer;
            }
            if (this.mIsFDF) {
                outputByteStream.write(StringOps.toByteArray("%%EOF\n"));
            } else {
                this.writeEOF(xrefPos, outputByteStream);
            }
        } else {
            if (xrefstyle == 2) {
                this.buildXRefStream(sections, outputByteStream, objStmsToBeDeleted);
                try {
                    outputByteStream.write(StringOps.toByteArray(STARTXREF));
                    outputByteStream.write(StringOps.toByteArray(Long.toString(xrefPos)));
                    outputByteStream.write(StringOps.toByteArray(EOF));
                }
                catch (IOException e) {
                    throw new PDFIOException("Unable to write XRef.", e);
                }
            }
            if (xrefstyle == 3) {
                CosObjectInfo info;
                this.writeXRefTable(sections, outputByteStream);
                trailer = this.createCosDictionary(0);
                this.copyTrailerFields(trailer, this.getNumObjects());
                this.writeTrailer(trailer, outputByteStream);
                if (updateInfos.isEmpty()) {
                    iter = objStmsToBeDeleted.iterator();
                    while (iter.hasNext()) {
                        CosObjectInfo stmInfo = (CosObjectInfo)iter.next();
                        stmInfo.markFree();
                    }
                    this.writeEOF(xrefPos, outputByteStream);
                    return;
                }
                int xindx = updateInfos.size() - 1;
                CosObjectInfo xinfo = (CosObjectInfo)updateInfos.get(xindx);
                CosStream xrefstm = (CosStream)xinfo.getObject();
                xrefstm.put(ASName.k_Prev, xrefPos);
                stripped = updateInfos.copy();
                iter = stripped.iterator();
                while (iter.hasNext()) {
                    CosObjectInfo info2 = (CosObjectInfo)iter.next();
                    if (info2.isObjStm()) continue;
                    iter.remove();
                }
                long updatexrefpos = this.writeIndirectObjects(stripped, outputByteStream, params.getSaveToCopy());
                ArrayList<CosList> hybridSections = new ArrayList<CosList>();
                int sectionindx = 0;
                hybridSections.add(sectionindx, new CosList());
                int lastObjNum = 0;
                CosList seclist = (CosList)hybridSections.get(sectionindx);
                iter = updateInfos.iterator();
                while (iter.hasNext()) {
                    info = (CosObjectInfo)iter.next();
                    int thisObjNum = info.getObjNum();
                    if (thisObjNum - lastObjNum != 1 && lastObjNum != 0) {
                        seclist = new CosList();
                        hybridSections.add(++sectionindx, seclist);
                    }
                    seclist.add(info);
                    lastObjNum = thisObjNum;
                }
                CosArray indexVal = this.createCosArray();
                for (CosList nextsec : hybridSections) {
                    CosObjectInfo firstObjInfo = (CosObjectInfo)nextsec.get(0);
                    int firstObjNum = firstObjInfo.getObjNum();
                    int secsize = nextsec.size();
                    indexVal.addInt(firstObjNum);
                    indexVal.addInt(secsize);
                }
                xrefstm.put(ASName.k_Index, indexVal);
                xrefstm.getInfo().setPos(outputByteStream.getPosition());
                int[] widths = this.setWidthsArray(updateInfos, xrefstm, outputByteStream.getPosition());
                OutputByteStream buf = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                Iterator<Object> iterator = updateInfos.iterator();
                while (iterator.hasNext()) {
                    info = (CosObjectInfo)iterator.next();
                    info.writeXRefStreamEntry(buf, widths);
                }
                xrefstm.newDataDecoded(buf.closeAndConvert());
                try {
                    updatexrefpos = xinfo.writeIndirectObject(outputByteStream, updatexrefpos);
                    outputByteStream.write(StringOps.toByteArray(XREF));
                }
                catch (PDFIOException e) {
                    throw new PDFIOException("Unable to write the XRef Stream.", e);
                }
                try {
                    outputByteStream.write(48);
                    outputByteStream.write(32);
                    outputByteStream.write(48);
                    outputByteStream.write(32);
                    outputByteStream.write(10);
                }
                catch (IOException e) {
                    throw new PDFIOException("Unable to write the empty XRef section.", e);
                }
                long xstmPos = xinfo.getPos();
                CosDictionary updateTrailer = this.createCosDictionary(0);
                this.copyTrailerFields(updateTrailer, this.getNumObjects());
                updateTrailer.put(ASName.k_Prev, xrefPos);
                updateTrailer.put(ASName.k_XRefStm, xstmPos);
                this.writeTrailer(updateTrailer, outputByteStream);
                if (!this.mSaveToCopy) {
                    this.mTrailer = updateTrailer;
                }
                this.writeEOF(updatexrefpos, outputByteStream);
            }
        }
        iter = objStmsToBeDeleted.iterator();
        while (iter.hasNext()) {
            CosObjectInfo stmInfo = (CosObjectInfo)iter.next();
            stmInfo.markFree();
        }
    }

    private CosList buildFullSaveCompList(int xrefStyle) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosList compObjList;
        block15: {
            block14: {
                compObjList = new CosList();
                if (xrefStyle != 3) break block14;
                CosObject obj = this.getRoot().get(ASName.k_StructTreeRoot);
                if (obj == null) break block15;
                compObjList = new CosList();
                int stateStackPtr = 0;
                Object[] stateStack = new Object[65536];
                CosContainer container = null;
                Iterator<Object> containerIter = null;
                while (true) {
                    block16: {
                        block17: {
                            if (obj == null || obj instanceof CosNull || obj instanceof CosStream) break block16;
                            int objNum = obj.getObjNum();
                            if (objNum == 0) break block17;
                            if (compObjList.get(objNum) != null) break block16;
                            compObjList.add(objNum, obj.getInfo());
                        }
                        if (obj instanceof CosContainer) {
                            if (containerIter != null) {
                                stateStack[stateStackPtr++] = container;
                                stateStack[stateStackPtr++] = containerIter;
                            }
                            if ((container = (CosContainer)obj) instanceof CosArray) {
                                containerIter = ((CosArray)container).iterator();
                            } else {
                                List<ASName> keys = ((CosDictionary)container).getKeys();
                                containerIter = keys.iterator();
                            }
                        }
                    }
                    if (containerIter == null) {
                        return compObjList;
                    }
                    while (!containerIter.hasNext()) {
                        if (stateStackPtr == 0) {
                            return compObjList;
                        }
                        containerIter = (Iterator)stateStack[--stateStackPtr];
                        container = (CosContainer)stateStack[--stateStackPtr];
                    }
                    if (container instanceof CosArray) {
                        obj = (CosObject)containerIter.next();
                        continue;
                    }
                    ASName key = (ASName)containerIter.next();
                    obj = null;
                    if (key == ASName.k_Pg || key == ASName.k_P || key == ASName.k_Stm || key == ASName.k_StmOwn || key == ASName.k_Obj) continue;
                    obj = ((CosDictionary)container).get(key);
                }
            }
            if (xrefStyle == 2) {
                compObjList = new CosList();
                CosDictionary catalog = this.getRoot();
                CosDictionary encrypt = this.getEncryptionDictionary();
                Iterator<Object> iter = this.mObjectInfos.iterator();
                while (iter.hasNext()) {
                    CosObject type;
                    CosObjectInfo info = (CosObjectInfo)iter.next();
                    CosObject obj = info.getObject();
                    if (obj == null || obj instanceof CosStream || obj == catalog || obj == encrypt || obj instanceof CosDictionary && (type = ((CosDictionary)obj).get(ASName.k_Type)) instanceof CosName && dictionariesNotToBeCompressed.contains(type.nameValue())) continue;
                    compObjList.add(info.getObjNum(), info);
                }
            }
        }
        return compObjList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void linearSave(OutputByteStream outputByteStream, CosSaveParams params) throws PDFCosParseException, PDFInvalidParameterException, IOException, PDFIOException, PDFSecurityException {
        CosDictionary trailer;
        CosObjectInfo objInfo;
        long hintStmPos;
        int HEADER_OVERHEAD_TABLE = 400;
        int HEADER_OVERHEAD_STREAM = 500;
        int HEADER_OVERHEAD_HYBRID = 500;
        CosArray updatedID = this.createUpdateDocID(false);
        this.getTrailer().put(ASName.k_ID, updatedID);
        int xrefstyle = params.getXrefStyle();
        this.mCosLin = new CosLinearization(this);
        this.mCosLin.buildLinearizationData(xrefstyle);
        this.getEncryption().setupEncryption();
        CosStream mainXRefStm = null;
        CosObjectInfo mainXRefStmObjInfo = null;
        CosList mainObjInfos = this.mCosLin.getMainSectionList();
        CosList mainObjInfosCompressed = this.mCosLin.getMainSectionCompressedList();
        CosList updateObjInfos = this.mCosLin.getUpdateSectionList();
        CosList updateObjInfosCompressed = this.mCosLin.getUpdateSectionCompressedList();
        if (xrefstyle == 3 && mainObjInfosCompressed.isEmpty()) {
            xrefstyle = 1;
        }
        boolean haveXRefStms = xrefstyle == 2 || xrefstyle == 3;
        CosList oldToOldObjStmMap = null;
        if (this.mXRef.getType() == 1 || this.mXRef.getType() == 2) {
            oldToOldObjStmMap = new CosList();
            Iterator<Object> iter = this.mObjectInfos.iterator();
            while (iter.hasNext()) {
                CosObjectInfo objInfo2 = (CosObjectInfo)iter.next();
                CosObjectInfo objStmInfo = objInfo2.getStreamInfo();
                if (objStmInfo == null) continue;
                oldToOldObjStmMap.add(objStmInfo.getObjNum(), objStmInfo.getObject());
            }
        }
        CosList newInfosList = new CosList();
        newInfosList.addAll(mainObjInfos);
        if (haveXRefStms) {
            newInfosList.addAll(mainObjInfosCompressed);
            if (xrefstyle == 2) {
                mainXRefStm = this.createCosStream();
                mainXRefStmObjInfo = mainXRefStm.getInfo();
                newInfosList.add(mainXRefStmObjInfo);
            }
        }
        CosDictionary linDict = this.createCosDictionary();
        CosObjectInfo linDictObjInfo = linDict.getInfo();
        CosStream updateXRefStm = null;
        CosObjectInfo updateXRefStmObjInfo = null;
        if (haveXRefStms) {
            updateXRefStm = this.createCosStream();
            updateXRefStmObjInfo = updateXRefStm.getInfo();
        }
        CosStream hintStm = this.createCosStream();
        CosObjectInfo hintStmObjInfo = hintStm.getInfo();
        CosDictionary encryptDict = null;
        if (this.needsEncryption()) {
            Map encryptData = this.getEncryption().getEncryptionMap();
            if (encryptData == null) {
                throw new PDFInvalidParameterException("New encryption data not provided.");
            }
            encryptDict = this.createCosDictionaryFromNonCosData(encryptData);
            encryptDict.setEncryptionState(false);
            this.setEncryptionDictionary(encryptDict);
        } else {
            this.removeEncryptionDictionary();
        }
        int numSpecialObjs = 2;
        if (updateXRefStm != null) {
            ++numSpecialObjs;
        }
        if (encryptDict != null) {
            ++numSpecialObjs;
        }
        newInfosList.add(linDictObjInfo);
        if (updateXRefStm != null) {
            newInfosList.add(updateXRefStmObjInfo);
        }
        updateObjInfos.add(0, encryptDict == null ? null : encryptDict.getInfo());
        newInfosList.addAll(updateObjInfos);
        newInfosList.addAll(updateObjInfosCompressed);
        newInfosList.add(hintStmObjInfo);
        CosListInt newToOldObjNumMap = new CosListInt();
        CosListInt newToOldObjGenMap = new CosListInt();
        CosListInt oldToNewObjNumMap = new CosListInt();
        this.mNumObjects = newInfosList.size();
        HashMap<Integer, Integer> objectNumbersMap = new HashMap<Integer, Integer>();
        for (int i = 1; i < this.mNumObjects; ++i) {
            CosObjectInfo objInfo3 = (CosObjectInfo)newInfosList.get(i);
            newToOldObjNumMap.add(i, objInfo3.getObjNum());
            newToOldObjGenMap.add(i, objInfo3.getObjGen());
            oldToNewObjNumMap.add(objInfo3.getObjNum(), i);
            if (this.documentCosLevelRepaired && this.cosRepairList.isObjectRepaired(objInfo3.getObjNum())) {
                objectNumbersMap.put(objInfo3.getObjNum(), i);
            }
            objInfo3.setObjNum(i);
            objInfo3.setObjGen(0);
        }
        if (this.documentCosLevelRepaired && !objectNumbersMap.isEmpty()) {
            this.cosRepairList.updateObjectNumbers(objectNumbersMap);
        }
        this.mCosLin.setNewToOldObjNumMap(newToOldObjNumMap);
        this.mCosLin.setNewToOldObjGenMap(newToOldObjGenMap);
        this.mCosLin.setOldToOldObjStmMap(oldToOldObjStmMap);
        this.mCosLin.setOldToNewObjNumMap(oldToNewObjNumMap);
        this.mObjectInfos = newInfosList;
        OutputByteStream tempSaveOutStream = null;
        ByteWriter tempByteWriter = params.getTempByteWriter();
        tempSaveOutStream = tempByteWriter == null ? this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L) : this.getStreamManager().getOutputByteStream(tempByteWriter);
        long curPos = this.writeIndirectObjects(updateObjInfos, tempSaveOutStream, params.getSaveToCopy());
        int updateLastObjNum = ((CosObjectInfo)updateObjInfos.last()).getObjNum();
        curPos = this.writeIndirectObjects(mainObjInfos, tempSaveOutStream, params.getSaveToCopy());
        int mainLastObjNum = ((CosObjectInfo)mainObjInfos.last()).getObjNum();
        long objEndPos = curPos;
        if (xrefstyle == 1) {
            hintStmPos = 400 + (updateObjInfos.size() + numSpecialObjs) * 20;
        } else if (xrefstyle == 2) {
            hintStmPos = 500 + (updateObjInfos.size() + numSpecialObjs) * 4;
            hintStmPos += (long)(updateObjInfosCompressed.size() * 4);
        } else {
            hintStmPos = 500 + (updateObjInfos.size() + numSpecialObjs) * 20;
            hintStmPos += (long)(mainObjInfosCompressed.size() * 4);
        }
        long hintStmLen = 0L;
        this.mCosLin.buildHintStream(this.mObjectInfos, hintStm, mainLastObjNum, updateLastObjNum, hintStmPos, objEndPos);
        OutputByteStream hintStmOutBuf = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        hintStmLen = hintStmObjInfo.writeIndirectObject(hintStmOutBuf, 0L);
        Iterator<Object> linIter = updateObjInfos.iterator();
        while (linIter.hasNext()) {
            objInfo = (CosObjectInfo)linIter.next();
            objInfo.setPos(objInfo.getPos() + hintStmPos + hintStmLen);
        }
        linIter = mainObjInfos.iterator();
        while (linIter.hasNext()) {
            objInfo = (CosObjectInfo)linIter.next();
            objInfo.setPos(objInfo.getPos() + hintStmPos + hintStmLen);
        }
        outputByteStream.write(StringOps.toByteArray(this.mHeader));
        long linDictPos = 0L;
        long updateXRefPos = 0L;
        linDictPos = outputByteStream.getPosition();
        linDict.put(ASName.k_Linearized, 1);
        linDict.put(ASName.k_L, 1234567890);
        CosArray hintValues = this.createCosArray();
        hintValues.addInt((int)hintStmPos);
        hintValues.addInt((int)hintStmLen);
        linDict.put(ASName.k_H, hintValues);
        int specialPageObjNum = this.mCosLin.getSpecialPageObj().getObjNum();
        linDict.put(ASName.k_O, specialPageObjNum);
        int specialPageEnd = (int)((CosObjectInfo)mainObjInfos.get(1)).getPos();
        linDict.put(ASName.k_E, specialPageEnd);
        linDict.put(ASName.k_N, this.mCosLin.getNumPages());
        linDict.put(ASName.k_T, 1234567890);
        NullOutputByteStream scratchStm = new NullOutputByteStream();
        updateXRefPos = linDictPos + linDictObjInfo.writeIndirectObject(scratchStm, linDictPos);
        long linDictT = 0L;
        long mainXRefPos = 0L;
        CosObjectInfo freeInfo = this.getObjectInfo(0, 65535);
        mainXRefPos = hintStmPos + hintStmLen + curPos;
        if (xrefstyle == 1) {
            linDictT = this.linXRefTable(tempSaveOutStream, mainObjInfos);
            trailer = this.createCosDictionary(0);
            trailer.put(ASName.k_Size, mainObjInfos.size());
            trailer.put(ASName.k_ID, updatedID);
            if (encryptDict != null) {
                trailer.put(ASName.k_Encrypt, encryptDict);
            }
            this.writeTrailer(trailer, tempSaveOutStream);
            this.writeEOF(updateXRefPos, tempSaveOutStream);
        } else if (xrefstyle == 2) {
            mainObjInfosCompressed.add(mainXRefStmObjInfo);
            linIter = mainObjInfosCompressed.iterator();
            while (linIter.hasNext()) {
                CosObjectInfo info = (CosObjectInfo)linIter.next();
                mainObjInfos.add(info.getObjNum(), info);
            }
            linDictT = this.linXRefStream(tempSaveOutStream, mainXRefStmObjInfo, mainObjInfos, mainXRefPos, encryptDict, null, null, updatedID, 0L, false);
            tempSaveOutStream.write(StringOps.toByteArray(STARTXREF));
            tempSaveOutStream.write(StringOps.toByteArray(Long.toString(updateXRefPos)));
            tempSaveOutStream.write(StringOps.toByteArray(EOF));
        } else {
            int freeCount = mainObjInfosCompressed.size();
            while (freeCount-- != 0) {
                mainObjInfos.add(freeInfo);
            }
            linDictT = this.linXRefTable(tempSaveOutStream, mainObjInfos);
            CosDictionary trailer2 = this.createCosDictionary(0);
            trailer2.put(ASName.k_Size, mainObjInfos.size());
            trailer2.put(ASName.k_ID, updatedID);
            if (encryptDict != null) {
                trailer2.put(ASName.k_Encrypt, encryptDict);
            }
            this.writeTrailer(trailer2, tempSaveOutStream);
            this.writeEOF(updateXRefPos, tempSaveOutStream);
        }
        linDict.put(ASName.k_L, hintStmPos + hintStmLen + tempSaveOutStream.getPosition());
        linDict.put(ASName.k_T, hintStmPos + hintStmLen + linDictT);
        for (curPos = linDictObjInfo.writeIndirectObject(outputByteStream, linDictPos); curPos < updateXRefPos - 1L; ++curPos) {
            outputByteStream.write(32);
        }
        outputByteStream.write(10);
        updateObjInfos = this.copyInfoList(updateObjInfos);
        updateObjInfos.add(linDictObjInfo.getObjNum(), linDictObjInfo);
        linDictObjInfo.setPos(linDictPos);
        hintStmObjInfo.setPos(hintStmPos);
        mainObjInfosCompressed = this.copyInfoList(mainObjInfosCompressed);
        if (xrefstyle == 1) {
            updateObjInfos.add(hintStmObjInfo.getObjNum(), hintStmObjInfo);
            trailer = this.createCosDictionary(0);
            this.copyTrailerFields(trailer, this.mNumObjects);
            trailer.put(ASName.k_Prev, mainXRefPos);
            this.linXRefTable(outputByteStream, updateObjInfos);
            this.writeTrailer(trailer, outputByteStream);
            this.mTrailer = trailer;
            this.writeEOF(0L, outputByteStream);
        } else if (xrefstyle == 2) {
            updateObjInfos.add(updateXRefStmObjInfo.getObjNum(), updateXRefStmObjInfo);
            updateXRefStmObjInfo.setPos(updateXRefPos);
            updateObjInfos.addAll(updateObjInfosCompressed);
            updateObjInfos.add(hintStmObjInfo.getObjNum(), hintStmObjInfo);
            this.linXRefStream(outputByteStream, updateXRefStmObjInfo, updateObjInfos, updateXRefPos, encryptDict, this.getRoot(), this.getInfo(), updatedID, mainXRefPos, true);
        } else {
            updateObjInfos.add(updateXRefStmObjInfo.getObjNum(), updateXRefStmObjInfo);
            updateObjInfos.add(hintStmObjInfo.getObjNum(), hintStmObjInfo);
            trailer = this.createCosDictionary(0);
            this.copyTrailerFields(trailer, this.mNumObjects);
            trailer.put(ASName.k_Prev, mainXRefPos);
            scratchStm.seek(0L);
            this.linXRefTable(scratchStm, updateObjInfos);
            curPos = scratchStm.getPosition();
            trailer.put(ASName.k_XRefStm, updateXRefPos + curPos + 500L);
            this.writeTrailer(trailer, scratchStm);
            this.writeEOF(0L, scratchStm);
            curPos = scratchStm.getPosition();
            trailer.put(ASName.k_XRefStm, updateXRefPos + curPos);
            updateXRefStmObjInfo.setPos(updateXRefPos + curPos);
            this.linXRefTable(outputByteStream, updateObjInfos);
            this.writeTrailer(trailer, outputByteStream);
            this.mTrailer = trailer;
            this.writeEOF(0L, outputByteStream);
            if (outputByteStream.getPosition() < updateXRefPos + curPos) {
                outputByteStream.write(10);
            }
            this.linXRefStream(outputByteStream, updateXRefStmObjInfo, mainObjInfosCompressed, updateXRefPos + curPos, encryptDict, null, null, null, 0L, false);
        }
        for (curPos = outputByteStream.getPosition(); curPos < hintStmPos - 1L; ++curPos) {
            outputByteStream.write(32);
        }
        outputByteStream.write(10);
        try (InputByteStream hintStmInBuf = null;){
            hintStmInBuf = hintStmOutBuf.closeAndConvert();
            hintStmOutBuf = null;
            IO.copy(hintStmInBuf, outputByteStream);
        }
        InputByteStream tempSaveInStream = tempSaveOutStream.closeAndConvert();
        tempSaveOutStream = null;
        IO.copy(tempSaveInStream, outputByteStream);
        tempSaveInStream.close();
        tempSaveInStream = null;
    }

    private long linXRefTable(OutputByteStream os, CosList objInfos) throws IOException {
        CosObjectInfo objInfo;
        long retVal = 0L;
        os.write(StringOps.toByteArray(XREF));
        int first = 0;
        int size = objInfos.size();
        if (size != 0) {
            objInfo = (CosObjectInfo)objInfos.first();
            first = objInfo.getObjNum();
            size -= first;
        }
        os.write(StringOps.toByteArray(Integer.toString(first)));
        os.write(32);
        os.write(StringOps.toByteArray(Integer.toString(size)));
        retVal = os.getPosition();
        os.write(10);
        Iterator<Object> iter = objInfos.iterator();
        while (iter.hasNext()) {
            objInfo = (CosObjectInfo)iter.next();
            objInfo.writeXRefTableEntry(os);
        }
        return retVal;
    }

    private long linXRefStream(OutputByteStream os, CosObjectInfo xrStmObjInfo, CosList objInfos, long curPos, CosDictionary encrypt, CosDictionary root, CosDictionary info, CosArray id, long prev, boolean setTrailer) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        CosObjectInfo objInfo;
        long retVal = os.getPosition() - 1L;
        xrStmObjInfo.setPos(curPos);
        CosStream xrefStm = (CosStream)xrStmObjInfo.getObject();
        int first = 0;
        int size = objInfos.size();
        if (size != 0) {
            objInfo = (CosObjectInfo)objInfos.first();
            first = objInfo.getObjNum();
            size -= first;
        }
        xrefStm.put(ASName.k_Type, ASName.k_XRef);
        xrefStm.put(ASName.k_Size, first + size);
        xrefStm.put(ASName.k_Filter, ASName.k_FlateDecode);
        CosArray iValues = this.createCosArray();
        iValues.addInt(first);
        iValues.addInt(size);
        xrefStm.put(ASName.k_Index, iValues);
        if (encrypt != null) {
            xrefStm.put(ASName.k_Encrypt, encrypt);
        }
        if (root != null) {
            xrefStm.put(ASName.k_Root, root);
        }
        if (info != null) {
            xrefStm.put(ASName.k_Info, info);
        }
        if (id != null) {
            xrefStm.put(ASName.k_ID, id);
        }
        if (prev != 0L) {
            xrefStm.put(ASName.k_Prev, prev);
        }
        int[] widths = this.setWidthsArray(objInfos, xrefStm, curPos);
        OutputByteStream buf = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        Iterator<Object> iter = objInfos.iterator();
        while (iter.hasNext()) {
            objInfo = (CosObjectInfo)iter.next();
            objInfo.writeXRefStreamEntry(buf, widths);
        }
        xrefStm.newDataDecoded(buf.closeAndConvert());
        buf = null;
        xrStmObjInfo.writeIndirectObject(os, curPos);
        if (setTrailer) {
            this.mTrailer = xrefStm;
        }
        return retVal;
    }

    public boolean isCacheEnabled() {
        return this.mCacheEnabled;
    }

    long writeIndirectObjects(CosList infos, OutputByteStream os, boolean saveToCopy) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        long curpos = os.getPosition();
        if (infos.isEmpty()) {
            return curpos;
        }
        Iterator<Object> iter = infos.iterator();
        while (iter.hasNext()) {
            CosObject obj;
            CosObjectInfo info = (CosObjectInfo)iter.next();
            if (info.isDirty() && (obj = info.getObject()) instanceof CosObjectStream) {
                ((CosObjectStream)obj).writeObjectsToStream();
            }
            curpos = info.writeIndirectObject(os, curpos, saveToCopy);
        }
        return curpos;
    }

    CosList copyInfoList(CosList src) {
        CosList dest = new CosList();
        Iterator<Object> iter = src.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            dest.add(info.getObjNum(), info);
        }
        return dest;
    }

    ArrayList prepareXRef(CosList infos, boolean full) {
        ArrayList<CosList> sections = new ArrayList<CosList>();
        CosList secList = new CosList();
        sections.add(secList);
        CosObjectInfo freeInfo = this.getObjectInfo(0, 65535);
        if (infos.isEmpty()) {
            secList.add(freeInfo);
        } else {
            int infoCounter;
            Iterator<Object> infoIter = infos.iterator();
            int nextObjNum = ((CosObjectInfo)infos.iterator().next()).getObjNum();
            if (full) {
                for (infoCounter = 0; infoCounter < nextObjNum; ++infoCounter) {
                    secList.add(freeInfo);
                }
            } else {
                infoCounter = nextObjNum;
            }
            while (infoIter.hasNext()) {
                CosObjectInfo nextInfo = (CosObjectInfo)infoIter.next();
                nextObjNum = nextInfo.getObjNum();
                if (infoCounter < nextObjNum) {
                    if (full) {
                        while (infoCounter < nextObjNum) {
                            secList.add(freeInfo);
                            ++infoCounter;
                        }
                    } else {
                        secList = new CosList();
                        sections.add(secList);
                        infoCounter = nextObjNum;
                    }
                }
                secList.add(nextInfo);
                ++infoCounter;
            }
        }
        return sections;
    }

    long writeXRefTable(ArrayList sections, OutputByteStream os) throws IOException {
        os.write(StringOps.toByteArray(XREF));
        for (CosList nextsec : sections) {
            CosObjectInfo firstObjInfo = (CosObjectInfo)nextsec.get(0);
            int firstObjNum = firstObjInfo.getObjNum();
            os.write(StringOps.toByteArray(Integer.toString(firstObjNum)));
            os.write(32);
            os.write(StringOps.toByteArray(Integer.toString(nextsec.size())));
            os.write(32);
            os.write(10);
            Iterator<Object> secobjitr = nextsec.iterator();
            while (secobjitr.hasNext()) {
                CosObjectInfo secinfo = (CosObjectInfo)secobjitr.next();
                secinfo.writeXRefTableEntry(os);
            }
        }
        return os.getPosition();
    }

    long buildXRefStream(ArrayList sections, OutputByteStream os, CosList objStmsToBeDeleted) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        long xrefpos = os.getPosition();
        CosStream xrefStream = this.createCosStream();
        xrefStream.put(ASName.k_Type, ASName.k_XRef);
        this.copyTrailerFields(xrefStream, this.getNumObjects());
        if (objStmsToBeDeleted == null) {
            xrefStream.put(ASName.k_Prev, this.mXRef.getLastXRefSectionPosition());
        }
        CosArray indexVal = this.createCosArray();
        Iterator seciter = sections.iterator();
        while (seciter.hasNext()) {
            CosList nextsec = (CosList)seciter.next();
            CosObjectInfo firstObjInfo = (CosObjectInfo)nextsec.get(0);
            int firstObjNum = firstObjInfo.getObjNum();
            int secsize = nextsec.size();
            indexVal.addInt(firstObjNum);
            if (!seciter.hasNext()) {
                int thisObjNum = xrefStream.getObjNum();
                if (thisObjNum == firstObjNum + secsize) {
                    ++secsize;
                } else if (objStmsToBeDeleted != null) {
                    CosObjectInfo freeInfo = this.getObjectInfo(0, 65535);
                    while (thisObjNum > firstObjNum + secsize++) {
                        nextsec.add(freeInfo);
                    }
                } else {
                    indexVal.addInt(secsize);
                    indexVal.addInt(thisObjNum);
                    secsize = 1;
                }
            }
            indexVal.addInt(secsize);
        }
        xrefStream.put(ASName.k_Index, indexVal);
        int[] widths = this.setWidthsArray(sections, xrefStream, xrefpos);
        xrefStream.put(ASName.k_Filter, ASName.k_FlateDecode);
        OutputByteStream buf = this.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
        for (CosList nextsec : sections) {
            Iterator<Object> secobjitr = nextsec.iterator();
            while (secobjitr.hasNext()) {
                CosObjectInfo secinfo = (CosObjectInfo)secobjitr.next();
                if (objStmsToBeDeleted != null && objStmsToBeDeleted.containsIndex(secinfo.getObjNum())) {
                    secinfo = this.getObjectInfo(0, 65535);
                }
                secinfo.writeXRefStreamEntry(buf, widths);
            }
        }
        CosObjectInfo xrefStreamInfo = xrefStream.getInfo();
        xrefStreamInfo.markDirty();
        xrefStreamInfo.setPos(xrefpos);
        xrefStreamInfo.writeXRefStreamEntry(buf, widths);
        xrefStream.newDataDecoded(buf.closeAndConvert());
        buf = null;
        xrefStreamInfo.writeIndirectObject(os, xrefpos);
        if (!this.mSaveToCopy) {
            this.mTrailer = xrefStream;
        }
        return os.getPosition();
    }

    CosList prepareHybridInfoList(CosList dirtyObjectInfos, CosList compressedList, CosList objStmsToBeDeleted) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosList hybridInfos = new CosList();
        Iterator<Object> objIter = dirtyObjectInfos.iterator();
        while (objIter.hasNext()) {
            boolean compressed;
            CosObjectInfo origInfo = (CosObjectInfo)objIter.next();
            int objNum = origInfo.getObjNum();
            if (objStmsToBeDeleted != null && objStmsToBeDeleted.containsIndex(objNum)) {
                objIter.remove();
                continue;
            }
            CosObject origObj = origInfo.getObject();
            if (origObj == null || !(compressed = compressedList != null ? compressedList.containsIndex(objNum) : origInfo.isCompressed()) && !(origObj instanceof CosObjectStream)) continue;
            hybridInfos.add(objNum, origInfo);
            objIter.remove();
        }
        CosStream xref = this.createCosStream();
        CosObjectInfo xinfo = xref.getInfo();
        xref.put(ASName.k_Type, ASName.k_XRef);
        xref.put(ASName.k_Size, hybridInfos.size() + 1);
        xref.put(ASName.k_Filter, ASName.k_FlateDecode);
        hybridInfos.add(xinfo.getObjNum(), xinfo);
        return hybridInfos;
    }

    void writeTrailer(CosDictionary trailer, OutputByteStream os) throws PDFCosParseException, PDFIOException, IOException, PDFSecurityException {
        os.write(StringOps.toByteArray("trailer\n"));
        trailer.writeOut(os);
        os.write(10);
    }

    void writeEOF(long xrefPos, OutputByteStream os) throws IOException {
        os.write(StringOps.toByteArray(STARTXREF));
        os.write(StringOps.toByteArray(Long.toString(xrefPos)));
        os.write(StringOps.toByteArray(EOF));
    }

    public boolean isEncrypted() {
        CosDictionary trailer = this.getTrailer();
        return trailer != null ? trailer.containsKey(ASName.k_Encrypt) : false;
    }

    public CosEncryption getEncryption() {
        return this.mEncryption;
    }

    CosDictionary getEncryptionDictionary() {
        return this.mEncryption.getEncryption();
    }

    void setEncryptionDictionary(CosDictionary encrypt) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (encrypt != null) {
            int savedState = 0;
            CosDictionary trailer = this.getTrailer();
            CosObjectInfo trailerInfo = trailer.getInfo();
            if (trailerInfo != null) {
                savedState = trailerInfo.getState();
            }
            trailer.put(ASName.k_Encrypt, encrypt);
            if (trailerInfo != null) {
                trailerInfo.setState(savedState);
            }
        }
    }

    void removeEncryptionDictionary() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int savedState = 0;
        CosDictionary trailer = this.getTrailer();
        CosObjectInfo trailerInfo = trailer.getInfo();
        if (trailerInfo != null) {
            savedState = trailerInfo.getState();
        }
        trailer.remove(ASName.k_Encrypt);
        if (trailerInfo != null) {
            trailerInfo.setState(savedState);
        }
    }

    boolean needsEncryption() {
        return this.getEncryption().needsEncryption();
    }

    protected CosLinearization getLinearization() {
        return this.mCosLin;
    }

    public CosObject getIndirectObjectByNumber(int objNum) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject result;
            if (objNum > this.mNumObjects) {
                return null;
            }
            CosObjectInfo indexedInfo = this.getIndexedInfo(objNum);
            CosObjectInfo info = indexedInfo;
            if (info == null) {
                info = this.mXRef.getInfo(objNum);
            } else if (info.isFree()) {
                return null;
            }
            if (info == null) {
                return null;
            }
            if (indexedInfo == null) {
                this.putIndexedInfo(objNum, info);
            }
            if ((result = info.getObject()) == null) {
                try {
                    result = this.mXRef.getIndirectObject(info);
                }
                catch (PDFCosParseException e) {
                    if (this.mOptions.getLateRepairEnabled()) {
                        if (!this.repairTypes.contains((Object)REPAIRTYPE.xrefRepair)) {
                            this.mXRef.rebuildLate();
                            this.repairTypes.add(REPAIRTYPE.xrefRepair);
                            try {
                                result = this.mXRef.getIndirectObject(info);
                            }
                            catch (PDFCosParseException pDFCosParseException) {}
                        }
                    }
                    throw new PDFCosParseException("XRef repair required but not enabled", e);
                }
            }
            return result;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObjectInfo getIndirectObjectInfoByNumber(int objNum) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            if (objNum > this.mNumObjects) {
                return null;
            }
            CosObjectInfo indexedInfo = this.getIndexedInfo(objNum);
            CosObjectInfo info = indexedInfo;
            if (info == null) {
                info = this.mXRef.getInfo(objNum);
            } else if (info.isFree()) {
                return null;
            }
            if (info == null) {
                return null;
            }
            if (indexedInfo == null) {
                this.putIndexedInfo(objNum, info);
            }
            return info;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    CosObject getIndirectObject(CosObjectInfo info) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        if (info == null) {
            return null;
        }
        CosObject result = info.getObject();
        if (result == null) {
            try {
                result = this.mXRef.getIndirectObject(info);
            }
            catch (PDFCosParseException e) {
                if (e.hasErrorType(PDFCosParseException.CosParseErrorType.NumberParseError)) {
                    throw e;
                }
                if (this.mOptions.getLateRepairEnabled()) {
                    if (!this.repairTypes.contains((Object)REPAIRTYPE.xrefRepair)) {
                        this.repairTypes.add(REPAIRTYPE.xrefRepair);
                        this.mXRef.rebuildLate();
                        try {
                            result = this.mXRef.getIndirectObject(info);
                        }
                        catch (PDFCosParseException pDFCosParseException) {}
                    }
                }
                throw new PDFCosParseException("XRef repair required but not enabled", e);
            }
        }
        if (result == null) {
            result = this.createCosNull();
        }
        return result;
    }

    public long getObjEOF(CosObject obj) {
        return this.mXRef.getObjEOF(obj.getInfo());
    }

    public int getObjRevision(CosObject obj) {
        return this.mXRef.getObjRevision(obj.getInfo());
    }

    public int getHeaderTrashCount() {
        return this.mHeaderTrashCount;
    }

    public int getTrailerTrashCount() {
        return this.mTrailerTrashCount;
    }

    public int getNumRevisions() {
        return this.mXRef.getNumRevisions();
    }

    public long getFileSize() throws PDFIOException {
        try {
            return this.mBuf.length();
        }
        catch (IOException e) {
            throw new PDFIOException("Error with stream underlying document.", e);
        }
    }

    public CosList getChangedObjects(long eof) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList dirtyObjectInfos = this.buildObjectList(true);
        CosList modList = new CosList();
        Iterator<Object> iter = dirtyObjectInfos.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            int objNum = info.getObjNum();
            int objGen = info.getObjGen();
            if (info.isFree()) {
                objGen = -1;
            }
            modList.add(objNum, new CosObjectID(objNum, objGen));
        }
        try {
            this.mXRef.getChangedObjects(eof, modList);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        modList.delete(0);
        return modList;
    }

    long getObjPos(CosObject obj) {
        CosObjectInfo info = obj.getInfo();
        if (info == null) {
            return 0L;
        }
        if (info.isCompressed()) {
            return info.getStreamInfo().getPos();
        }
        return info.getPos();
    }

    private void copyTrailerFields(CosDictionary trailer, int newSize) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary oldTrailer = this.getTrailer();
        if (oldTrailer.containsKey(ASName.k_Root)) {
            trailer.put(ASName.k_Root, oldTrailer.get(ASName.k_Root));
        }
        if (oldTrailer.containsKey(ASName.k_Info)) {
            CosDictionary dict = (CosDictionary)oldTrailer.get(ASName.k_Info);
            if (!dict.isIndirect()) {
                CosCloneMgr cloneMgr = new CosCloneMgr(this);
                dict = (CosDictionary)cloneMgr.clone(dict);
            }
            trailer.put(ASName.k_Info, dict);
        }
        if (oldTrailer.containsKey(ASName.k_Encrypt)) {
            trailer.put(ASName.k_Encrypt, oldTrailer.get(ASName.k_Encrypt));
        }
        if (!this.mIsFDF) {
            if (oldTrailer.containsKey(ASName.k_ID)) {
                trailer.put(ASName.k_ID, oldTrailer.get(ASName.k_ID));
            }
            trailer.put(ASName.k_Size, newSize);
        }
    }

    CosArray createUpdateDocID(boolean both) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject idArray = null;
        if (!(both || (idArray = this.getTrailer().get(ASName.k_ID)) instanceof CosArray && ((CosArray)idArray).size() == 2)) {
            idArray = null;
            both = true;
        }
        IDProducer idproc = new IDProducer();
        DataOutputStream uidOut = new DataOutputStream(idproc);
        UID newUID = new UID();
        try {
            newUID.write(uidOut);
            if (idArray != null) {
                ASString oldID = ((CosArray)idArray).getString(1);
                idproc.write(oldID.getBytes());
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
        byte[] newID = idproc.getDigest();
        if (idArray == null) {
            idArray = this.createCosArray(0);
            ((CosArray)idArray).addString(new ASString(newID));
            ((CosArray)idArray).add(this.createCosNull());
        }
        ((CosArray)idArray).setString(1, new ASString(newID));
        if (both) {
            ((CosArray)idArray).setString(0, ((CosArray)idArray).getString(1));
        }
        for (int i = 0; i < 2; ++i) {
            CosString elem = ((CosArray)idArray).getCosString(i);
            elem.setWriteHex(true);
            elem.setToEncrypt(false);
        }
        return (CosArray)idArray;
    }

    public void markDirty() {
        this.mDocIsDirty = true;
    }

    public boolean isDirty() {
        return this.mDocIsDirty;
    }

    public boolean markNotDirty() {
        boolean isDirty = this.mDocIsDirty;
        this.mDocIsDirty = false;
        return isDirty;
    }

    public long getEOF() throws PDFIOException {
        if (this.mBuf == null) {
            return 0L;
        }
        try {
            return this.mBuf.length();
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public int getXRefType() {
        if (this.mXRef != null) {
            int xrefType = this.mXRef.getType();
            if (xrefType == 1) {
                return 2;
            }
            if (xrefType == 2) {
                return 3;
            }
        }
        return 1;
    }

    CosList buildObjectList(boolean dirtyOnly) {
        CosList objectList = new CosList();
        Iterator<Object> iter = this.mObjectInfos.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            if ((!dirtyOnly || !info.isDirty()) && (dirtyOnly || info.isFree())) continue;
            objectList.add(info.getObjNum(), info);
        }
        return objectList;
    }

    CosList buildCompObjList(int xrefStyle) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        CosList stmObjList;
        CosList stmList = new CosList();
        Iterator<Object> iter = this.mObjectInfos.iterator();
        CosDictionary catalog = this.getRoot();
        CosDictionary encrypt = this.getEncryptionDictionary();
        while (iter.hasNext()) {
            CosObject type;
            CosObject obj;
            CosObjectInfo info = (CosObjectInfo)iter.next();
            if (!info.isDirty()) continue;
            if (info.isCompressed()) {
                CosObjectInfo stmInfo = info.getStreamInfo();
                stmObjList = (CosList)stmList.get(stmInfo.getObjNum());
                if (stmObjList == null) {
                    stmObjList = new CosList();
                    stmList.add(stmInfo.getObjNum(), stmObjList);
                }
                stmObjList.add(info.getObjNum(), info);
                continue;
            }
            if (xrefStyle != 2 || (obj = info.getObject()) == null || obj instanceof CosStream || obj == catalog || obj == encrypt || obj instanceof CosDictionary && (type = ((CosDictionary)obj).get(ASName.k_Type)) instanceof CosName && dictionariesNotToBeCompressed.contains(type.nameValue())) continue;
            this.mCompObjInfos.add(info.getObjNum(), info);
        }
        Iterator<Object> compIter = this.mCompObjInfos.iterator();
        CosContainer curObjStm = null;
        stmObjList = null;
        int curIndex = 200;
        while (compIter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)compIter.next();
            CosObject obj = info.getObject();
            if (curIndex == 200) {
                curIndex = 0;
                if (curObjStm != null) {
                    curObjStm.markNotDirty();
                }
                curObjStm = this.createCosObjectStream();
                stmObjList = new CosList();
                stmList.add(curObjStm.getInfo().getObjNum(), stmObjList);
            }
            ((CosObjectStream)curObjStm).addObjectToStream(obj);
            stmObjList.add(info.getObjNum(), info);
            ++curIndex;
        }
        if (curObjStm != null) {
            curObjStm.markNotDirty();
        }
        return stmList;
    }

    protected void postSaveCleanup(OutputByteStream outputByteStream, ByteWriter byteWriter) throws PDFCosParseException, IOException, PDFIOException, PDFSecurityException {
        if (this.mBuf != null) {
            this.mBuf.close();
        }
        this.releaseAllCosObjects();
        if (this.mByteReader != byteWriter) {
            this.mStreamManager.resetMasterByteReader(byteWriter);
            this.mByteReader = byteWriter;
        }
        this.mBuf = outputByteStream.closeAndConvert();
        this.mXRef.resetXRef(this.mBuf.slice());
        this.mOrigNumObjects = this.mNumObjects;
        this.mCosLin = null;
        this.mDocIsDirty = false;
        if (this.cosRepairList != null) {
            this.cosRepairList.clear();
        }
        this.repairTypes.clear();
        this.documentCosLevelRepaired = false;
        this.nextIncrementalSectionOffset = -1L;
    }

    private void closeAllCosObjects() throws PDFIOException, PDFCosParseException, PDFSecurityException, IOException {
        Exception saveEx = null;
        Iterator<Object> iter = this.mObjectInfos.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            try {
                CosObject obj = info.getObject(false);
                if (obj == null) continue;
                obj.close();
            }
            catch (Exception e) {
                saveEx = e;
            }
        }
        if (saveEx != null) {
            if (saveEx instanceof PDFIOException) {
                throw (PDFIOException)saveEx;
            }
            if (saveEx instanceof PDFCosParseException) {
                throw (PDFCosParseException)saveEx;
            }
            if (saveEx instanceof PDFSecurityException) {
                throw (PDFSecurityException)saveEx;
            }
            if (saveEx instanceof IOException) {
                throw (IOException)saveEx;
            }
            throw new PDFIOException(saveEx);
        }
    }

    private void releaseAllCosObjects() throws PDFIOException, PDFCosParseException, PDFSecurityException, IOException {
        Iterator<Object> iter = this.mObjectInfos.iterator();
        while (iter.hasNext()) {
            CosObjectInfo info = (CosObjectInfo)iter.next();
            CosObject obj = info.getObject(false);
            if (obj == null) continue;
            obj.release();
        }
    }

    public CosArray createCosArray(ArrayList array, int directStatus) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray newArray = null;
        if (directStatus == 1) {
            CosObjectInfo info = this.newObjectInfo();
            newArray = new CosArray(this, array, info);
            try {
                info.markDirty();
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        } else {
            newArray = new CosArray(this, array, null);
        }
        return newArray;
    }

    public CosArray createIndirectCosArray(ArrayList array) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArray(array, 1);
    }

    public CosArray createCosArray(ArrayList array) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArray(array, 0);
    }

    public CosArray createCosArrayFromNonCosData(ArrayList array, int directStatus) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray newArray = this.createCosArray(directStatus);
        Iterator arrayIter = array.iterator();
        CosObject obj = null;
        while (arrayIter.hasNext()) {
            obj = this.convertToCosObject(arrayIter.next());
            if (obj == null) continue;
            newArray.add(obj);
        }
        return newArray;
    }

    public CosArray createIndirectCosArrayFromNonCosData(ArrayList array) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArrayFromNonCosData(array, 1);
    }

    public CosArray createCosArrayFromNonCosData(ArrayList array) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArrayFromNonCosData(array, 0);
    }

    public CosArray createCosArray(int directStatus) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArray(new ArrayList(), directStatus);
    }

    public CosArray createIndirectCosArray() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArray(1);
    }

    public CosArray createCosArray() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosArray(0);
    }

    public CosBoolean createCosBoolean(boolean value) {
        return new CosBoolean(this, value, null);
    }

    public CosBoolean createCosBoolean(Boolean value) {
        return new CosBoolean(this, value, null);
    }

    public CosDictionary createCosDictionary(int directStatus) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary newDict = null;
        if (directStatus == 1) {
            CosObjectInfo info = this.newObjectInfo();
            newDict = new CosDictionary(this, new LinkedHashMap<ASName, CosObject>(), info);
            try {
                info.markDirty();
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        } else {
            newDict = new CosDictionary(this, new LinkedHashMap<ASName, CosObject>(), null);
        }
        return newDict;
    }

    public CosDictionary createCosDictionary() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosDictionary(1);
    }

    public CosDictionary createDirectCosDictionary() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosDictionary(0);
    }

    public CosDictionary createCosDictionary(Map cosData, int directStatus) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary newDict = null;
        if (directStatus == 1) {
            CosObjectInfo info = this.newObjectInfo();
            newDict = new CosDictionary(this, cosData, info);
            try {
                info.markDirty();
            }
            catch (IOException e) {
                throw new PDFIOException(e);
            }
        } else {
            newDict = new CosDictionary(this, cosData, null);
        }
        return newDict;
    }

    public CosDictionary createCosDictionary(Map cosData) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosDictionary(cosData, 1);
    }

    public CosDictionary createDirectCosDictionary(Map cosData) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosDictionary(cosData, 0);
    }

    public CosDictionary createCosDictionaryFromNonCosData(Map data, int directStatus) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosDictionary newDict = this.createCosDictionary(directStatus);
        for (Map.Entry entry : data.entrySet()) {
            CosObject cosObj;
            if (entry == null || entry.getKey() == null || (cosObj = this.convertToCosObject(entry.getValue())) == null) continue;
            newDict.put(ASName.create((String)entry.getKey()), cosObj);
        }
        return newDict;
    }

    public CosDictionary createCosDictionaryFromNonCosData(Map javaMap) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosDictionaryFromNonCosData(javaMap, 1);
    }

    public CosDictionary createDirectCosDictionaryFromNonCosData(Map javaMap) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return this.createCosDictionaryFromNonCosData(javaMap, 0);
    }

    public CosName createCosName(ASName value) {
        return new CosName(this, value, null);
    }

    public CosNull createCosNull() {
        return new CosNull(this);
    }

    public CosNumeric createCosNumeric(Number value) {
        return new CosNumeric(this, value, null);
    }

    public CosNumeric createCosNumeric(int value) {
        return new CosNumeric(this, value, null);
    }

    public CosNumeric createCosNumeric(long value) {
        return new CosNumeric(this, value, null);
    }

    public CosNumeric createCosNumeric(double value) {
        return new CosNumeric(this, new Double(value), null);
    }

    public CosNumeric createCosNumeric(byte[] inputRep) throws PDFCosParseException {
        return new CosNumeric(this, inputRep, null);
    }

    public CosNumeric createCosNumeric(CosNumeric source) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return new CosNumeric(this, source);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObjectStream createCosObjectStream() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            return new CosObjectStream(this);
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosStream createCosStream() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObjectInfo info = this.newObjectInfo();
            info.markDirty();
            CosStream cosObj = new CosStream(this, info);
            cosObj.setIsEncrypted(false);
            cosObj.setToEncrypt(true);
            return cosObj;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosStream createCosStream(InputByteStream data) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObjectInfo info = this.newObjectInfo();
            info.markDirty();
            CosStream cosObj = new CosStream(this, info, data);
            cosObj.setIsEncrypted(false);
            cosObj.setToEncrypt(true);
            return cosObj;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosString createCosString(ASString value) {
        return this.createCosString(value.getBytes());
    }

    public CosString createCosString(byte[] value) {
        return new CosString(this, value, 0, value.length, false, null);
    }

    public CosString createCosString(String value) {
        byte[] bytes = PDFDocEncoding.fromUnicodeString(value);
        return new CosString(this, bytes, 0, bytes.length, false, null);
    }

    public CosString createHexCosString(ASString value) {
        return this.createHexCosString(value.getBytes());
    }

    public CosString createHexCosString(byte[] value) {
        return new CosString(this, value, 0, value.length, false, null, true);
    }

    public CosString createHexCosString(String value) {
        byte[] bytes = PDFDocEncoding.fromUnicodeString(value);
        return new CosString(this, bytes, 0, bytes.length, false, null, true);
    }

    protected CosObject convertToCosObject(Object val) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (val instanceof CosObject) {
            return (CosObject)val;
        }
        CosObject newObj = null;
        if (val instanceof Boolean) {
            newObj = this.createCosBoolean((Boolean)val);
        } else if (val instanceof Number) {
            newObj = this.createCosNumeric((Number)val);
        } else if (val instanceof byte[]) {
            newObj = this.createCosString((byte[])val);
        } else if (val instanceof String) {
            newObj = this.createCosName(ASName.create((String)val));
        } else if (val instanceof ASName) {
            newObj = this.createCosName((ASName)val);
        } else if (val instanceof HashMap) {
            newObj = this.createCosDictionaryFromNonCosData((HashMap)val, 0);
        } else if (val instanceof ArrayList) {
            newObj = this.createCosArrayFromNonCosData((ArrayList)val, 0);
        }
        return newObj;
    }

    void setRepairedValue(CosDictionary obj, ASName key, CosObject value) {
        if (!this.documentCosLevelRepaired) {
            this.cosRepairList = new CosRepairList(this);
            this.documentCosLevelRepaired = true;
        }
        this.cosRepairList.setRepairedValue(obj, key, value);
    }

    void setRepairedValue(Integer objNum, CosObject obj) {
        if (obj == null) {
            return;
        }
        if (!this.documentCosLevelRepaired) {
            this.cosRepairList = new CosRepairList(this);
            this.documentCosLevelRepaired = true;
        }
        this.cosRepairList.setRepairedValue(objNum, obj);
    }

    CosObject getRepairedValue(Integer objNum, ASName key) {
        return this.documentCosLevelRepaired ? this.cosRepairList.getRepairedValue(objNum, key) : null;
    }

    CosObject getRepairedValue(Integer objNum) {
        return this.documentCosLevelRepaired && this.cosRepairList != null ? this.cosRepairList.getRepairedValue(objNum) : null;
    }

    boolean isDocumentCosLevelRepaired() {
        return this.documentCosLevelRepaired;
    }

    void setDocumentCosLevelRepaired() {
        this.documentCosLevelRepaired = true;
    }

    CosRepairList getRepairList() {
        return this.cosRepairList;
    }

    public void setUseRepairList(boolean useRepairList) {
        this.useRepairList = useRepairList;
    }

    boolean getUseRepairList() {
        return this.useRepairList;
    }

    boolean isFDF() {
        return this.mIsFDF;
    }

    static {
        dictionariesNotToBeCompressed.add(ASName.k_Sig);
        dictionariesNotToBeCompressed.add(ASName.k_DocTimeStamp);
        mLoggingPath = null;
    }

    private static class IDProducer
    extends OutputStream {
        MessageDigest mDigest;

        IDProducer() {
            try {
                this.mDigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("MD5 is not available.", e);
            }
        }

        @Override
        public void write(int b) {
            this.mDigest.update((byte)b);
        }

        byte[] getDigest() {
            return this.mDigest.digest();
        }
    }
}

