/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.core.cos;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosBoolean;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionaryValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectRef;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CosDictionary
extends CosContainer {
    Map<ASName, CosObject> mData;
    boolean invalidDict = false;

    public boolean isInvalidDict() {
        return this.invalidDict;
    }

    CosDictionary(CosDocument doc, Map<ASName, CosObject> data, CosObjectInfo info) {
        super(doc, info);
        if (data.containsKey(null)) {
            data.remove(null);
            this.invalidDict = true;
        }
        this.mData = data;
        boolean bl = this.repaired = info != null && doc.isDocumentCosLevelRepaired() && doc.getRepairList() != null && doc.getRepairList().isObjectRepaired(info.getObjNum());
        if (!this.mData.isEmpty() && this.isIndirect()) {
            for (CosObject obj : this.mData.values()) {
                if (obj.isIndirect()) continue;
                if (obj instanceof CosString) {
                    ((CosString)obj).setParentObj(this);
                    continue;
                }
                if (!(obj instanceof CosContainer)) continue;
                if (obj instanceof CosArray) {
                    ((CosArray)obj).setParentObj(this);
                    continue;
                }
                ((CosDictionary)obj).setParentObj(this);
            }
        }
    }

    public CosDictionary copy() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (this.isIndirect()) {
            return this;
        }
        CosDictionary copy = this.getDocument().createCosDictionary(0);
        Iterator<ASName> keyiter = this.keyIterator();
        while (keyiter.hasNext()) {
            ASName key = keyiter.next();
            CosObject obj = this.get(key);
            if (!obj.isIndirect()) {
                if (obj instanceof CosArray) {
                    obj = ((CosArray)obj).copy();
                } else if (obj instanceof CosDictionary) {
                    obj = ((CosDictionary)obj).copy();
                } else if (obj instanceof CosString) {
                    obj = ((CosString)obj).copy();
                }
            }
            copy.put(key, obj);
        }
        return copy;
    }

    public List<ASName> getKeys() {
        ArrayList<ASName> keys = new ArrayList<ASName>();
        Iterator<ASName> iter = this.keyIterator();
        while (iter.hasNext()) {
            ASName key = iter.next();
            keys.add(key);
        }
        return keys;
    }

    @Override
    public int getType() {
        return 6;
    }

    public boolean isEmpty() {
        return this.mData.isEmpty();
    }

    public int size() {
        return this.mData.size();
    }

    public boolean containsKey(Object key) {
        return this.mData.containsKey(key);
    }

    @Override
    void setParentObj(CosContainer parent) {
        if (this.isIndirect()) {
            return;
        }
        this.mParentObj = parent;
        List<CosObject> values = this.values();
        for (CosObject obj : values) {
            if (obj.isIndirect()) continue;
            if (obj instanceof CosString) {
                ((CosString)obj).setParentObj(parent);
                continue;
            }
            if (!(obj instanceof CosContainer)) continue;
            if (obj instanceof CosArray) {
                ((CosArray)obj).setParentObj(parent);
                continue;
            }
            ((CosDictionary)obj).setParentObj(parent);
        }
    }

    public void setEncryptionState(boolean state) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            Iterator<ASName> iter = this.keyIterator();
            while (iter.hasNext()) {
                ASName key = iter.next();
                CosObject value = this.get(key);
                if (value.getType() == 4) {
                    ((CosString)value).setIsEncrypted(state);
                    ((CosString)value).setToEncrypt(state);
                    continue;
                }
                if (value.getType() == 7) {
                    ((CosStream)value).setIsEncrypted(state);
                    ((CosStream)value).setToEncrypt(state);
                    continue;
                }
                if (value.getType() == 6) {
                    ((CosDictionary)value).setEncryptionState(state);
                    continue;
                }
                if (value.getType() != 5) continue;
                ((CosArray)value).setEncryptionState(state);
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObject get(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject result = null;
            if (this.repaired) {
                result = this.getDocument().getRepairedValue(this.getObjNum(), key);
            }
            if (result == null) {
                result = this.mData.get(key);
            }
            if (result instanceof CosObjectRef) {
                result = this.getDocument().resolveReference((CosObjectRef)result);
            }
            return result;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    CosObjectRef getRef(ASName key) {
        CosObject result = this.mData.get(key);
        if (result instanceof CosObjectRef) {
            return (CosObjectRef)result;
        }
        return null;
    }

    public int getType(ASName key) {
        if (!this.mData.containsKey(key)) {
            return 9;
        }
        CosObject val = this.mData.get(key);
        if (val == null) {
            return 0;
        }
        return val.getType();
    }

    public ASName getName(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.nameValue();
    }

    public Boolean getBoolean(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.booleanValue();
    }

    public Double getDouble(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return new Double(val.doubleValue());
    }

    public Integer getInt(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.intValue();
    }

    public Long getLong(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.longValue();
    }

    public ASString getString(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return val.stringValue();
    }

    public CosString getCosString(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = this.get(key);
        if (obj == null || obj instanceof CosNull) {
            return null;
        }
        return (CosString)this.get(key);
    }

    public CosArray getCosArray(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = this.get(key);
        if (obj == null || obj instanceof CosNull) {
            return null;
        }
        return (CosArray)this.get(key);
    }

    public CosDictionary getCosDictionary(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = this.get(key);
        if (obj == null || obj instanceof CosNull) {
            return null;
        }
        return (CosDictionary)this.get(key);
    }

    public CosStream getCosStream(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject obj = this.get(key);
        if (obj == null || obj instanceof CosNull) {
            return null;
        }
        return (CosStream)this.get(key);
    }

    public InputByteStream getStream(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject val = this.get(key);
        if (val == null) {
            return null;
        }
        return ((CosStream)val).getStreamDecoded();
    }

    public void setRepairedValue(ASName key, CosObject cosObject) {
        this.repaired = true;
        this.getDocument().setRepairedValue(this, key, cosObject);
    }

    public CosObject put(ASName key, CosObject cosObject) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            if (this.getDocument() != cosObject.getDocument()) {
                throw new PDFCosParseException("Object and container must be in same document");
            }
            if (cosObject.isIndirect()) {
                if (!(cosObject instanceof CosObjectRef)) {
                    cosObject = this.getDocument().getObjectRef(cosObject.getInfo());
                }
                this.mData.put(key, cosObject);
            } else {
                CosContainer parentObj;
                CosContainer cosContainer = parentObj = this.isIndirect() ? this : this.mParentObj;
                if (cosObject instanceof CosContainer) {
                    CosContainer oldParentObj = ((CosContainer)cosObject).getParentObj();
                    if (oldParentObj != null) {
                        cosObject = cosObject instanceof CosArray ? ((CosArray)cosObject).copy() : ((CosDictionary)cosObject).copy();
                    }
                    ((CosContainer)cosObject).setParentObj(parentObj);
                } else if (cosObject instanceof CosString) {
                    CosContainer oldParentObj = ((CosString)cosObject).getParentObj();
                    if (oldParentObj != null) {
                        cosObject = ((CosString)cosObject).copy();
                    }
                    ((CosString)cosObject).setParentObj(parentObj);
                }
                this.mData.put(key, cosObject);
            }
            if (this.isIndirect()) {
                this.getInfo().markDirty();
            } else if (this.mParentObj != null) {
                this.mParentObj.getInfo().markDirty();
            }
            return cosObject;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObject put(ASName key, ASName value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosName cosValue = this.getDocument().createCosName(value);
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, boolean value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosBoolean cosValue = this.getDocument().createCosBoolean(value);
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, double value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosNumeric cosValue = this.getDocument().createCosNumeric(value);
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, long value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosNumeric cosValue = this.getDocument().createCosNumeric(value);
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, int value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosNumeric cosValue = this.getDocument().createCosNumeric(value);
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, ASString value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosString cosValue = this.getDocument().createCosString(value);
        cosValue.setParentObj(this.isIndirect() ? this : this.mParentObj);
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, String value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosName cosValue = this.getDocument().createCosName(ASName.create(value));
        return this.put(key, cosValue);
    }

    public CosObject put(ASName key, double[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDocument().createCosArray(0);
        for (int i = 0; i < value.length; ++i) {
            cosArray.addDouble(value[i]);
        }
        return this.put(key, cosArray);
    }

    public CosObject put(ASName key, long[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDocument().createCosArray(0);
        for (int i = 0; i < value.length; ++i) {
            cosArray.addLong(value[i]);
        }
        return this.put(key, cosArray);
    }

    public CosObject put(ASName key, ASName[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDocument().createCosArray(0);
        for (int i = 0; i < value.length; ++i) {
            cosArray.addName(value[i]);
        }
        return this.put(key, cosArray);
    }

    public CosObject put(ASName key, int[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDocument().createCosArray(0);
        for (int i = 0; i < value.length; ++i) {
            cosArray.addInt(value[i]);
        }
        return this.put(key, cosArray);
    }

    public CosObject put(ASName key, String[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDocument().createCosArray(0);
        cosArray.setParentObj(this.isIndirect() ? this : this.mParentObj);
        for (int i = 0; i < value.length; ++i) {
            cosArray.addName(ASName.create(value[i]));
        }
        return this.put(key, cosArray);
    }

    public CosObject put(ASName key, boolean[] value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray cosArray = this.getDocument().createCosArray(0);
        for (int i = 0; i < value.length; ++i) {
            cosArray.addBoolean(value[i]);
        }
        return this.put(key, cosArray);
    }

    public void clear() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            if (this.mData.isEmpty()) {
                return;
            }
            this.mData.clear();
            if (this.isIndirect()) {
                this.getInfo().markDirty();
            } else if (this.mParentObj != null) {
                this.mParentObj.getInfo().markDirty();
            }
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public CosObject remove(ASName key) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            CosObject rslt = this.mData.remove(key);
            if (rslt != null) {
                if (rslt instanceof CosObjectRef) {
                    rslt = this.getDocument().resolveReference((CosObjectRef)rslt);
                }
                if (this.isIndirect()) {
                    this.getInfo().markDirty();
                } else if (this.mParentObj != null) {
                    this.mParentObj.getInfo().markDirty();
                }
            }
            return rslt;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    public Set<ASName> keySet() {
        return this.mData.keySet();
    }

    Set<Map.Entry<ASName, CosObject>> entrySet() {
        return this.mData.entrySet();
    }

    public Iterator<ASName> keyIterator() {
        return this.mData.keySet().iterator();
    }

    @Override
    public CosContainerValuesIterator getValuesIterator() {
        Map.Entry[] entries = new Map.Entry[this.size()];
        entries = this.mData.entrySet().toArray(entries);
        return new CosDictionaryValuesIterator(entries);
    }

    public List<CosObject> values() {
        return new ArrayList<CosObject>(this.mData.values());
    }

    @Override
    public Object getValue() throws PDFCosParseException, PDFIOException, PDFSecurityException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (this.mData != null) {
            Iterator<ASName> iter = this.keyIterator();
            while (iter.hasNext()) {
                ASName key = iter.next();
                CosObject value = this.get(key);
                result.put(key.asString(true), value.getValue());
            }
        }
        return result;
    }

    public ASName getKeyForValue(CosObject value) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            for (Map.Entry<ASName, CosObject> entry : this.mData.entrySet()) {
                CosObject thisValue = entry.getValue();
                if (thisValue instanceof CosObjectRef) {
                    thisValue = this.getDocument().resolveReference((CosObjectRef)thisValue);
                }
                if (value != thisValue) continue;
                return entry.getKey();
            }
            return null;
        }
        catch (IOException e) {
            throw new PDFIOException(e);
        }
    }

    @Override
    void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode) throws PDFCosParseException, IOException, PDFSecurityException, PDFIOException {
        outStream.write(60);
        outStream.write(60);
        for (Map.Entry<ASName, CosObject> entry : this.mData.entrySet()) {
            CosObject value;
            entry.getKey().write(outStream);
            CosObject cosObject = value = this.repaired ? this.get(entry.getKey()) : entry.getValue();
            if (value.isIndirect() || value instanceof CosBoolean || value instanceof CosNumeric || value instanceof CosNull) {
                outStream.write(32);
            }
            value.writeOut(outStream, inString, inDebugMode);
        }
        outStream.write(62);
        outStream.write(62);
    }

    @Override
    public boolean equals(CosObject value) {
        HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList = new HashMap<Integer, HashSet<Integer>>();
        return this.safeEquals(value, alreadyComparedCosObjectPairsList);
    }

    @Override
    boolean safeEquals(CosObject value, HashMap<Integer, HashSet<Integer>> alreadyComparedCosObjectPairsList) {
        if (!(value instanceof CosDictionary) || value.getDocument() != this.getDocument()) {
            return false;
        }
        if (value == this) {
            return true;
        }
        if (!this.addCosObjectPair(value.getObjNum(), alreadyComparedCosObjectPairsList)) {
            return true;
        }
        CosDictionary dict = (CosDictionary)value;
        Iterator<Map.Entry<ASName, CosObject>> entriesItr1 = this.mData.entrySet().iterator();
        Iterator<Map.Entry<ASName, CosObject>> entriesItr2 = dict.mData.entrySet().iterator();
        int size1 = 0;
        int size2 = 0;
        ArrayList<ASName> compoundEntriesKeyList = new ArrayList<ASName>();
        ASName key2 = null;
        CosObject dictValue = null;
        CosObject thisValue = null;
        try {
            while (entriesItr1.hasNext()) {
                key2 = entriesItr1.next().getKey();
                thisValue = this.get(key2);
                if (thisValue instanceof CosNull) continue;
                ++size1;
                if (thisValue instanceof CosScalar) {
                    dictValue = dict.get(key2);
                    if (thisValue.equals(dictValue)) continue;
                    return false;
                }
                compoundEntriesKeyList.add(key2);
            }
            while (entriesItr2.hasNext()) {
                if (entriesItr2.next().getValue() instanceof CosNull) continue;
                ++size2;
            }
            if (size1 != size2) {
                return false;
            }
            for (ASName key2 : compoundEntriesKeyList) {
                if (((CosContainer)this.get(key2)).safeEquals(dict.get(key2), alreadyComparedCosObjectPairsList)) continue;
                return false;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("problem occured while equating " + value.getObjNum() + " with " + this.getObjNum(), e);
        }
        return true;
    }

    public CosObject getInheritable(ASName name, ASName parentKey) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosObject parent;
        CosObject result = this.get(name);
        if ((result == null || result instanceof CosNull) && (parent = this.get(parentKey)) instanceof CosDictionary) {
            return ((CosDictionary)parent).getInheritable(name, parentKey);
        }
        return result;
    }
}

