/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.color;

import com.adobe.internal.pdftoolkit.color.ApplyFunctionInterface;
import com.adobe.internal.pdftoolkit.color.DeviceCMYKtoRGBColorConversion;
import com.adobe.internal.pdftoolkit.color.ToRGBInterface;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.GraphicsUtils;
import java.awt.Color;
import java.awt.color.ColorSpace;

public class ColorManager {
    private static final double[] gamutFunctionConstants = new double[]{0.20689655172413793, 0.12841854934601665, 0.13793103448275862};

    public static double[] convertLabToXYZ(double[] lab, double[] whitePoint) {
        if (whitePoint == null || lab == null || lab.length != 3 || whitePoint.length != 3) {
            throw new PDFRuntimeException("Invalid Parameter: Either WhitePoint array or color values array is null OR has length not equal to 3.");
        }
        double K = (lab[0] + 16.0) / 116.0;
        double L = K + lab[1] / 500.0;
        double M = K;
        double N = K - lab[2] / 200.0;
        return new double[]{whitePoint[0] * ColorManager.applyGamutFunction(L), whitePoint[1] * ColorManager.applyGamutFunction(M), whitePoint[2] * ColorManager.applyGamutFunction(N)};
    }

    public static double[] convertCalRGBToXYZ(double[] calrgb, double[] matrix, double[] gamma) {
        if (calrgb == null || matrix == null || gamma == null || calrgb.length != 3 || matrix.length != 9 || gamma.length != 3) {
            throw new PDFRuntimeException("Invalid Parameter: Either color values or matrix array or gamma array is null OR has invalid length.");
        }
        double gammaR = Math.pow(calrgb[0], gamma[0]);
        double gammaG = Math.pow(calrgb[1], gamma[1]);
        double gammaB = Math.pow(calrgb[2], gamma[2]);
        return new double[]{matrix[0] * gammaR + matrix[3] * gammaG + matrix[6] * gammaB, matrix[1] * gammaR + matrix[4] * gammaG + matrix[7] * gammaB, matrix[2] * gammaR + matrix[5] * gammaG + matrix[8] * gammaB};
    }

    public static double[] convertCalGrayToXYZ(double gray, double[] whitePoint, double gamma) {
        if (whitePoint == null || whitePoint.length != 3) {
            throw new PDFRuntimeException("Invalid Parameter: Either WhitePoint array is null OR has length not equal to 3.");
        }
        double factor = Math.pow(gray, gamma);
        return new double[]{whitePoint[0] * factor, whitePoint[1] * factor, whitePoint[2] * factor};
    }

    public static double[] convertXYZToDeviceRGB(double[] xyzValues) {
        if (xyzValues == null || xyzValues.length != 3) {
            throw new PDFRuntimeException("Invalid Parameter: Either XYZ array is null OR has length not equal to 3.");
        }
        double r = xyzValues[0] * 3.2406 + xyzValues[1] * -1.5372 + xyzValues[2] * -0.4986;
        double g = xyzValues[0] * -0.9689 + xyzValues[1] * 1.8758 + xyzValues[2] * 0.0415;
        double b = xyzValues[0] * 0.0557 + xyzValues[1] * -0.204 + xyzValues[2] * 1.057;
        r = r > 0.0031308 ? 1.055 * Math.pow(r, 0.41666667) - 0.055 : 12.92 * r;
        g = g > 0.0031308 ? 1.055 * Math.pow(g, 0.41666667) - 0.055 : 12.92 * g;
        b = b > 0.0031308 ? 1.055 * Math.pow(b, 0.41666667) - 0.055 : 12.92 * b;
        return ColorManager.clipToRange(r, g, b);
    }

    public static double convertXYZToDeviceGray(double[] xyzValues) {
        if (xyzValues == null || xyzValues.length != 3) {
            throw new PDFRuntimeException("Invalid Parameter: Either XYZ array is null OR has length not equal to 3.");
        }
        double[] rgb = ColorManager.convertXYZToDeviceRGB(xyzValues);
        return ColorManager.convertDeviceRGBToDeviceGray(rgb);
    }

    public static double convertDeviceRGBToDeviceGray(double[] rgb) {
        if (rgb == null || rgb.length != 3) {
            throw new PDFRuntimeException("Invalid Parameter: Either RGB array is null OR has length not equal to 3.");
        }
        double gray = 0.3 * rgb[0] + 0.59 * rgb[1] + 0.11 * rgb[2];
        return ColorManager.clipToRange(gray, 0.0, 0.0)[0];
    }

    public static double[] convertDeviceGrayToDeviceRGB(double gray) {
        return new double[]{gray, gray, gray};
    }

    public static double[] convertICCToDeviceRGB(double[] icc, ColorSpace iccCS) {
        if (icc == null || iccCS == null) {
            throw new PDFRuntimeException("Invalid Parameter: color values OR ICC color space is null.");
        }
        float[] values = new float[icc.length];
        for (int i = 0; i < icc.length; ++i) {
            values[i] = (float)icc[i];
        }
        values = iccCS.toRGB(values);
        return new double[]{values[0], values[1], values[2]};
    }

    public static Color convertDeviceCMYKtoRGB(double[] colorValues) {
        int VAL = 255;
        if (colorValues.length < 4) {
            return new Color(0);
        }
        int cyan = (int)Math.round(colorValues[0] * 255.0);
        int magenta = (int)Math.round(colorValues[1] * 255.0);
        int yellow = (int)Math.round(colorValues[2] * 255.0);
        int black = (int)Math.round(colorValues[3] * 255.0);
        Color rgb = ColorManager.convertDeviceCMYKtoRGB(cyan, magenta, yellow, black);
        return rgb;
    }

    public static Color convertDeviceCMYKtoRGB(int cyan, int magenta, int yellow, int black) {
        cyan = ColorManager.convert255toDeep(255 - cyan);
        magenta = ColorManager.convert255toDeep(255 - magenta);
        yellow = ColorManager.convert255toDeep(255 - yellow);
        black = ColorManager.convert255toDeep(255 - black);
        Color rgb = DeviceCMYKtoRGBColorConversion.convertDeviceCMYKtoRGB(cyan, magenta, yellow, black);
        return rgb;
    }

    private static int convert255toDeep(int i) {
        return (i << 8) + i + 1 >> 1;
    }

    private static double applyGamutFunction(double x) {
        if (x >= gamutFunctionConstants[0]) {
            return x * x * x;
        }
        return gamutFunctionConstants[1] * (x - gamutFunctionConstants[2]);
    }

    private static double[] clipToRange(double r, double g, double b) {
        return new double[]{r < 0.0 ? 0.0 : Math.min(r, 1.0), g < 0.0 ? 0.0 : Math.min(g, 1.0), b < 0.0 ? 0.0 : Math.min(b, 1.0)};
    }

    public static double[] convertLabToRGB(double[] lab, double[] whitePoint) {
        double[] xyz = ColorManager.convertLabToXYZ(lab, whitePoint);
        double[] rgb = new double[]{1.96271 * xyz[0] + -0.61075 * xyz[1] + -0.34149 * xyz[2], -0.97876 * xyz[0] + 1.91609 * xyz[1] + 0.03349 * xyz[2], 0.02865 * xyz[0] + -0.14074 * xyz[1] + 1.34939 * xyz[2]};
        rgb[0] = rgb[0] < 0.0 ? 0.0 : (rgb[0] > 1.0 ? 1.0 : Math.pow(rgb[0], 0.45454545454545453));
        rgb[1] = rgb[1] < 0.0 ? 0.0 : (rgb[1] > 1.0 ? 1.0 : Math.pow(rgb[1], 0.45454545454545453));
        rgb[2] = rgb[2] < 0.0 ? 0.0 : (rgb[2] > 1.0 ? 1.0 : Math.pow(rgb[2], 0.45454545454545453));
        return rgb;
    }

    public static double[] indexedToRGB(double[] inputColorValues, byte[] lookUpData, int highValue, ToRGBInterface baseCS, double[] range, int numberOfComponents) {
        int index = (int)Math.rint(inputColorValues[0]);
        if (index < 0) {
            index = 0;
        } else if (index > highValue) {
            index = highValue;
        }
        double[] outputColorValues = new double[numberOfComponents];
        double[] maxComponents = range;
        for (int i = 0; i < numberOfComponents; ++i) {
            outputColorValues[i] = lookUpData[index * numberOfComponents + i];
            if (outputColorValues[i] < 0.0) {
                int n = i;
                outputColorValues[n] = outputColorValues[n] + 256.0;
            }
            outputColorValues[i] = GraphicsUtils.scaleToRange(0.0, 255.0, outputColorValues[i], maxComponents[2 * i], maxComponents[2 * i + 1]);
        }
        return baseCS.toRGB(outputColorValues);
    }

    public static double[] calRGBToRGB(double[] calrgb, double[] matrix, double[] gamma) {
        return ColorManager.convertXYZToDeviceRGB(ColorManager.convertCalRGBToXYZ(calrgb, matrix, gamma));
    }

    public static double[] calGrayToRGB(double[] gray, double[] whitePoint, double gamma) {
        double[] xyz = ColorManager.convertCalGrayToXYZ(gray[0], whitePoint, gamma);
        double g = ColorManager.convertXYZToDeviceGray(xyz);
        return ColorManager.convertDeviceGrayToDeviceRGB(g);
    }

    public static double[] colorSpaceWithTintTransformToRGB(double[] inputColorValues, ApplyFunctionInterface function, ToRGBInterface altCS) {
        return altCS.toRGB(function.apply(inputColorValues));
    }
}

