/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.io;

import com.adobe.internal.io.CountingInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RangedInputStream
extends CountingInputStream {
    private final long length;
    private boolean closed;

    public RangedInputStream(InputStream in, long length) {
        super(in);
        this.length = length;
    }

    public int read() throws IOException {
        if (this.closed || this.getOffset() == this.length) {
            return -1;
        }
        return super.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.closed || this.getOffset() == this.length) {
            return -1;
        }
        len = (int)Math.min(this.length - this.getOffset(), (long)len);
        return super.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long skip(long n) throws IOException {
        n = Math.min(this.length - this.getOffset(), n);
        return super.skip(n);
    }

    public void close() throws IOException {
        this.closed = true;
    }
}

