/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.afml;

import com.adobe.internal.afml.AFMLAnomalies;

public class AFMLRectangle {
    public static final double const_AUTO = Double.POSITIVE_INFINITY;
    public static final double const_UNSET = Double.NEGATIVE_INFINITY;
    private static final int const_FORM_XYWH = 1;
    private static final int const_FORM_X1Y1X2Y2 = 2;
    private int pvt_form;
    private double pvt_X1;
    private double pvt_Y1;
    private double pvt_W;
    private double pvt_H;

    private AFMLRectangle(int in_form, double in_X1, double in_Y1, double in_X2, double in_Y2, double in_W, double in_H) {
        this.setForm(in_form);
        switch (in_form) {
            case 1: {
                this.pvt_X1 = in_X1;
                this.pvt_Y1 = in_Y1;
                this.pvt_W = in_W;
                this.pvt_H = in_H;
                break;
            }
            case 2: {
                this.pvt_X1 = in_X1;
                this.pvt_Y1 = in_Y1;
                this.pvt_W = in_X2 - in_X1;
                this.pvt_H = in_Y2 - in_Y1;
                break;
            }
            default: {
                AFMLAnomalies.AFMLErrorStop("AFMLRectangle: Illegal construction of AFMLRectangle");
            }
        }
    }

    public static AFMLRectangle createAFMLRectangleFromXYWH(double in_X, double in_Y, double in_W, double in_H) {
        AFMLRectangle var_Rect = new AFMLRectangle(1, in_X, in_Y, 0.0, 0.0, in_W, in_H);
        return var_Rect;
    }

    public AFMLRectangle copyOf() {
        AFMLRectangle var_New = new AFMLRectangle(this.getForm(), this.getX1(), this.getX2(), this.getY1(), this.getY2(), this.getW(), this.getH());
        return var_New;
    }

    public AFMLRectangle copyAndConvertToPoints(AFMLRectangle in_ParentContentBox) {
        double var_X1 = this.getX1();
        double var_X2 = this.getX2();
        double var_Y1 = this.getY1();
        double var_Y2 = this.getY2();
        double var_W = this.getW();
        double var_H = this.getH();
        AFMLRectangle var_New = new AFMLRectangle(2, var_X1, var_X2, var_Y1, var_Y2, var_W, var_H);
        return var_New;
    }

    public void moveX(double in_AmountToMove) {
        if (this.getX1() == Double.POSITIVE_INFINITY || in_AmountToMove == Double.POSITIVE_INFINITY || this.getX1() == Double.NEGATIVE_INFINITY || in_AmountToMove == Double.NEGATIVE_INFINITY) {
            AFMLAnomalies.AFMLErrorStop("AFMLRectangle.moveX: Mixed fraction-of-parent and point data not allowed");
            return;
        }
        this.pvt_X1 = this.getX1() + in_AmountToMove;
    }

    public void moveY(double in_AmountToMove) {
        if (this.getY1() == Double.POSITIVE_INFINITY || in_AmountToMove == Double.POSITIVE_INFINITY || this.getY1() == Double.NEGATIVE_INFINITY || in_AmountToMove == Double.NEGATIVE_INFINITY) {
            AFMLAnomalies.AFMLErrorStop("AFMLRectangle.moveY: Mixed fraction-of-parent and point data not allowed");
            return;
        }
        this.pvt_Y1 = this.getY1() + in_AmountToMove;
    }

    public void moveXY(double in_X, double in_Y) {
        this.moveX(in_X);
        this.moveY(in_Y);
    }

    public void setToZero() {
        this.pvt_X1 = 0.0;
        this.pvt_Y1 = 0.0;
        this.pvt_W = 0.0;
        this.pvt_H = 0.0;
    }

    public void resizeW(double in_AmountToMove) {
        if (this.getW() == Double.POSITIVE_INFINITY || in_AmountToMove == Double.POSITIVE_INFINITY || this.getW() == Double.NEGATIVE_INFINITY || in_AmountToMove == Double.NEGATIVE_INFINITY) {
            AFMLAnomalies.AFMLErrorStop("AFMLRectangle.resizeW: Invalid inputs to resizeW");
            return;
        }
        this.pvt_W = this.getW() + in_AmountToMove;
    }

    public void resizeH(double in_AmountToMove) {
        if (this.getH() == Double.POSITIVE_INFINITY || in_AmountToMove == Double.POSITIVE_INFINITY || this.getH() == Double.NEGATIVE_INFINITY || in_AmountToMove == Double.NEGATIVE_INFINITY) {
            AFMLAnomalies.AFMLErrorStop("AFMLRectangle.resizeH: Invalid inputs to resizeH");
            return;
        }
        this.pvt_H = this.getH() + in_AmountToMove;
    }

    public void resizeWH(double in_W, double in_H) {
        this.resizeW(in_W);
        this.resizeH(in_H);
    }

    public void setToUnset() {
        this.pvt_X1 = Double.NEGATIVE_INFINITY;
        this.pvt_Y1 = Double.NEGATIVE_INFINITY;
        this.pvt_W = Double.NEGATIVE_INFINITY;
        this.pvt_H = Double.NEGATIVE_INFINITY;
    }

    public double getX1() {
        return this.pvt_X1;
    }

    public double getX2() {
        return this.pvt_X1 + this.pvt_W;
    }

    public double getY1() {
        return this.pvt_Y1;
    }

    public double getY2() {
        return this.pvt_Y1 + this.pvt_H;
    }

    public void setX1(double d) {
        this.pvt_X1 = d;
    }

    public void setY1(double d) {
        this.pvt_Y1 = d;
    }

    public int getForm() {
        return this.pvt_form;
    }

    public double getH() {
        return this.pvt_H;
    }

    public double getW() {
        return this.pvt_W;
    }

    protected void setForm(int i) {
        this.pvt_form = i;
    }

    public void setH(double d) {
        this.pvt_H = d;
    }

    public void setW(double d) {
        this.pvt_W = d;
    }
}

