/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.inlineformatting;

public final class LigatureLevel {
    private final String name;
    private final int rank;
    public static final LigatureLevel NONE = new LigatureLevel("NONE", 0);
    public static final LigatureLevel MINIMUM = new LigatureLevel("MINIMUM", 1);
    public static final LigatureLevel COMMON = new LigatureLevel("COMMON", 2);
    public static final LigatureLevel UNCOMMON = new LigatureLevel("UNCOMMON", 3);
    public static final LigatureLevel EXOTIC = new LigatureLevel("EXOTIC", 4);
    private static final LigatureLevel[] allValues = new LigatureLevel[]{NONE, MINIMUM, COMMON, UNCOMMON, EXOTIC};

    private LigatureLevel(String name, int rank) {
        this.name = name;
        this.rank = rank;
    }

    public String toString() {
        return this.name;
    }

    public static boolean lessThanOrEqual(LigatureLevel l1, LigatureLevel l2) {
        if (l1 == null) {
            l1 = COMMON;
        }
        if (l2 == null) {
            l2 = COMMON;
        }
        return l1.rank <= l2.rank;
    }

    public static LigatureLevel parse(String s) {
        for (int i = 0; i < allValues.length; ++i) {
            if (LigatureLevel.allValues[i].name.compareToIgnoreCase(s) != 0) continue;
            return allValues[i];
        }
        return null;
    }
}

