/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

public final class UnderlineMetrics {
    public final double position;
    public final double thickness;

    public UnderlineMetrics(double position, double thickness) {
        this.position = position;
        this.thickness = thickness;
    }

    public UnderlineMetrics toEmSpace(double unitsPerEmX, double unitsPerEmY) {
        return new UnderlineMetrics(this.position / unitsPerEmY, this.thickness / unitsPerEmY);
    }

    public UnderlineMetrics toDesignSpace(double unitsPerEmX, double unitsPerEmY) {
        return new UnderlineMetrics(this.position * unitsPerEmY, this.thickness * unitsPerEmY);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnderlineMetrics)) {
            return false;
        }
        UnderlineMetrics vm = (UnderlineMetrics)o;
        return vm.position == this.position && vm.thickness == this.thickness;
    }

    public int hashCode() {
        return (int)this.position ^ (int)this.thickness;
    }

    public String toString() {
        return "[p=" + this.position + " t=" + this.thickness + "]";
    }
}

