/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.Point;

public final class Matrix {
    public static final Matrix IDENTITY_MATRIX = new Matrix(1.0, 0.0, 0.0, 1.0, 0.0, 0.0);
    public final double a;
    public final double b;
    public final double c;
    public final double d;
    public final double tx;
    public final double ty;

    public Matrix(double[] matrix) {
        this.a = matrix[0];
        this.b = matrix[1];
        this.c = matrix[2];
        this.d = matrix[3];
        this.tx = matrix.length > 4 ? matrix[4] : 0.0;
        this.ty = matrix.length > 5 ? matrix[5] : 0.0;
    }

    public Matrix(double a, double b, double c, double d, double tx, double ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public boolean isIdentity() {
        return Math.abs(this.a - 1.0) < 0.001 && Math.abs(this.d - 1.0) < 0.001 && Math.abs(this.b) < 0.001 && Math.abs(this.c) < 0.001 && Math.abs(this.tx) < 0.001 && Math.abs(this.ty) < 0.001;
    }

    public boolean isInverse(Matrix inverse) {
        Matrix res = this.multiply(inverse);
        return res.isIdentity();
    }

    public Matrix multiply(Matrix multiplier) {
        double aRes = this.a * multiplier.a + this.b * multiplier.c;
        double bRes = this.a * multiplier.b + this.b * multiplier.d;
        double cRes = this.c * multiplier.a + this.d * multiplier.c;
        double dRes = this.c * multiplier.b + this.d * multiplier.d;
        double txRes = this.tx * multiplier.a + this.ty * multiplier.c + multiplier.tx;
        double tyRes = this.tx * multiplier.b + this.ty * multiplier.d + multiplier.ty;
        return new Matrix(aRes, bRes, cRes, dRes, txRes, tyRes);
    }

    public Matrix multiply(double multiplier) {
        return new Matrix(this.a * multiplier, this.b * multiplier, this.c * multiplier, this.d * multiplier, this.tx * multiplier, this.ty * multiplier);
    }

    public void applyToPoint(Point p) {
        if (this.equals(IDENTITY_MATRIX)) {
            return;
        }
        double origX = p.x;
        double origY = p.y;
        p.x = origX * this.a + origY * this.c + this.tx;
        p.y = origX * this.b + origY * this.d + this.ty;
    }

    public double applyToXYGetX(double x, double y) {
        return x * this.a + y * this.c + this.tx;
    }

    public double applyToXYGetY(double x, double y) {
        return x * this.b + y * this.d + this.ty;
    }
}

