/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine.font;

import com.adobe.fontengine.font.InvalidFontException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class FontInputStream {
    private static final long UNKNOWN_LIMIT = -1L;
    private MessageDigest digest;
    private PushbackInputStream pbis;
    private long curOffset = 0L;
    private static int constructions;
    private long offsetLimit;

    public FontInputStream(FontInputStream in) {
        this.pbis = in.pbis;
        this.curOffset = in.curOffset;
        this.digest = in.digest;
        this.offsetLimit = in.offsetLimit;
    }

    public FontInputStream(InputStream in) {
        this(in, -1L);
    }

    public FontInputStream(URL url) throws IOException {
        long size = -1L;
        try {
            File file;
            if (url.getProtocol().equalsIgnoreCase("file") && (file = new File(url.toURI())).exists()) {
                size = file.length();
            }
        }
        catch (URISyntaxException e) {
            size = -1L;
        }
        this.init(url.openStream(), size);
    }

    public FontInputStream(InputStream in, long size) {
        this.init(in, size);
    }

    private void init(InputStream in, long size) {
        MessageDigest d;
        InputStream dis = null;
        try {
            d = MessageDigest.getInstance("SHA");
            dis = new DigestInputStream(in, d);
        }
        catch (NoSuchAlgorithmException e) {
            d = null;
            dis = in;
        }
        this.digest = d;
        this.pbis = new PushbackInputStream(dis, 400);
        this.offsetLimit = size;
        ++constructions;
    }

    public static int numFis() {
        return constructions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this.pbis.close();
        }
        finally {
            this.pbis = null;
            this.digest = null;
        }
    }

    public boolean isValidOffset(long offset, long length) {
        return this.isValidOffset(offset + length - 1L);
    }

    public boolean isValidOffset(long offset) {
        if (offset < 0L) {
            return false;
        }
        if (-1L == this.offsetLimit) {
            return true;
        }
        return offset < this.offsetLimit;
    }

    private long clampOffset(long offset, long length) {
        return offset + length - this.offsetLimit;
    }

    public long getCurrentOffset() {
        return this.curOffset;
    }

    public long skipTo(long offset) throws IOException, InvalidFontException {
        if (this.curOffset > offset) {
            throw new InvalidFontException("trying to read the same byte twice (read up to " + Long.toHexString(this.curOffset) + ", want to go back to " + Long.toHexString(offset) + ")");
        }
        long initialOffset = this.curOffset;
        while (this.curOffset < offset) {
            long bytesSkipped = this.pbis.skip(offset - this.curOffset);
            this.curOffset += bytesSkipped;
        }
        return this.curOffset - initialOffset;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        long length = len;
        if (!this.isValidOffset(this.curOffset, length) && (length = this.clampOffset(this.curOffset, length)) == 0L) {
            return -1;
        }
        int n = this.pbis.read(b, off, (int)length);
        if (n > 0) {
            this.curOffset += (long)n;
        }
        return n;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read() throws IOException {
        long length = 1L;
        if (!this.isValidOffset(this.curOffset, length) && (length = this.clampOffset(this.curOffset, length)) == 0L) {
            return -1;
        }
        int retVal = this.pbis.read();
        if (retVal != -1) {
            ++this.curOffset;
        }
        return retVal;
    }

    public void unread(int b) throws IOException {
        this.pbis.unread(b);
        --this.curOffset;
    }

    public void unread(byte[] b, int off, int len) throws IOException {
        this.pbis.unread(b, off, len);
        this.curOffset -= (long)len;
    }

    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    public byte[] getDigest() throws IOException {
        if (this.digest == null) {
            return new byte[0];
        }
        byte[] b = new byte[1024];
        int n = 0;
        while (n != -1) {
            n = this.pbis.read(b);
        }
        return this.digest.digest();
    }
}

