/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.fontengine;

import com.adobe.agl.lang.UCharacter;
import com.adobe.fontengine.CombiningSequence;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public final class CharUtil {
    private static final CombiningSequence emptySequence;

    public static int compose(int[] usvs, int start, int limit) {
        return emptySequence.compose(usvs, start, limit);
    }

    public static int[] mapStringFrom(int[] usvs, int start, int limit) {
        int c = CharUtil.composeHangulSyllable(usvs, start, limit);
        if (c != -1) {
            return new int[]{c};
        }
        return emptySequence.map(usvs, start, limit);
    }

    public static int composeHangulSyllable(int[] usvs, int start, int limit) {
        if (start + 2 <= limit && 4352 <= usvs[start] && usvs[start] <= 4371 && 4449 <= usvs[start + 1] && usvs[start + 1] <= 4470 && (limit == start + 3 && 4519 <= usvs[start + 2] && usvs[start + 2] <= 4547 || limit == start + 2)) {
            int s = ((usvs[start] - 4352) * 21 + (usvs[start + 1] - 4449)) * 28 + 44032;
            if (limit == start + 3) {
                s += usvs[start + 2] - 4519;
            }
            return s;
        }
        return -1;
    }

    public static boolean isBase(int ch) {
        return UCharacter.isBaseForm(ch);
    }

    public static boolean isCombining(int ch) {
        int gc = UCharacter.getType(ch);
        return gc == 8 || gc == 6 || gc == 7;
    }

    public static boolean isControl(int ch) {
        int gc = UCharacter.getType(ch);
        return gc == 16 || gc == 15;
    }

    static {
        try {
            InputStream is = CombiningSequence.class.getResourceAsStream("composer");
            ObjectInputStream ois = new ObjectInputStream(is);
            emptySequence = (CombiningSequence)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            throw new RuntimeException("cannot load AFE Composer resources", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("cannot load AFE Composer resources", e);
        }
    }
}

