/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.search;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.service.ServiceObjectType;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceValidationException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceVersionException;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.ServiceRequestBase;
import microsoft.exchange.webservices.data.search.Grouping;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ViewBase {
    private PropertySet propertySet;

    ViewBase() {
    }

    public void internalValidate(ServiceRequestBase request) throws ServiceValidationException, ServiceVersionException {
        if (this.getPropertySet() != null) {
            this.getPropertySet().internalValidate();
            this.getPropertySet().validateForRequest(request, true);
        }
    }

    protected void internalWriteViewToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, Exception {
        Integer maxEntriesReturned = this.getMaxEntriesReturned();
        if (maxEntriesReturned != null) {
            writer.writeAttributeValue("MaxEntriesReturned", maxEntriesReturned);
        }
    }

    protected abstract void internalWriteSearchSettingsToXml(EwsServiceXmlWriter var1, Grouping var2) throws XMLStreamException, ServiceXmlSerializationException;

    public abstract void writeOrderByToXml(EwsServiceXmlWriter var1) throws XMLStreamException, ServiceXmlSerializationException;

    protected abstract String getViewXmlElementName();

    protected abstract Integer getMaxEntriesReturned();

    protected abstract ServiceObjectType getServiceObjectType();

    public abstract void writeAttributesToXml(EwsServiceXmlWriter var1) throws ServiceXmlSerializationException;

    public void writeToXml(EwsServiceXmlWriter writer, Grouping groupBy) throws Exception {
        this.getPropertySetOrDefault().writeToXml(writer, this.getServiceObjectType());
        writer.writeStartElement(XmlNamespace.Messages, this.getViewXmlElementName());
        this.internalWriteViewToXml(writer);
        writer.writeEndElement();
        this.internalWriteSearchSettingsToXml(writer, groupBy);
    }

    public PropertySet getPropertySetOrDefault() {
        if (this.getPropertySet() == null) {
            return PropertySet.getFirstClassProperties();
        }
        return this.getPropertySet();
    }

    public PropertySet getPropertySet() {
        return this.propertySet;
    }

    public void setPropertySet(PropertySet propertySet) {
        this.propertySet = propertySet;
    }
}

