/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex.availability;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.enumeration.property.ConflictType;
import microsoft.exchange.webservices.data.core.enumeration.property.LegacyFreeBusyStatus;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;

public final class Conflict
extends ComplexProperty {
    private ConflictType conflictType;
    private int numberOfMembers;
    private int numberOfMembersAvailable;
    private int numberOfMembersWithConflict;
    private int numberOfMembersWithNoData;
    private LegacyFreeBusyStatus freeBusyStatus;

    protected Conflict(ConflictType conflictType) {
        this.conflictType = conflictType;
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("NumberOfMembers")) {
            this.numberOfMembers = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("NumberOfMembersAvailable")) {
            this.numberOfMembersAvailable = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("NumberOfMembersWithConflict")) {
            this.numberOfMembersWithConflict = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("NumberOfMembersWithNoData")) {
            this.numberOfMembersWithNoData = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("BusyType")) {
            this.freeBusyStatus = reader.readElementValue(LegacyFreeBusyStatus.class);
            return true;
        }
        return false;
    }

    public ConflictType getConflictType() {
        return this.conflictType;
    }

    public int getNumberOfMembers() {
        return this.numberOfMembers;
    }

    public int getNumberOfMembersAvailable() {
        return this.numberOfMembersAvailable;
    }

    public int getNumberOfMembersWithConflict() {
        return this.numberOfMembersWithConflict;
    }

    public int getNumberOfMembersWithNoData() {
        return this.numberOfMembersWithNoData;
    }

    public LegacyFreeBusyStatus getFreeBusyStatus() {
        return this.freeBusyStatus;
    }
}

