/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import org.apache.commons.lang3.StringUtils;

public abstract class ServiceId
extends ComplexProperty {
    private String changeKey;
    private String uniqueId;

    public ServiceId() {
    }

    public ServiceId(String uniqueId) throws Exception {
        this();
        EwsUtilities.validateParam(uniqueId, "uniqueId");
        this.uniqueId = uniqueId;
    }

    @Override
    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.uniqueId = reader.readAttributeValue("Id");
        this.changeKey = reader.readAttributeValue("ChangeKey");
    }

    @Override
    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Id", this.getUniqueId());
        writer.writeAttributeValue("ChangeKey", this.getChangeKey());
    }

    public abstract String getXmlElementName();

    public void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, this.getXmlElementName());
    }

    public void assign(ServiceId source) {
        this.uniqueId = source.getUniqueId();
        this.changeKey = source.getChangeKey();
    }

    public boolean isValid() {
        return null != this.uniqueId && !this.uniqueId.isEmpty();
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getChangeKey() {
        return this.changeKey;
    }

    public void setChangeKey(String changeKey) {
        this.changeKey = changeKey;
    }

    public boolean sameIdAndChangeKey(ServiceId other) {
        return this.equals(other) && StringUtils.equals((CharSequence)this.getChangeKey(), (CharSequence)other.getChangeKey());
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (!(obj instanceof ServiceId)) {
            return false;
        }
        ServiceId other = (ServiceId)obj;
        if (!this.isValid() || !other.isValid()) {
            return false;
        }
        return this.getUniqueId().equals(other.getUniqueId());
    }

    public int hashCode() {
        return this.isValid() ? this.getUniqueId().hashCode() : super.hashCode();
    }

    public String toString() {
        return this.uniqueId == null ? "" : this.uniqueId;
    }
}

