/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.attribute.EditorBrowsable;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.attribute.EditorBrowsableState;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.property.complex.ComplexFunctionDelegate;
import microsoft.exchange.webservices.data.property.complex.IComplexPropertyChangedDelegate;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class ComplexProperty
implements ISelfValidate,
ComplexFunctionDelegate<EwsServiceXmlReader> {
    private XmlNamespace xmlNamespace = XmlNamespace.Types;
    private List<IComplexPropertyChangedDelegate> onChangeList = new ArrayList<IComplexPropertyChangedDelegate>();

    protected ComplexProperty() {
    }

    public XmlNamespace getNamespace() {
        return this.xmlNamespace;
    }

    public void setNamespace(XmlNamespace xmlNamespace) {
        this.xmlNamespace = xmlNamespace;
    }

    public void changed() {
        if (!this.onChangeList.isEmpty()) {
            for (IComplexPropertyChangedDelegate change : this.onChangeList) {
                change.complexPropertyChanged(this);
            }
        }
    }

    public <T> boolean canSetFieldValue(T field, T value) {
        boolean applyChange;
        if (field == null) {
            applyChange = value != null;
        } else if (field instanceof Comparable) {
            Comparable c = (Comparable)field;
            applyChange = value != null && c.compareTo(value) != 0;
        } else {
            applyChange = true;
        }
        return applyChange;
    }

    public void clearChangeLog() {
    }

    public void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
    }

    public void readTextValueFromXml(EwsServiceXmlReader reader) throws Exception {
    }

    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        return false;
    }

    public boolean tryReadElementFromXmlToPatch(EwsServiceXmlReader reader) throws Exception {
        return false;
    }

    public void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
    }

    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
    }

    public void loadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        this.internalLoadFromXml(reader, xmlNamespace, xmlElementName);
    }

    public void updateFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        this.updateFromXml(reader, this.getNamespace(), xmlElementName);
    }

    public void updateFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        this.internalupdateLoadFromXml(reader, xmlNamespace, xmlElementName);
    }

    private void internalLoadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        this.readAttributesFromXml(reader);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                switch (reader.getNodeType().nodeType) {
                    case 1: {
                        if (this.tryReadElementFromXml(reader)) break;
                        reader.skipCurrentElement();
                        break;
                    }
                    case 4: {
                        this.readTextValueFromXml(reader);
                    }
                }
            } while (!reader.isEndElement(xmlNamespace, xmlElementName));
        } else {
            reader.read();
            reader.isEndElement(xmlNamespace, xmlElementName);
        }
    }

    private void internalupdateLoadFromXml(EwsServiceXmlReader reader, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(xmlNamespace, xmlElementName);
        this.readAttributesFromXml(reader);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                switch (reader.getNodeType().nodeType) {
                    case 1: {
                        if (this.tryReadElementFromXmlToPatch(reader)) break;
                        reader.skipCurrentElement();
                        break;
                    }
                    case 4: {
                        this.readTextValueFromXml(reader);
                    }
                }
            } while (!reader.isEndElement(xmlNamespace, xmlElementName));
        }
    }

    public void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        this.loadFromXml(reader, this.getNamespace(), xmlElementName);
    }

    public void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        writer.writeStartElement(xmlNamespace, xmlElementName);
        this.writeAttributesToXml(writer);
        this.writeElementsToXml(writer);
        writer.writeEndElement();
    }

    public void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws Exception {
        this.writeToXml(writer, this.getNamespace(), xmlElementName);
    }

    public void addOnChangeEvent(IComplexPropertyChangedDelegate change) {
        this.onChangeList.add(change);
    }

    public void removeChangeEvent(IComplexPropertyChangedDelegate change) {
        this.onChangeList.remove(change);
    }

    protected void clearChangeEvents() {
        this.onChangeList.clear();
    }

    @Override
    public void validate() throws Exception {
        this.internalValidate();
    }

    protected void internalValidate() throws Exception {
    }

    @Override
    public Boolean func(EwsServiceXmlReader reader) throws Exception {
        return !this.tryReadElementFromXml(reader);
    }
}

