/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.property.complex;

import java.util.Date;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.enumeration.property.MeetingResponseType;
import microsoft.exchange.webservices.data.property.complex.EmailAddress;

public final class Attendee
extends EmailAddress {
    private MeetingResponseType responseType;
    private Date lastResponseTime;

    public Attendee() {
    }

    public Attendee(String smtpAddress) throws Exception {
        super(smtpAddress);
        EwsUtilities.validateParam(smtpAddress, "smtpAddress");
    }

    public Attendee(String name, String smtpAddress) {
        super(name, smtpAddress);
    }

    public Attendee(String name, String smtpAddress, String routingType) {
        super(name, smtpAddress, routingType);
    }

    public Attendee(EmailAddress mailbox) throws Exception {
        super(mailbox);
    }

    public MeetingResponseType getResponseType() {
        return this.responseType;
    }

    public Date getLastResponseTime() {
        return this.lastResponseTime;
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("Mailbox")) {
            this.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("ResponseType")) {
            this.responseType = reader.readElementValue(MeetingResponseType.class);
            return true;
        }
        if (reader.getLocalName().equalsIgnoreCase("LastResponseTime")) {
            this.lastResponseTime = reader.readElementValueAsDateTime();
            return true;
        }
        return super.tryReadElementFromXml(reader);
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(this.getNamespace(), "Mailbox");
        super.writeElementsToXml(writer);
        writer.writeEndElement();
    }
}

