/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.misc.availability;

import java.util.UUID;
import microsoft.exchange.webservices.data.core.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.property.time.DayOfTheWeek;
import microsoft.exchange.webservices.data.misc.TimeSpan;
import microsoft.exchange.webservices.data.misc.availability.LegacyAvailabilityTimeZoneTime;
import microsoft.exchange.webservices.data.property.complex.ComplexProperty;
import microsoft.exchange.webservices.data.property.complex.time.TimeZoneDefinition;

public final class LegacyAvailabilityTimeZone
extends ComplexProperty {
    private TimeSpan bias = new TimeSpan(0L);
    private LegacyAvailabilityTimeZoneTime standardTime;
    private LegacyAvailabilityTimeZoneTime daylightTime = new LegacyAvailabilityTimeZoneTime();

    public LegacyAvailabilityTimeZone() {
        this.daylightTime.setDelta(new TimeSpan(0L));
        this.daylightTime.setDayOrder(1);
        this.daylightTime.setDayOfTheWeek(DayOfTheWeek.Sunday);
        this.daylightTime.setMonth(10);
        this.daylightTime.setTimeOfDay(new TimeSpan(0x6DDD00L));
        this.daylightTime.setYear(0);
        this.standardTime = new LegacyAvailabilityTimeZoneTime();
        this.standardTime.setDelta(new TimeSpan(0L));
        this.standardTime.setDayOrder(1);
        this.standardTime.setDayOfTheWeek(DayOfTheWeek.Sunday);
        this.standardTime.setMonth(3);
        this.standardTime.setTimeOfDay(new TimeSpan(0x6DDD00L));
        this.daylightTime.setYear(0);
    }

    public TimeZoneDefinition toTimeZoneInfo() {
        TimeZoneDefinition timeZoneDefinition = new TimeZoneDefinition();
        timeZoneDefinition.id = UUID.randomUUID().toString();
        timeZoneDefinition.name = "Custom time zone";
        return timeZoneDefinition;
    }

    @Override
    public boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("Bias")) {
            this.bias = new TimeSpan((long)reader.readElementValue(Integer.class).intValue() * 60L * 1000L);
            return true;
        }
        if (reader.getLocalName().equals("StandardTime")) {
            this.standardTime = new LegacyAvailabilityTimeZoneTime();
            this.standardTime.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("DaylightTime")) {
            this.daylightTime = new LegacyAvailabilityTimeZoneTime();
            this.daylightTime.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        return false;
    }

    @Override
    public void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeElementValue(XmlNamespace.Types, "Bias", (int)this.bias.getTotalMinutes());
        this.standardTime.writeToXml(writer, "StandardTime");
        this.daylightTime.writeToXml(writer, "DaylightTime");
    }
}

