/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.credential;

import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.core.exception.misc.InvalidOperationException;
import microsoft.exchange.webservices.data.core.request.HttpWebRequest;
import microsoft.exchange.webservices.data.credential.WebCredentials;

public abstract class ExchangeCredentials {
    public static ExchangeCredentials getExchangeCredentialsFromNetworkCredential(String userName, String password, String domain) {
        return new WebCredentials(userName, password, domain);
    }

    protected static String getUriWithoutWSSecurity(URI url) {
        String absoluteUri = url.toString();
        int index = absoluteUri.indexOf("/wssecurity");
        if (index == -1) {
            return absoluteUri;
        }
        return absoluteUri.substring(0, index);
    }

    public void preAuthenticate() {
    }

    public void prepareWebRequest(HttpWebRequest client) throws URISyntaxException {
    }

    public void emitExtraSoapHeaderNamespaceAliases(XMLStreamWriter writer) throws XMLStreamException {
    }

    public void serializeExtraSoapHeaders(XMLStreamWriter writer, String webMethodName) throws XMLStreamException {
    }

    public URI adjustUrl(URI url) throws URISyntaxException {
        return new URI(ExchangeCredentials.getUriWithoutWSSecurity(url));
    }

    public boolean isNeedSignature() {
        return false;
    }

    public void sign(ByteArrayOutputStream memoryStream) throws Exception {
        throw new InvalidOperationException();
    }

    public void serializeWSSecurityHeaders(XMLStreamWriter writer) throws XMLStreamException {
    }
}

