/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.exception.misc.ArgumentException;
import microsoft.exchange.webservices.data.core.request.SubscribeRequest;
import microsoft.exchange.webservices.data.core.response.SubscribeResponse;
import microsoft.exchange.webservices.data.notification.StreamingSubscription;

public class SubscribeToStreamingNotificationsRequest
extends SubscribeRequest<StreamingSubscription> {
    public SubscribeToStreamingNotificationsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        if (this.getWatermark() != null && !this.getWatermark().isEmpty()) {
            throw new ArgumentException("Watermarks cannot be used with StreamingSubscriptions.");
        }
    }

    @Override
    protected String getSubscriptionXmlElementName() {
        return "StreamingSubscriptionRequest";
    }

    @Override
    protected void internalWriteElementsToXml(EwsServiceXmlWriter writer) {
    }

    @Override
    protected SubscribeResponse<StreamingSubscription> createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        return new SubscribeResponse<StreamingSubscription>(new StreamingSubscription(service));
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }
}

