/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data.core.request;

import java.util.HashMap;
import java.util.Map;
import microsoft.exchange.webservices.data.core.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.core.EwsUtilities;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.ILazyMember;
import microsoft.exchange.webservices.data.core.LazyMember;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.misc.XmlNamespace;
import microsoft.exchange.webservices.data.core.enumeration.search.ResolveNameSearchLocation;
import microsoft.exchange.webservices.data.core.enumeration.service.error.ServiceErrorHandling;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.core.request.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.core.response.ResolveNamesResponse;
import microsoft.exchange.webservices.data.misc.FolderIdWrapperList;

public final class ResolveNamesRequest
extends MultiResponseServiceRequest<ResolveNamesResponse> {
    private static LazyMember<Map<ResolveNameSearchLocation, String>> searchScopeMap = new LazyMember<Map<ResolveNameSearchLocation, String>>(new ILazyMember<Map<ResolveNameSearchLocation, String>>(){

        @Override
        public Map<ResolveNameSearchLocation, String> createInstance() {
            HashMap<ResolveNameSearchLocation, String> map = new HashMap<ResolveNameSearchLocation, String>();
            map.put(ResolveNameSearchLocation.DirectoryOnly, "ActiveDirectory");
            map.put(ResolveNameSearchLocation.DirectoryThenContacts, "ActiveDirectoryContacts");
            map.put(ResolveNameSearchLocation.ContactsOnly, "Contacts");
            map.put(ResolveNameSearchLocation.ContactsThenDirectory, "ContactsActiveDirectory");
            return map;
        }
    });
    private String nameToResolve;
    private boolean returnFullContactData;
    private ResolveNameSearchLocation searchLocation;
    private PropertySet contactDataPropertySet;
    private FolderIdWrapperList parentFolderIds = new FolderIdWrapperList();

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateNonBlankStringParam(this.getNameToResolve(), "NameToResolve");
    }

    @Override
    protected ResolveNamesResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ResolveNamesResponse(service);
    }

    @Override
    public String getXmlElementName() {
        return "ResolveNames";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ResolveNamesResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ResolveNamesResponseMessage";
    }

    public ResolveNamesRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("ReturnFullContactData", this.returnFullContactData);
        String searchScope = null;
        if (searchScopeMap.getMember().containsKey((Object)this.searchLocation)) {
            searchScope = searchScopeMap.getMember().get((Object)this.searchLocation);
        }
        EwsUtilities.ewsAssert(searchScope != null && !searchScope.isEmpty(), "ResolveNameRequest.WriteAttributesToXml", "The specified search location cannot be mapped to an EWS search scope.");
        String propertySet = null;
        if (this.getContactDataPropertySet() != null && PropertySet.getDefaultPropertySetMap().getMember().containsKey((Object)this.getContactDataPropertySet().getBasePropertySet())) {
            propertySet = PropertySet.getDefaultPropertySetMap().getMember().get((Object)this.getContactDataPropertySet().getBasePropertySet());
        }
        if (!this.getService().getExchange2007CompatibilityMode()) {
            writer.writeAttributeValue("SearchScope", searchScope);
        }
        if (propertySet != null) {
            writer.writeAttributeValue("ContactDataShape", propertySet);
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getParentFolderIds().writeToXml(writer, XmlNamespace.Messages, "ParentFolderIds");
        writer.writeElementValue(XmlNamespace.Messages, "UnresolvedEntry", this.getNameToResolve());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public String getNameToResolve() {
        return this.nameToResolve;
    }

    public void setNameToResolve(String nameToResolve) {
        this.nameToResolve = nameToResolve;
    }

    public boolean getReturnFullContactData() {
        return this.returnFullContactData;
    }

    public void setReturnFullContactData(boolean returnFullContactData) {
        this.returnFullContactData = returnFullContactData;
    }

    public ResolveNameSearchLocation getSearchLocation() {
        return this.searchLocation;
    }

    public void setSearchLocation(ResolveNameSearchLocation searchLocation) {
        this.searchLocation = searchLocation;
    }

    public FolderIdWrapperList getParentFolderIds() {
        return this.parentFolderIds;
    }

    public void setContactDataPropertySet(PropertySet propertySet) {
        this.contactDataPropertySet = propertySet;
    }

    public PropertySet getContactDataPropertySet() {
        return this.contactDataPropertySet;
    }
}

