/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRAbstractObjectFactory;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.base.JRBaseBox;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRCloneable;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillElementContainer;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateFrame;
import net.sf.jasperreports.engine.fill.JRTemplatePrintFrame;
import net.sf.jasperreports.engine.util.JRStyleResolver;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class JRFillFrame
extends JRFillElement
implements JRFrame {
    protected final JRFrame parentFrame;
    private JRFillFrameElements frameContainer;
    private Map bottomTemplateFrames;
    private Map topTemplateFrames;
    private Map topBottomTemplateFrames;
    private boolean first;
    private boolean fillBottomBorder;
    private boolean filling;

    public JRFillFrame(JRBaseFiller filler, JRFrame frame, JRFillObjectFactory factory) {
        super(filler, frame, factory);
        this.parentFrame = frame;
        this.frameContainer = new JRFillFrameElements(factory);
        this.bottomTemplateFrames = new HashMap();
        this.topTemplateFrames = new HashMap();
        this.topBottomTemplateFrames = new HashMap();
        this.setShrinkable(true);
    }

    protected JRFillFrame(JRFillFrame frame, JRFillCloneFactory factory) {
        super(frame, factory);
        this.parentFrame = frame.parentFrame;
        this.frameContainer = new JRFillFrameElements(frame.frameContainer, factory);
        this.bottomTemplateFrames = frame.bottomTemplateFrames;
        this.topTemplateFrames = frame.topTemplateFrames;
        this.topBottomTemplateFrames = frame.topBottomTemplateFrames;
    }

    @Override
    public byte getMode() {
        return JRStyleResolver.getMode(this, (byte)2);
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.frameContainer.evaluate(evaluation);
            boolean repeating = true;
            JRFillElement[] elements = (JRFillElement[])this.getElements();
            for (int i = 0; repeating && i < elements.length; repeating &= elements[i].isValueRepeating(), ++i) {
            }
            this.setValueRepeating(repeating);
        }
        this.filling = false;
    }

    @Override
    protected void rewind() throws JRException {
        this.frameContainer.rewind();
        this.filling = false;
    }

    @Override
    protected boolean prepare(int availableStretchHeight, boolean isOverflow) throws JRException {
        super.prepare(availableStretchHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        this.first = !isOverflow || !this.filling;
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.getBottomPadding();
        if (availableStretchHeight < this.getRelativeY() - this.getY() - this.getBandBottomY() - topPadding) {
            this.setToPrint(false);
            return true;
        }
        if (!(this.filling || this.isPrintRepeatedValues() || !this.isValueRepeating() || this.isPrintInFirstWholeBand() && this.getBand().isFirstWholeOnPageColumn() || this.getPrintWhenGroupChanges() != null && this.getBand().isNewGroup(this.getPrintWhenGroupChanges()) || isOverflow && this.isPrintWhenDetailOverflows())) {
            this.setToPrint(false);
            return false;
        }
        if (!this.filling && isOverflow && this.isAlreadyPrinted()) {
            if (this.isPrintWhenDetailOverflows()) {
                this.rewind();
                this.setReprinted(true);
            } else {
                this.setToPrint(false);
                return false;
            }
        }
        int stretchHeight = availableStretchHeight - this.getRelativeY() + this.getY() + this.getBandBottomY();
        this.frameContainer.initFill();
        this.frameContainer.resetElements();
        this.frameContainer.prepareElements(stretchHeight + bottomPadding, true);
        boolean willOverflow = this.frameContainer.willOverflow();
        if (willOverflow) {
            this.setStretchHeight(this.getHeight() + stretchHeight);
            this.fillBottomBorder = false;
        } else {
            int neededStretch = this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding;
            if (neededStretch <= this.getHeight() + stretchHeight) {
                this.setStretchHeight(neededStretch);
                this.fillBottomBorder = true;
            } else {
                this.setStretchHeight(this.getHeight() + stretchHeight);
                this.fillBottomBorder = false;
            }
        }
        this.filling = willOverflow;
        return willOverflow;
    }

    @Override
    protected void setStretchHeight(int stretchHeight) {
        super.setStretchHeight(stretchHeight);
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.getBottomPadding();
        this.frameContainer.setStretchHeight(stretchHeight + this.frameContainer.getFirstY() - topPadding - bottomPadding);
    }

    @Override
    protected void stretchHeightFinal() {
        this.frameContainer.stretchElements();
        this.frameContainer.moveBandBottomElements();
        this.frameContainer.removeBlankElements();
        int topPadding = this.first ? this.getTopPadding() : 0;
        int bottomPadding = this.getBottomPadding();
        super.setStretchHeight(this.frameContainer.getStretchHeight() - this.frameContainer.getFirstY() + topPadding + bottomPadding);
    }

    @Override
    protected JRPrintElement fill() throws JRException {
        JRTemplatePrintFrame printFrame = new JRTemplatePrintFrame(this.getTemplate());
        printFrame.setX(this.getX());
        printFrame.setY(this.getRelativeY());
        printFrame.setWidth(this.getWidth());
        this.frameContainer.fillElements(printFrame);
        printFrame.setHeight(this.getStretchHeight());
        return printFrame;
    }

    protected JRTemplateFrame getTemplate() {
        JRStyle style = this.getStyle();
        Map templatesMap = this.first ? (this.fillBottomBorder ? this.templates : this.bottomTemplateFrames) : (this.fillBottomBorder ? this.topTemplateFrames : this.topBottomTemplateFrames);
        JRTemplateFrame boxTemplate = (JRTemplateFrame)templatesMap.get(style);
        if (boxTemplate == null) {
            boxTemplate = new JRTemplateFrame(this.filler.getJasperPrint().getDefaultStyleProvider(), this);
            if (this.first) {
                if (!this.fillBottomBorder) {
                    JRBaseBox bottomBox = new JRBaseBox(this, false, false, false, true);
                    boxTemplate.setBox(bottomBox);
                }
            } else if (this.fillBottomBorder) {
                JRBaseBox topBox = new JRBaseBox(this, false, false, true, false);
                boxTemplate.setBox(topBox);
            } else {
                JRBaseBox topBottomBox = new JRBaseBox(this, false, false, true, true);
                boxTemplate.setBox(topBottomBox);
            }
            templatesMap.put(style, boxTemplate);
        }
        return boxTemplate;
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public JRElement[] getElements() {
        return this.frameContainer.getElements();
    }

    @Override
    public List getChildren() {
        return this.frameContainer.getChildren();
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public JRChild getCopy(JRAbstractObjectFactory factory) {
        return factory.getFrame(this);
    }

    @Override
    public void writeXml(JRXmlWriter writer) throws IOException {
        writer.writeFrame(this);
    }

    @Override
    public JRElement getElementByKey(String key) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), key);
    }

    @Override
    public JRCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillFrame(this, factory);
    }

    @Override
    public byte getBorder() {
        return JRStyleResolver.getBorder(this);
    }

    @Override
    public Byte getOwnBorder() {
        return this.parentFrame.getOwnBorder();
    }

    @Override
    public void setBorder(byte border) {
    }

    @Override
    public Color getBorderColor() {
        return JRStyleResolver.getBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBorderColor() {
        return this.parentFrame.getOwnBorderColor();
    }

    @Override
    public void setBorderColor(Color borderColor) {
    }

    @Override
    public int getPadding() {
        return JRStyleResolver.getPadding(this);
    }

    @Override
    public Integer getOwnPadding() {
        return this.parentFrame.getOwnPadding();
    }

    @Override
    public void setPadding(int padding) {
    }

    @Override
    public byte getTopBorder() {
        return JRStyleResolver.getTopBorder(this);
    }

    @Override
    public Byte getOwnTopBorder() {
        return this.parentFrame.getOwnTopBorder();
    }

    @Override
    public void setTopBorder(byte topBorder) {
    }

    @Override
    public Color getTopBorderColor() {
        return JRStyleResolver.getTopBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnTopBorderColor() {
        return this.parentFrame.getOwnTopBorderColor();
    }

    @Override
    public void setTopBorderColor(Color topBorderColor) {
    }

    @Override
    public int getTopPadding() {
        return JRStyleResolver.getTopPadding(this);
    }

    @Override
    public Integer getOwnTopPadding() {
        return this.parentFrame.getOwnTopPadding();
    }

    @Override
    public void setTopPadding(int topPadding) {
    }

    @Override
    public byte getLeftBorder() {
        return JRStyleResolver.getLeftBorder(this);
    }

    @Override
    public Byte getOwnLeftBorder() {
        return this.parentFrame.getOwnLeftBorder();
    }

    @Override
    public void setLeftBorder(byte leftBorder) {
    }

    @Override
    public Color getLeftBorderColor() {
        return JRStyleResolver.getLeftBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnLeftBorderColor() {
        return this.parentFrame.getOwnLeftBorderColor();
    }

    @Override
    public void setLeftBorderColor(Color leftBorderColor) {
    }

    @Override
    public int getLeftPadding() {
        return JRStyleResolver.getLeftPadding(this);
    }

    @Override
    public Integer getOwnLeftPadding() {
        return this.parentFrame.getOwnLeftPadding();
    }

    @Override
    public void setLeftPadding(int leftPadding) {
    }

    @Override
    public byte getBottomBorder() {
        return JRStyleResolver.getBottomBorder(this);
    }

    @Override
    public Byte getOwnBottomBorder() {
        return this.parentFrame.getOwnBottomBorder();
    }

    @Override
    public void setBottomBorder(byte bottomBorder) {
    }

    @Override
    public Color getBottomBorderColor() {
        return JRStyleResolver.getBottomBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnBottomBorderColor() {
        return this.parentFrame.getOwnBottomBorderColor();
    }

    @Override
    public void setBottomBorderColor(Color bottomBorderColor) {
    }

    @Override
    public int getBottomPadding() {
        return JRStyleResolver.getBottomPadding(this);
    }

    @Override
    public Integer getOwnBottomPadding() {
        return this.parentFrame.getOwnBottomPadding();
    }

    @Override
    public void setBottomPadding(int bottomPadding) {
    }

    @Override
    public byte getRightBorder() {
        return JRStyleResolver.getRightBorder(this);
    }

    @Override
    public Byte getOwnRightBorder() {
        return this.parentFrame.getOwnRightBorder();
    }

    @Override
    public void setRightBorder(byte rightBorder) {
    }

    @Override
    public Color getRightBorderColor() {
        return JRStyleResolver.getRightBorderColor(this, this.getForecolor());
    }

    @Override
    public Color getOwnRightBorderColor() {
        return this.parentFrame.getOwnRightBorderColor();
    }

    @Override
    public void setRightBorderColor(Color rightBorderColor) {
    }

    @Override
    public int getRightPadding() {
        return JRStyleResolver.getRightPadding(this);
    }

    @Override
    public Integer getOwnRightPadding() {
        return this.parentFrame.getOwnRightPadding();
    }

    @Override
    public void setRightPadding(int rightPadding) {
    }

    @Override
    public void setBorder(Byte border) {
    }

    @Override
    public void setPadding(Integer padding) {
    }

    @Override
    public void setTopBorder(Byte topBorder) {
    }

    @Override
    public void setTopPadding(Integer topPadding) {
    }

    @Override
    public void setLeftBorder(Byte leftBorder) {
    }

    @Override
    public void setLeftPadding(Integer leftPadding) {
    }

    @Override
    public void setBottomBorder(Byte bottomBorder) {
    }

    @Override
    public void setBottomPadding(Integer bottomPadding) {
    }

    @Override
    public void setRightBorder(Byte rightBorder) {
    }

    @Override
    public void setRightPadding(Integer rightPadding) {
    }

    protected class JRFillFrameElements
    extends JRFillElementContainer {
        JRFillFrameElements(JRFillObjectFactory factory) {
            super(JRFillFrame.this.filler, JRFillFrame.this.parentFrame, factory);
            this.initElements();
        }

        JRFillFrameElements(JRFillFrameElements frameElements, JRFillCloneFactory factory) {
            super(frameElements, factory);
            this.initElements();
        }

        @Override
        protected int getContainerHeight() {
            return JRFillFrame.this.getHeight() - JRFillFrame.this.getTopPadding() - JRFillFrame.this.getBottomPadding();
        }

        @Override
        public boolean getIsStretchWithOverflow() {
            return true;
        }
    }
}

