/*
 * Decompiled with CFR 0.152.
 */
package macromedia.sequelink.net;

import java.io.OutputStream;
import macromedia.sequelink.net.NetworkException;
import macromedia.sequelink.net.SPDU;
import macromedia.sequelink.net.SPDUConnectEncoder;

public class SPDUConnect
extends SPDU {
    private static final int kMAX_USERDATA = 512;
    private int fuReq;
    private int protocolOptions;
    private byte[] callingSelector;
    private byte[] calledSelector;
    private int maxSendTduSize;
    private int maxRecvTduSize;
    private int userDataLen;

    SPDUConnect(int n2, int n3, byte[] byArray, byte[] byArray2, int n4, int n5, int n6) throws NetworkException {
        super(1);
        this.validateSelector(byArray);
        this.validateSelector(byArray2);
        this.validateUserDataLen(n6);
        this.fuReq = n2;
        this.protocolOptions = n3;
        this.callingSelector = byArray;
        this.calledSelector = byArray2;
        this.maxSendTduSize = n4;
        this.maxRecvTduSize = n5;
        this.userDataLen = n6;
    }

    private void validateUserDataLen(int n2) throws NetworkException {
        if (n2 < 0 || n2 > 512) {
            throw SPDUConnect.getException(7576);
        }
    }

    public int getFuReq() {
        return this.fuReq;
    }

    public int getProtocolOptions() {
        return this.protocolOptions;
    }

    public byte[] getCalledSelector() {
        return this.calledSelector;
    }

    public byte[] getCallingSelector() {
        return this.callingSelector;
    }

    public int getMaxSendTduSize() {
        return this.maxSendTduSize;
    }

    public int getMaxRecvTduSize() {
        return this.maxRecvTduSize;
    }

    public int getUserDataLen() {
        return this.userDataLen;
    }

    public int encode(OutputStream outputStream) throws NetworkException {
        SPDUConnectEncoder sPDUConnectEncoder = new SPDUConnectEncoder(outputStream, this);
        return sPDUConnectEncoder.size();
    }
}

