/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.org.json;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.org.json.JSONException;
import macromedia.jdbc.sqlserver.externals.org.json.JSONObject;
import macromedia.jdbc.sqlserver.externals.org.json.JSONPointer;
import macromedia.jdbc.sqlserver.externals.org.json.JSONPointerException;
import macromedia.jdbc.sqlserver.externals.org.json.JSONString;
import macromedia.jdbc.sqlserver.externals.org.json.JSONTokener;

public class JSONArray
implements Iterable<Object> {
    private final ArrayList<Object> myArrayList;

    public JSONArray() {
        this.myArrayList = new ArrayList();
    }

    public JSONArray(JSONTokener jSONTokener) throws JSONException {
        this();
        if (jSONTokener.nextClean() != '[') {
            throw jSONTokener.syntaxError("A JSONArray text must start with '['");
        }
        char c2 = jSONTokener.nextClean();
        if (c2 == '\u0000') {
            throw jSONTokener.syntaxError("Expected a ',' or ']'");
        }
        if (c2 != ']') {
            jSONTokener.back();
            block5: while (true) {
                if (jSONTokener.nextClean() == ',') {
                    jSONTokener.back();
                    this.myArrayList.add(JSONObject.NULL);
                } else {
                    jSONTokener.back();
                    this.myArrayList.add(jSONTokener.nextValue());
                }
                switch (jSONTokener.nextClean()) {
                    case '\u0000': {
                        throw jSONTokener.syntaxError("Expected a ',' or ']'");
                    }
                    case ',': {
                        c2 = jSONTokener.nextClean();
                        if (c2 == '\u0000') {
                            throw jSONTokener.syntaxError("Expected a ',' or ']'");
                        }
                        if (c2 == ']') {
                            return;
                        }
                        jSONTokener.back();
                        continue block5;
                    }
                    case ']': {
                        return;
                    }
                }
                break;
            }
            throw jSONTokener.syntaxError("Expected a ',' or ']'");
        }
    }

    public JSONArray(String string) throws JSONException {
        this(new JSONTokener(string));
    }

    public JSONArray(Collection<?> collection) {
        if (collection == null) {
            this.myArrayList = new ArrayList();
        } else {
            this.myArrayList = new ArrayList(collection.size());
            this.addAll(collection, true);
        }
    }

    public JSONArray(Iterable<?> iterable) {
        this();
        if (iterable == null) {
            return;
        }
        this.addAll(iterable, true);
    }

    public JSONArray(JSONArray jSONArray) {
        this.myArrayList = jSONArray == null ? new ArrayList() : new ArrayList<Object>(jSONArray.myArrayList);
    }

    public JSONArray(Object object) throws JSONException {
        this();
        if (!object.getClass().isArray()) {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
        this.addAll(object, true);
    }

    public JSONArray(int n2) throws JSONException {
        if (n2 < 0) {
            throw new JSONException("JSONArray initial capacity cannot be negative.");
        }
        this.myArrayList = new ArrayList(n2);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.myArrayList.iterator();
    }

    public Object get(int n2) throws JSONException {
        Object object = this.opt(n2);
        if (object == null) {
            throw new JSONException("JSONArray[" + n2 + "] not found.");
        }
        return object;
    }

    public boolean getBoolean(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object.equals(Boolean.FALSE) || object instanceof String && ((String)object).equalsIgnoreCase("false")) {
            return false;
        }
        if (object.equals(Boolean.TRUE) || object instanceof String && ((String)object).equalsIgnoreCase("true")) {
            return true;
        }
        throw JSONArray.wrongValueFormatException(n2, "boolean", object, null);
    }

    public double getDouble(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        try {
            return Double.parseDouble(object.toString());
        }
        catch (Exception exception) {
            throw JSONArray.wrongValueFormatException(n2, "double", object, exception);
        }
    }

    public float getFloat(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof Number) {
            return ((Number)object).floatValue();
        }
        try {
            return Float.parseFloat(object.toString());
        }
        catch (Exception exception) {
            throw JSONArray.wrongValueFormatException(n2, "float", object, exception);
        }
    }

    public Number getNumber(int n2) throws JSONException {
        Object object = this.get(n2);
        try {
            if (object instanceof Number) {
                return (Number)object;
            }
            return JSONObject.stringToNumber(object.toString());
        }
        catch (Exception exception) {
            throw JSONArray.wrongValueFormatException(n2, "number", object, exception);
        }
    }

    public <E extends Enum<E>> E getEnum(Class<E> clazz, int n2) throws JSONException {
        E e2 = this.optEnum(clazz, n2);
        if (e2 == null) {
            throw JSONArray.wrongValueFormatException(n2, "enum of type " + JSONObject.quote(clazz.getSimpleName()), this.opt(n2), null);
        }
        return e2;
    }

    public BigDecimal getBigDecimal(int n2) throws JSONException {
        Object object = this.get(n2);
        BigDecimal bigDecimal = JSONObject.objectToBigDecimal(object, null);
        if (bigDecimal == null) {
            throw JSONArray.wrongValueFormatException(n2, "BigDecimal", object, null);
        }
        return bigDecimal;
    }

    public BigInteger getBigInteger(int n2) throws JSONException {
        Object object = this.get(n2);
        BigInteger bigInteger = JSONObject.objectToBigInteger(object, null);
        if (bigInteger == null) {
            throw JSONArray.wrongValueFormatException(n2, "BigInteger", object, null);
        }
        return bigInteger;
    }

    public int getInt(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        try {
            return Integer.parseInt(object.toString());
        }
        catch (Exception exception) {
            throw JSONArray.wrongValueFormatException(n2, "int", object, exception);
        }
    }

    public JSONArray getJSONArray(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof JSONArray) {
            return (JSONArray)object;
        }
        throw JSONArray.wrongValueFormatException(n2, "JSONArray", object, null);
    }

    public JSONObject getJSONObject(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof JSONObject) {
            return (JSONObject)object;
        }
        throw JSONArray.wrongValueFormatException(n2, "JSONObject", object, null);
    }

    public long getLong(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        try {
            return Long.parseLong(object.toString());
        }
        catch (Exception exception) {
            throw JSONArray.wrongValueFormatException(n2, "long", object, exception);
        }
    }

    public String getString(int n2) throws JSONException {
        Object object = this.get(n2);
        if (object instanceof String) {
            return (String)object;
        }
        throw JSONArray.wrongValueFormatException(n2, "String", object, null);
    }

    public boolean isNull(int n2) {
        return JSONObject.NULL.equals(this.opt(n2));
    }

    public String join(String string) throws JSONException {
        int n2 = this.length();
        if (n2 == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(JSONObject.valueToString(this.myArrayList.get(0)));
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuilder.append(string).append(JSONObject.valueToString(this.myArrayList.get(i2)));
        }
        return stringBuilder.toString();
    }

    public int length() {
        return this.myArrayList.size();
    }

    public void clear() {
        this.myArrayList.clear();
    }

    public Object opt(int n2) {
        return n2 < 0 || n2 >= this.length() ? null : this.myArrayList.get(n2);
    }

    public boolean optBoolean(int n2) {
        return this.optBoolean(n2, false);
    }

    public boolean optBoolean(int n2, boolean bl2) {
        try {
            return this.getBoolean(n2);
        }
        catch (Exception exception) {
            return bl2;
        }
    }

    public double optDouble(int n2) {
        return this.optDouble(n2, Double.NaN);
    }

    public double optDouble(int n2, double d2) {
        Number number = this.optNumber(n2, null);
        if (number == null) {
            return d2;
        }
        double d3 = number.doubleValue();
        return d3;
    }

    public float optFloat(int n2) {
        return this.optFloat(n2, Float.NaN);
    }

    public float optFloat(int n2, float f2) {
        Number number = this.optNumber(n2, null);
        if (number == null) {
            return f2;
        }
        float f3 = number.floatValue();
        return f3;
    }

    public int optInt(int n2) {
        return this.optInt(n2, 0);
    }

    public int optInt(int n2, int n3) {
        Number number = this.optNumber(n2, null);
        if (number == null) {
            return n3;
        }
        return number.intValue();
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, int n2) {
        return this.optEnum(clazz, n2, null);
    }

    public <E extends Enum<E>> E optEnum(Class<E> clazz, int n2, E e2) {
        try {
            Object object = this.opt(n2);
            if (JSONObject.NULL.equals(object)) {
                return e2;
            }
            if (clazz.isAssignableFrom(object.getClass())) {
                Enum enum_ = (Enum)object;
                return (E)enum_;
            }
            return Enum.valueOf(clazz, object.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return e2;
        }
        catch (NullPointerException nullPointerException) {
            return e2;
        }
    }

    public BigInteger optBigInteger(int n2, BigInteger bigInteger) {
        Object object = this.opt(n2);
        return JSONObject.objectToBigInteger(object, bigInteger);
    }

    public BigDecimal optBigDecimal(int n2, BigDecimal bigDecimal) {
        Object object = this.opt(n2);
        return JSONObject.objectToBigDecimal(object, bigDecimal);
    }

    public JSONArray optJSONArray(int n2) {
        Object object = this.opt(n2);
        return object instanceof JSONArray ? (JSONArray)object : null;
    }

    public JSONObject optJSONObject(int n2) {
        Object object = this.opt(n2);
        return object instanceof JSONObject ? (JSONObject)object : null;
    }

    public long optLong(int n2) {
        return this.optLong(n2, 0L);
    }

    public long optLong(int n2, long l2) {
        Number number = this.optNumber(n2, null);
        if (number == null) {
            return l2;
        }
        return number.longValue();
    }

    public Number optNumber(int n2) {
        return this.optNumber(n2, null);
    }

    public Number optNumber(int n2, Number number) {
        Object object = this.opt(n2);
        if (JSONObject.NULL.equals(object)) {
            return number;
        }
        if (object instanceof Number) {
            return (Number)object;
        }
        if (object instanceof String) {
            try {
                return JSONObject.stringToNumber((String)object);
            }
            catch (Exception exception) {
                return number;
            }
        }
        return number;
    }

    public String optString(int n2) {
        return this.optString(n2, "");
    }

    public String optString(int n2, String string) {
        Object object = this.opt(n2);
        return JSONObject.NULL.equals(object) ? string : object.toString();
    }

    public JSONArray put(boolean bl2) {
        return this.put(bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray put(Collection<?> collection) {
        return this.put(new JSONArray(collection));
    }

    public JSONArray put(double d2) throws JSONException {
        return this.put((Object)d2);
    }

    public JSONArray put(float f2) throws JSONException {
        return this.put(Float.valueOf(f2));
    }

    public JSONArray put(int n2) {
        return this.put((Object)n2);
    }

    public JSONArray put(long l2) {
        return this.put((Object)l2);
    }

    public JSONArray put(Map<?, ?> map) {
        return this.put(new JSONObject(map));
    }

    public JSONArray put(Object object) {
        JSONObject.testValidity(object);
        this.myArrayList.add(object);
        return this;
    }

    public JSONArray put(int n2, boolean bl2) throws JSONException {
        return this.put(n2, bl2 ? Boolean.TRUE : Boolean.FALSE);
    }

    public JSONArray put(int n2, Collection<?> collection) throws JSONException {
        return this.put(n2, new JSONArray(collection));
    }

    public JSONArray put(int n2, double d2) throws JSONException {
        return this.put(n2, (Object)d2);
    }

    public JSONArray put(int n2, float f2) throws JSONException {
        return this.put(n2, Float.valueOf(f2));
    }

    public JSONArray put(int n2, int n3) throws JSONException {
        return this.put(n2, (Object)n3);
    }

    public JSONArray put(int n2, long l2) throws JSONException {
        return this.put(n2, (Object)l2);
    }

    public JSONArray put(int n2, Map<?, ?> map) throws JSONException {
        this.put(n2, new JSONObject(map));
        return this;
    }

    public JSONArray put(int n2, Object object) throws JSONException {
        if (n2 < 0) {
            throw new JSONException("JSONArray[" + n2 + "] not found.");
        }
        if (n2 < this.length()) {
            JSONObject.testValidity(object);
            this.myArrayList.set(n2, object);
            return this;
        }
        if (n2 == this.length()) {
            return this.put(object);
        }
        this.myArrayList.ensureCapacity(n2 + 1);
        while (n2 != this.length()) {
            this.myArrayList.add(JSONObject.NULL);
        }
        return this.put(object);
    }

    public JSONArray putAll(Collection<?> collection) {
        this.addAll(collection, false);
        return this;
    }

    public JSONArray putAll(Iterable<?> iterable) {
        this.addAll(iterable, false);
        return this;
    }

    public JSONArray putAll(JSONArray jSONArray) {
        this.myArrayList.addAll(jSONArray.myArrayList);
        return this;
    }

    public JSONArray putAll(Object object) throws JSONException {
        this.addAll(object, false);
        return this;
    }

    public Object query(String string) {
        return this.query(new JSONPointer(string));
    }

    public Object query(JSONPointer jSONPointer) {
        return jSONPointer.queryFrom(this);
    }

    public Object optQuery(String string) {
        return this.optQuery(new JSONPointer(string));
    }

    public Object optQuery(JSONPointer jSONPointer) {
        try {
            return jSONPointer.queryFrom(this);
        }
        catch (JSONPointerException jSONPointerException) {
            return null;
        }
    }

    public Object remove(int n2) {
        return n2 >= 0 && n2 < this.length() ? this.myArrayList.remove(n2) : null;
    }

    public boolean similar(Object object) {
        if (!(object instanceof JSONArray)) {
            return false;
        }
        int n2 = this.length();
        if (n2 != ((JSONArray)object).length()) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object2;
            Object object3 = this.myArrayList.get(i2);
            if (object3 == (object2 = ((JSONArray)object).myArrayList.get(i2))) continue;
            if (object3 == null) {
                return false;
            }
            if (!(object3 instanceof JSONObject ? !((JSONObject)object3).similar(object2) : (object3 instanceof JSONArray ? !((JSONArray)object3).similar(object2) : (object3 instanceof Number && object2 instanceof Number ? !JSONObject.isNumberSimilar((Number)object3, (Number)object2) : (object3 instanceof JSONString && object2 instanceof JSONString ? !((JSONString)object3).toJSONString().equals(((JSONString)object2).toJSONString()) : !object3.equals(object2)))))) continue;
            return false;
        }
        return true;
    }

    public JSONObject toJSONObject(JSONArray jSONArray) throws JSONException {
        if (jSONArray == null || jSONArray.isEmpty() || this.isEmpty()) {
            return null;
        }
        JSONObject jSONObject = new JSONObject(jSONArray.length());
        for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
            jSONObject.put(jSONArray.getString(i2), this.opt(i2));
        }
        return jSONObject;
    }

    public String toString() {
        try {
            return this.toString(0);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(int n2) throws JSONException {
        StringWriter stringWriter = new StringWriter();
        StringBuffer stringBuffer = stringWriter.getBuffer();
        synchronized (stringBuffer) {
            return this.write(stringWriter, n2, 0).toString();
        }
    }

    public Writer write(Writer writer) throws JSONException {
        return this.write(writer, 0, 0);
    }

    public Writer write(Writer writer, int n2, int n3) throws JSONException {
        try {
            boolean bl2 = false;
            int n4 = this.length();
            writer.write(91);
            if (n4 == 1) {
                try {
                    JSONObject.writeValue(writer, this.myArrayList.get(0), n2, n3);
                }
                catch (Exception exception) {
                    throw new JSONException("Unable to write JSONArray value at index: 0", exception);
                }
            }
            if (n4 != 0) {
                int n5 = n3 + n2;
                for (int i2 = 0; i2 < n4; ++i2) {
                    if (bl2) {
                        writer.write(44);
                    }
                    if (n2 > 0) {
                        writer.write(10);
                    }
                    JSONObject.indent(writer, n5);
                    try {
                        JSONObject.writeValue(writer, this.myArrayList.get(i2), n2, n5);
                    }
                    catch (Exception exception) {
                        throw new JSONException("Unable to write JSONArray value at index: " + i2, exception);
                    }
                    bl2 = true;
                }
                if (n2 > 0) {
                    writer.write(10);
                }
                JSONObject.indent(writer, n3);
            }
            writer.write(93);
            return writer;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException);
        }
    }

    public List<Object> toList() {
        ArrayList<Object> arrayList = new ArrayList<Object>(this.myArrayList.size());
        for (Object object : this.myArrayList) {
            if (object == null || JSONObject.NULL.equals(object)) {
                arrayList.add(null);
                continue;
            }
            if (object instanceof JSONArray) {
                arrayList.add(((JSONArray)object).toList());
                continue;
            }
            if (object instanceof JSONObject) {
                arrayList.add(((JSONObject)object).toMap());
                continue;
            }
            arrayList.add(object);
        }
        return arrayList;
    }

    public boolean isEmpty() {
        return this.myArrayList.isEmpty();
    }

    private void addAll(Collection<?> collection, boolean bl2) {
        this.myArrayList.ensureCapacity(this.myArrayList.size() + collection.size());
        if (bl2) {
            for (Object obj : collection) {
                this.put(JSONObject.wrap(obj));
            }
        } else {
            for (Object obj : collection) {
                this.put(obj);
            }
        }
    }

    private void addAll(Iterable<?> iterable, boolean bl2) {
        if (bl2) {
            for (Object obj : iterable) {
                this.put(JSONObject.wrap(obj));
            }
        } else {
            for (Object obj : iterable) {
                this.put(obj);
            }
        }
    }

    private void addAll(Object object, boolean bl2) throws JSONException {
        if (object.getClass().isArray()) {
            int n2 = Array.getLength(object);
            this.myArrayList.ensureCapacity(this.myArrayList.size() + n2);
            if (bl2) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.put(JSONObject.wrap(Array.get(object, i2)));
                }
            } else {
                for (int i3 = 0; i3 < n2; ++i3) {
                    this.put(Array.get(object, i3));
                }
            }
        } else if (object instanceof JSONArray) {
            this.myArrayList.addAll(((JSONArray)object).myArrayList);
        } else if (object instanceof Collection) {
            this.addAll((Collection)object, bl2);
        } else if (object instanceof Iterable) {
            this.addAll((Iterable)object, bl2);
        } else {
            throw new JSONException("JSONArray initial value should be a string or collection or array.");
        }
    }

    private static JSONException wrongValueFormatException(int n2, String string, Object object, Throwable throwable) {
        if (object == null) {
            return new JSONException("JSONArray[" + n2 + "] is not a " + string + " (null).", throwable);
        }
        if (object instanceof Map || object instanceof Iterable || object instanceof JSONObject) {
            return new JSONException("JSONArray[" + n2 + "] is not a " + string + " (" + object.getClass() + ").", throwable);
        }
        return new JSONException("JSONArray[" + n2 + "] is not a " + string + " (" + object.getClass() + " : " + object + ").", throwable);
    }
}

