/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json.writer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAwareEx;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.ArraysMapper;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.BeansMapper;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.CollectionMapper;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.DefaultMapper;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.DefaultMapperCollection;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.DefaultMapperOrdered;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReaderI;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.MapperRemapped;

public class JsonReader {
    private final ConcurrentHashMap<Type, JsonReaderI<?>> cache = new ConcurrentHashMap(100);
    public JsonReaderI<JSONAwareEx> DEFAULT;
    public JsonReaderI<JSONAwareEx> DEFAULT_ORDERED;

    public JsonReader() {
        this.cache.put((Type)((Object)Date.class), BeansMapper.MAPPER_DATE);
        this.cache.put((Type)((Object)int[].class), ArraysMapper.MAPPER_PRIM_INT);
        this.cache.put((Type)((Object)Integer[].class), ArraysMapper.MAPPER_INT);
        this.cache.put((Type)((Object)short[].class), ArraysMapper.MAPPER_PRIM_INT);
        this.cache.put((Type)((Object)Short[].class), ArraysMapper.MAPPER_INT);
        this.cache.put((Type)((Object)long[].class), ArraysMapper.MAPPER_PRIM_LONG);
        this.cache.put((Type)((Object)Long[].class), ArraysMapper.MAPPER_LONG);
        this.cache.put((Type)((Object)byte[].class), ArraysMapper.MAPPER_PRIM_BYTE);
        this.cache.put((Type)((Object)Byte[].class), ArraysMapper.MAPPER_BYTE);
        this.cache.put((Type)((Object)char[].class), ArraysMapper.MAPPER_PRIM_CHAR);
        this.cache.put((Type)((Object)Character[].class), ArraysMapper.MAPPER_CHAR);
        this.cache.put((Type)((Object)float[].class), ArraysMapper.MAPPER_PRIM_FLOAT);
        this.cache.put((Type)((Object)Float[].class), ArraysMapper.MAPPER_FLOAT);
        this.cache.put((Type)((Object)double[].class), ArraysMapper.MAPPER_PRIM_DOUBLE);
        this.cache.put((Type)((Object)Double[].class), ArraysMapper.MAPPER_DOUBLE);
        this.cache.put((Type)((Object)boolean[].class), ArraysMapper.MAPPER_PRIM_BOOL);
        this.cache.put((Type)((Object)Boolean[].class), ArraysMapper.MAPPER_BOOL);
        this.DEFAULT = new DefaultMapper<JSONAwareEx>(this);
        this.DEFAULT_ORDERED = new DefaultMapperOrdered(this);
        this.cache.put((Type)((Object)JSONAwareEx.class), this.DEFAULT);
        this.cache.put((Type)((Object)JSONAware.class), this.DEFAULT);
        this.cache.put((Type)((Object)JSONArray.class), this.DEFAULT);
        this.cache.put((Type)((Object)JSONObject.class), this.DEFAULT);
    }

    public <T> void remapField(Class<T> clazz, String string, String string2) {
        JsonReaderI<T> jsonReaderI = this.getMapper(clazz);
        if (!(jsonReaderI instanceof MapperRemapped)) {
            jsonReaderI = new MapperRemapped<T>(jsonReaderI);
            this.registerReader(clazz, jsonReaderI);
        }
        ((MapperRemapped)jsonReaderI).renameField(string, string2);
    }

    public <T> void registerReader(Class<T> clazz, JsonReaderI<T> jsonReaderI) {
        this.cache.put(clazz, jsonReaderI);
    }

    public <T> JsonReaderI<T> getMapper(Type type) {
        if (type instanceof ParameterizedType) {
            return this.getMapper((ParameterizedType)type);
        }
        return this.getMapper((Class)type);
    }

    public <T> JsonReaderI<T> getMapper(Class<T> clazz) {
        JsonReaderI jsonReaderI = this.cache.get(clazz);
        if (jsonReaderI != null) {
            return jsonReaderI;
        }
        if (clazz instanceof Class) {
            if (Map.class.isAssignableFrom(clazz)) {
                jsonReaderI = new DefaultMapperCollection(this, clazz);
            } else if (List.class.isAssignableFrom(clazz)) {
                jsonReaderI = new DefaultMapperCollection(this, clazz);
            }
            if (jsonReaderI != null) {
                this.cache.put(clazz, jsonReaderI);
                return jsonReaderI;
            }
        }
        jsonReaderI = clazz.isArray() ? new ArraysMapper.GenericMapper(this, clazz) : (List.class.isAssignableFrom(clazz) ? new CollectionMapper.ListClass(this, clazz) : (Map.class.isAssignableFrom(clazz) ? new CollectionMapper.MapClass(this, clazz) : new BeansMapper.Bean(this, clazz)));
        this.cache.putIfAbsent(clazz, jsonReaderI);
        return jsonReaderI;
    }

    public <T> JsonReaderI<T> getMapper(ParameterizedType parameterizedType) {
        JsonReaderI<?> jsonReaderI = this.cache.get(parameterizedType);
        if (jsonReaderI != null) {
            return jsonReaderI;
        }
        Class clazz = (Class)parameterizedType.getRawType();
        if (List.class.isAssignableFrom(clazz)) {
            jsonReaderI = new CollectionMapper.ListType(this, parameterizedType);
        } else if (Map.class.isAssignableFrom(clazz)) {
            jsonReaderI = new CollectionMapper.MapType(this, parameterizedType);
        }
        this.cache.putIfAbsent(parameterizedType, jsonReaderI);
        return jsonReaderI;
    }
}

