/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONStyle;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.parser.JSONParser;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.parser.ParseException;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.reader.JsonWriter;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.reader.JsonWriterI;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.CompessorMapper;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.FakeMapper;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReader;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReaderI;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.UpdaterMapper;

public class JSONValue {
    public static JSONStyle COMPRESSION = JSONStyle.NO_COMPRESS;
    public static final JsonWriter defaultWriter = new JsonWriter();
    public static final JsonReader defaultReader = new JsonReader();

    public static Object parse(InputStream inputStream) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(byte[] byArray) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(InputStream inputStream, Class<T> clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(inputStream, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(Reader reader) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(byte[] byArray, Class<T> clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(byArray, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(Reader reader, Class<T> clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(reader, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(Reader reader, T t2) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(reader, new UpdaterMapper<T>(defaultReader, t2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static <T> T parse(Reader reader, JsonReaderI<T> jsonReaderI) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(reader, jsonReaderI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(String string, Class<T> clazz) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(string, defaultReader.getMapper(clazz));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(InputStream inputStream, T t2) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(inputStream, new UpdaterMapper<T>(defaultReader, t2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static <T> T parse(String string, T t2) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(string, new UpdaterMapper<T>(defaultReader, t2));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static <T> T parse(byte[] byArray, JsonReaderI<T> jsonReaderI) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(byArray, jsonReaderI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected static <T> T parse(String string, JsonReaderI<T> jsonReaderI) {
        try {
            JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
            return jSONParser.parse(string, jsonReaderI);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parse(String string) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(Reader reader) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, JSONValue.defaultReader.DEFAULT_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static Object parseKeepingOrder(String string) {
        try {
            return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, JSONValue.defaultReader.DEFAULT_ORDERED);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String compress(String string, JSONStyle jSONStyle) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, new CompessorMapper(defaultReader, stringBuilder, jSONStyle));
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String compress(String string) {
        return JSONValue.compress(string, JSONStyle.MAX_COMPRESS);
    }

    public static String uncompress(String string) {
        return JSONValue.compress(string, JSONStyle.NO_COMPRESS);
    }

    public static Object parseWithException(byte[] byArray) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(byArray, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(InputStream inputStream) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(inputStream, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(Reader reader) throws IOException, ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseWithException(String string) throws ParseException {
        return new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, JSONValue.defaultReader.DEFAULT);
    }

    public static <T> T parseWithException(String string, Class<T> clazz) throws ParseException {
        JSONParser jSONParser = new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE);
        return jSONParser.parse(string, defaultReader.getMapper(clazz));
    }

    public static Object parseStrict(Reader reader) throws IOException, ParseException {
        return new JSONParser(656).parse(reader, JSONValue.defaultReader.DEFAULT);
    }

    public static Object parseStrict(String string) throws ParseException {
        return new JSONParser(656).parse(string, JSONValue.defaultReader.DEFAULT);
    }

    public static boolean isValidJsonStrict(Reader reader) throws IOException {
        try {
            new JSONParser(656).parse(reader, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJsonStrict(String string) {
        try {
            new JSONParser(656).parse(string, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJson(Reader reader) throws IOException {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(reader, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static boolean isValidJson(String string) {
        try {
            new JSONParser(JSONParser.DEFAULT_PERMISSIVE_MODE).parse(string, FakeMapper.DEFAULT);
            return true;
        }
        catch (ParseException parseException) {
            return false;
        }
    }

    public static void writeJSONString(Object object, Appendable appendable) throws IOException {
        JSONValue.writeJSONString(object, appendable, COMPRESSION);
    }

    public static <T> void remapField(Class<T> clazz, String string, String string2) {
        defaultReader.remapField(clazz, string, string2);
        defaultWriter.remapField(clazz, string2, string);
    }

    public static <T> void registerWriter(Class<?> clazz, JsonWriterI<T> jsonWriterI) {
        defaultWriter.registerWriter(jsonWriterI, clazz);
    }

    public static <T> void registerReader(Class<T> clazz, JsonReaderI<T> jsonReaderI) {
        defaultReader.registerReader(clazz, jsonReaderI);
    }

    public static void writeJSONString(Object object, Appendable appendable, JSONStyle jSONStyle) throws IOException {
        if (object == null) {
            appendable.append("null");
            return;
        }
        Class<?> clazz = object.getClass();
        JsonWriterI<Object> jsonWriterI = defaultWriter.getWrite(clazz);
        if (jsonWriterI == null) {
            if (clazz.isArray()) {
                jsonWriterI = JsonWriter.arrayWriter;
            } else {
                jsonWriterI = defaultWriter.getWriterByInterface(object.getClass());
                if (jsonWriterI == null) {
                    jsonWriterI = JsonWriter.beansWriterASM;
                }
            }
            defaultWriter.registerWriter(jsonWriterI, clazz);
        }
        jsonWriterI.writeJSONString(object, appendable, jSONStyle);
    }

    public static String toJSONString(Object object) {
        return JSONValue.toJSONString(object, COMPRESSION);
    }

    public static String toJSONString(Object object, JSONStyle jSONStyle) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            JSONValue.writeJSONString(object, stringBuilder, jSONStyle);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }

    public static String escape(String string) {
        return JSONValue.escape(string, COMPRESSION);
    }

    public static String escape(String string, JSONStyle jSONStyle) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        jSONStyle.escape(string, stringBuilder);
        return stringBuilder.toString();
    }

    public static void escape(String string, Appendable appendable) {
        JSONValue.escape(string, appendable, COMPRESSION);
    }

    public static void escape(String string, Appendable appendable, JSONStyle jSONStyle) {
        if (string == null) {
            return;
        }
        jSONStyle.escape(string, appendable);
    }
}

