/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.net.minidev.json;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAwareEx;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONStyle;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONValue;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.writer.JsonReaderI;

public class JSONNavi<T> {
    private JsonReaderI<? super T> mapper;
    private T root;
    private Stack<Object> stack = new Stack();
    private Stack<Object> path = new Stack();
    private Object current;
    private boolean failure = false;
    private String failureMessage;
    private boolean readonly = false;
    private Object missingKey = null;
    private static final JSONStyle ERROR_COMPRESS = new JSONStyle(2);

    public static JSONNavi<JSONAwareEx> newInstance() {
        return new JSONNavi<JSONAwareEx>(JSONValue.defaultReader.DEFAULT_ORDERED);
    }

    public static JSONNavi<JSONObject> newInstanceObject() {
        JSONNavi<JSONObject> jSONNavi = new JSONNavi<JSONObject>(JSONValue.defaultReader.getMapper(JSONObject.class));
        jSONNavi.object();
        return jSONNavi;
    }

    public static JSONNavi<JSONArray> newInstanceArray() {
        JSONNavi<JSONArray> jSONNavi = new JSONNavi<JSONArray>(JSONValue.defaultReader.getMapper(JSONArray.class));
        jSONNavi.array();
        return jSONNavi;
    }

    public JSONNavi(JsonReaderI<? super T> jsonReaderI) {
        this.mapper = jsonReaderI;
    }

    public JSONNavi(String string) {
        this.root = JSONValue.parse(string);
        this.current = this.root;
        this.readonly = true;
    }

    public JSONNavi(String string, JsonReaderI<T> jsonReaderI) {
        this.root = JSONValue.parse(string, jsonReaderI);
        this.mapper = jsonReaderI;
        this.current = this.root;
        this.readonly = true;
    }

    public JSONNavi(String string, Class<T> clazz) {
        this.root = JSONValue.parse(string, clazz);
        this.mapper = JSONValue.defaultReader.getMapper(clazz);
        this.current = this.root;
        this.readonly = true;
    }

    public JSONNavi<T> root() {
        this.current = this.root;
        this.stack.clear();
        this.path.clear();
        this.failure = false;
        this.missingKey = null;
        this.failureMessage = null;
        return this;
    }

    public boolean hasFailure() {
        return this.failure;
    }

    public Object getCurrentObject() {
        return this.current;
    }

    public Collection<String> getKeys() {
        if (this.current instanceof Map) {
            return ((Map)this.current).keySet();
        }
        return null;
    }

    public int getSize() {
        if (this.current == null) {
            return 0;
        }
        if (this.isArray()) {
            return ((List)this.current).size();
        }
        if (this.isObject()) {
            return ((Map)this.current).size();
        }
        return 1;
    }

    public String getString(String string) {
        String string2 = null;
        if (!this.hasKey(string)) {
            return string2;
        }
        this.at(string);
        string2 = this.asString();
        this.up();
        return string2;
    }

    public int getInt(String string) {
        int n2 = 0;
        if (!this.hasKey(string)) {
            return n2;
        }
        this.at(string);
        n2 = this.asInt();
        this.up();
        return n2;
    }

    public Integer getInteger(String string) {
        Integer n2 = null;
        if (!this.hasKey(string)) {
            return n2;
        }
        this.at(string);
        n2 = this.asIntegerObj();
        this.up();
        return n2;
    }

    public double getDouble(String string) {
        double d2 = 0.0;
        if (!this.hasKey(string)) {
            return d2;
        }
        this.at(string);
        d2 = this.asDouble();
        this.up();
        return d2;
    }

    public boolean hasKey(String string) {
        if (!this.isObject()) {
            return false;
        }
        return this.o(this.current).containsKey(string);
    }

    public JSONNavi<?> at(String string) {
        if (this.failure) {
            return this;
        }
        if (!this.isObject()) {
            this.object();
        }
        if (!(this.current instanceof Map)) {
            return this.failure("current node is not an Object", string);
        }
        if (!this.o(this.current).containsKey(string)) {
            if (this.readonly) {
                return this.failure("current Object have no key named " + string, string);
            }
            this.stack.add(this.current);
            this.path.add(string);
            this.current = null;
            this.missingKey = string;
            return this;
        }
        Object object = this.o(this.current).get(string);
        this.stack.add(this.current);
        this.path.add(string);
        this.current = object;
        return this;
    }

    public Object get(String string) {
        if (this.failure) {
            return this;
        }
        if (!this.isObject()) {
            this.object();
        }
        if (!(this.current instanceof Map)) {
            return this.failure("current node is not an Object", string);
        }
        return this.o(this.current).get(string);
    }

    public Object get(int n2) {
        if (this.failure) {
            return this;
        }
        if (!this.isArray()) {
            this.array();
        }
        if (!(this.current instanceof List)) {
            return this.failure("current node is not an List", n2);
        }
        return this.a(this.current).get(n2);
    }

    public JSONNavi<T> set(String string, String string2) {
        this.object();
        if (this.failure) {
            return this;
        }
        this.o(this.current).put(string, string2);
        return this;
    }

    public JSONNavi<T> set(String string, Number number) {
        this.object();
        if (this.failure) {
            return this;
        }
        this.o(this.current).put(string, number);
        return this;
    }

    public JSONNavi<T> set(String string, long l2) {
        return this.set(string, (Number)l2);
    }

    public JSONNavi<T> set(String string, int n2) {
        return this.set(string, (Number)n2);
    }

    public JSONNavi<T> set(String string, double d2) {
        return this.set(string, (Number)d2);
    }

    public JSONNavi<T> set(String string, float f2) {
        return this.set(string, Float.valueOf(f2));
    }

    public JSONNavi<T> add(Object ... objectArray) {
        this.array();
        if (this.failure) {
            return this;
        }
        List<Object> list = this.a(this.current);
        for (Object object : objectArray) {
            list.add(object);
        }
        return this;
    }

    public String asString() {
        if (this.current == null) {
            return null;
        }
        if (this.current instanceof String) {
            return (String)this.current;
        }
        return this.current.toString();
    }

    public double asDouble() {
        if (this.current instanceof Number) {
            return ((Number)this.current).doubleValue();
        }
        return Double.NaN;
    }

    public Double asDoubleObj() {
        if (this.current == null) {
            return null;
        }
        if (this.current instanceof Number) {
            if (this.current instanceof Double) {
                return (Double)this.current;
            }
            return ((Number)this.current).doubleValue();
        }
        return Double.NaN;
    }

    public float asFloat() {
        if (this.current instanceof Number) {
            return ((Number)this.current).floatValue();
        }
        return Float.NaN;
    }

    public Float asFloatObj() {
        if (this.current == null) {
            return null;
        }
        if (this.current instanceof Number) {
            if (this.current instanceof Float) {
                return (Float)this.current;
            }
            return Float.valueOf(((Number)this.current).floatValue());
        }
        return Float.valueOf(Float.NaN);
    }

    public int asInt() {
        if (this.current instanceof Number) {
            return ((Number)this.current).intValue();
        }
        return 0;
    }

    public Integer asIntegerObj() {
        if (this.current == null) {
            return null;
        }
        if (this.current instanceof Number) {
            Long l2;
            if (this.current instanceof Integer) {
                return (Integer)this.current;
            }
            if (this.current instanceof Long && (l2 = (Long)this.current) == (long)l2.intValue()) {
                return l2.intValue();
            }
            return null;
        }
        return null;
    }

    public long asLong() {
        if (this.current instanceof Number) {
            return ((Number)this.current).longValue();
        }
        return 0L;
    }

    public Long asLongObj() {
        if (this.current == null) {
            return null;
        }
        if (this.current instanceof Number) {
            if (this.current instanceof Long) {
                return (Long)this.current;
            }
            if (this.current instanceof Integer) {
                return ((Number)this.current).longValue();
            }
            return null;
        }
        return null;
    }

    public boolean asBoolean() {
        if (this.current instanceof Boolean) {
            return (Boolean)this.current;
        }
        return false;
    }

    public Boolean asBooleanObj() {
        if (this.current == null) {
            return null;
        }
        if (this.current instanceof Boolean) {
            return (Boolean)this.current;
        }
        return null;
    }

    public JSONNavi<T> object() {
        if (this.failure) {
            return this;
        }
        if (this.current == null && this.readonly) {
            this.failure("Can not create Object child in readonly", null);
        }
        if (this.current != null) {
            if (this.isObject()) {
                return this;
            }
            if (this.isArray()) {
                this.failure("can not use Object feature on Array.", null);
            }
            this.failure("Can not use current position as Object", null);
        } else {
            this.current = this.mapper.createObject();
        }
        if (this.root == null) {
            this.root = this.current;
        } else {
            this.store();
        }
        return this;
    }

    public JSONNavi<T> array() {
        if (this.failure) {
            return this;
        }
        if (this.current == null && this.readonly) {
            this.failure("Can not create Array child in readonly", null);
        }
        if (this.current != null) {
            if (this.isArray()) {
                return this;
            }
            if (this.isObject()) {
                this.failure("can not use Object feature on Array.", null);
            }
            this.failure("Can not use current position as Object", null);
        } else {
            this.current = this.mapper.createArray();
        }
        if (this.root == null) {
            this.root = this.current;
        } else {
            this.store();
        }
        return this;
    }

    public JSONNavi<T> set(Number number) {
        if (this.failure) {
            return this;
        }
        this.current = number;
        this.store();
        return this;
    }

    public JSONNavi<T> set(Boolean bl2) {
        if (this.failure) {
            return this;
        }
        this.current = bl2;
        this.store();
        return this;
    }

    public JSONNavi<T> set(String string) {
        if (this.failure) {
            return this;
        }
        this.current = string;
        this.store();
        return this;
    }

    public T getRoot() {
        return this.root;
    }

    private void store() {
        Object object = this.stack.peek();
        if (this.isObject(object)) {
            this.o(object).put((String)this.missingKey, this.current);
        } else if (this.isArray(object)) {
            int n2 = ((Number)this.missingKey).intValue();
            List<Object> list = this.a(object);
            while (list.size() <= n2) {
                list.add(null);
            }
            list.set(n2, this.current);
        }
    }

    public boolean isArray() {
        return this.isArray(this.current);
    }

    public boolean isObject() {
        return this.isObject(this.current);
    }

    private boolean isArray(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof List;
    }

    private boolean isObject(Object object) {
        if (object == null) {
            return false;
        }
        return object instanceof Map;
    }

    private List<Object> a(Object object) {
        return (List)object;
    }

    private Map<String, Object> o(Object object) {
        return (Map)object;
    }

    public JSONNavi<?> at(int n2) {
        if (this.failure) {
            return this;
        }
        if (!(this.current instanceof List)) {
            return this.failure("current node is not an Array", n2);
        }
        List list = (List)this.current;
        if (n2 < 0 && (n2 = list.size() + n2) < 0) {
            n2 = 0;
        }
        if (n2 >= list.size()) {
            if (this.readonly) {
                return this.failure("Out of bound exception for index", n2);
            }
            this.stack.add(this.current);
            this.path.add(n2);
            this.current = null;
            this.missingKey = n2;
            return this;
        }
        Object e2 = list.get(n2);
        this.stack.add(this.current);
        this.path.add(n2);
        this.current = e2;
        return this;
    }

    public JSONNavi<?> atNext() {
        if (this.failure) {
            return this;
        }
        if (!(this.current instanceof List)) {
            return this.failure("current node is not an Array", null);
        }
        List list = (List)this.current;
        return this.at(list.size());
    }

    public JSONNavi<?> up(int n2) {
        while (n2-- > 0 && this.stack.size() > 0) {
            this.current = this.stack.pop();
            this.path.pop();
        }
        return this;
    }

    public JSONNavi<?> up() {
        if (this.stack.size() > 0) {
            this.current = this.stack.pop();
            this.path.pop();
        }
        return this;
    }

    public String toString() {
        if (this.failure) {
            return JSONValue.toJSONString(this.failureMessage, ERROR_COMPRESS);
        }
        return JSONValue.toJSONString(this.root);
    }

    public String toString(JSONStyle jSONStyle) {
        if (this.failure) {
            return JSONValue.toJSONString(this.failureMessage, jSONStyle);
        }
        return JSONValue.toJSONString(this.root, jSONStyle);
    }

    private JSONNavi<?> failure(String string, Object object) {
        this.failure = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Error: ");
        stringBuilder.append(string);
        stringBuilder.append(" at ");
        stringBuilder.append(this.getJPath());
        if (object != null) {
            if (object instanceof Integer) {
                stringBuilder.append('[').append(object).append(']');
            } else {
                stringBuilder.append('/').append(object);
            }
        }
        this.failureMessage = stringBuilder.toString();
        return this;
    }

    public String getJPath() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object e2 : this.path) {
            if (e2 instanceof String) {
                stringBuilder.append('/').append(e2.toString());
                continue;
            }
            stringBuilder.append('[').append(e2.toString()).append(']');
        }
        return stringBuilder.toString();
    }
}

