/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.token;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.AccessToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.Tokens;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public final class OIDCTokens
extends Tokens {
    private final JWT idToken;
    private final String idTokenString;

    public OIDCTokens(JWT jWT, AccessToken accessToken, RefreshToken refreshToken) {
        super(accessToken, refreshToken);
        if (jWT == null) {
            throw new IllegalArgumentException("The ID token must not be null");
        }
        this.idToken = jWT;
        this.idTokenString = null;
    }

    public OIDCTokens(String string, AccessToken accessToken, RefreshToken refreshToken) {
        super(accessToken, refreshToken);
        if (string == null) {
            throw new IllegalArgumentException("The ID token string must not be null");
        }
        this.idTokenString = string;
        this.idToken = null;
    }

    public OIDCTokens(AccessToken accessToken, RefreshToken refreshToken) {
        super(accessToken, refreshToken);
        this.idToken = null;
        this.idTokenString = null;
    }

    public JWT getIDToken() {
        if (this.idToken != null) {
            return this.idToken;
        }
        if (this.idTokenString != null) {
            try {
                return JWTParser.parse(this.idTokenString);
            }
            catch (java.text.ParseException parseException) {
                return null;
            }
        }
        return null;
    }

    public String getIDTokenString() {
        if (this.idTokenString != null) {
            return this.idTokenString;
        }
        if (this.idToken != null) {
            if (this.idToken.getParsedString() != null) {
                return this.idToken.getParsedString();
            }
            try {
                return this.idToken.serialize();
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return null;
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> hashSet = new HashSet<String>(super.getParameterNames());
        if (this.idToken != null || this.idTokenString != null) {
            hashSet.add("id_token");
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getIDTokenString() != null) {
            jSONObject.put("id_token", this.getIDTokenString());
        }
        return jSONObject;
    }

    public static OIDCTokens parse(JSONObject jSONObject) throws ParseException {
        AccessToken accessToken = AccessToken.parse(jSONObject);
        RefreshToken refreshToken = RefreshToken.parse(jSONObject);
        if (jSONObject.get("id_token") != null) {
            JWT jWT;
            try {
                jWT = JWTParser.parse(JSONObjectUtils.getString(jSONObject, "id_token"));
            }
            catch (java.text.ParseException parseException) {
                throw new ParseException("Couldn't parse ID token: " + parseException.getMessage(), parseException);
            }
            return new OIDCTokens(jWT, accessToken, refreshToken);
        }
        return new OIDCTokens(accessToken, refreshToken);
    }
}

