/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.id;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Resource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GeneralException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ciba.BackChannelTokenDeliveryMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.rp.OIDCClientMetadata;

public class SectorIDURIValidator {
    private final ResourceRetriever resourceRetriever;

    public SectorIDURIValidator(ResourceRetriever resourceRetriever) {
        if (resourceRetriever == null) {
            throw new IllegalArgumentException("The resource retriever must not be null");
        }
        this.resourceRetriever = resourceRetriever;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.resourceRetriever;
    }

    public void validate(URI uRI, Set<URI> set) throws GeneralException {
        Resource resource;
        try {
            resource = this.resourceRetriever.retrieveResource(uRI.toURL());
        }
        catch (IOException iOException) {
            throw new GeneralException("Couldn't retrieve the sector ID JSON document: " + iOException.getMessage(), iOException);
        }
        if (resource.getContentType() == null) {
            throw new GeneralException("Couldn't validate sector ID: Missing HTTP Content-Type");
        }
        if (!resource.getContentType().toLowerCase().startsWith("application/json")) {
            throw new GeneralException("Couldn't validate sector ID: HTTP Content-Type must be application/json, found " + resource.getContentType());
        }
        List<URI> list = JSONArrayUtils.toURIList(JSONArrayUtils.parse(resource.getContent()));
        for (URI uRI2 : set) {
            if (list.contains(uRI2)) continue;
            throw new GeneralException("Sector ID validation failed: URI " + uRI2 + " not present at sector ID URI " + uRI);
        }
    }

    public static Set<URI> collectURIsForValidation(OIDCClientMetadata oIDCClientMetadata) {
        HashSet<URI> hashSet = new HashSet<URI>();
        if (oIDCClientMetadata.getRedirectionURIs() != null) {
            hashSet.addAll(oIDCClientMetadata.getRedirectionURIs());
        }
        if ((BackChannelTokenDeliveryMode.POLL.equals(oIDCClientMetadata.getBackChannelTokenDeliveryMode()) || BackChannelTokenDeliveryMode.PING.equals(oIDCClientMetadata.getBackChannelTokenDeliveryMode())) && oIDCClientMetadata.getJWKSetURI() != null) {
            hashSet.add(oIDCClientMetadata.getJWKSetURI());
        }
        if (BackChannelTokenDeliveryMode.PUSH.equals(oIDCClientMetadata.getBackChannelTokenDeliveryMode()) && oIDCClientMetadata.getBackChannelClientNotificationEndpoint() != null) {
            hashSet.add(oIDCClientMetadata.getBackChannelClientNotificationEndpoint());
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

