/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationEntityMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.FederationMetadataType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.EntityMetadataValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.EntityStatementRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.InvalidEntityMetadataException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.ResolveException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChainRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChainSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.constraints.TrustChainConstraints;

class DefaultTrustChainRetriever
implements TrustChainRetriever {
    private final EntityStatementRetriever retriever;
    private final TrustChainConstraints constraints;
    private final List<Throwable> accumulatedExceptions = new LinkedList<Throwable>();
    private final Map<EntityID, JWKSet> accumulatedTrustAnchorJWKSets = new HashMap<EntityID, JWKSet>();

    DefaultTrustChainRetriever(EntityStatementRetriever entityStatementRetriever) {
        this(entityStatementRetriever, TrustChainConstraints.NO_CONSTRAINTS);
    }

    DefaultTrustChainRetriever(EntityStatementRetriever entityStatementRetriever, TrustChainConstraints trustChainConstraints) {
        if (entityStatementRetriever == null) {
            throw new IllegalArgumentException("The entity statement retriever must not be null");
        }
        this.retriever = entityStatementRetriever;
        if (trustChainConstraints == null) {
            throw new IllegalArgumentException("The trust chain constraints must not be null");
        }
        this.constraints = trustChainConstraints;
    }

    public TrustChainConstraints getConstraints() {
        return this.constraints;
    }

    @Override
    public TrustChainSet retrieve(EntityID entityID, EntityMetadataValidator entityMetadataValidator, Set<EntityID> set) throws InvalidEntityMetadataException {
        EntityStatement entityStatement;
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The trust anchors must not be empty");
        }
        this.accumulatedExceptions.clear();
        this.accumulatedTrustAnchorJWKSets.clear();
        try {
            entityStatement = this.retriever.fetchSelfIssuedEntityStatement(entityID);
        }
        catch (ResolveException resolveException) {
            this.accumulatedExceptions.add(resolveException);
            return new TrustChainSet();
        }
        if (entityMetadataValidator != null) {
            FederationMetadataType federationMetadataType = entityMetadataValidator.getType();
            if (federationMetadataType == null) {
                throw new IllegalArgumentException("The target metadata validation doesn't specify a federation entity type");
            }
            entityMetadataValidator.validate(entityID, entityStatement.getClaimsSet().getMetadata(federationMetadataType));
        }
        return this.retrieve(entityStatement, set);
    }

    @Override
    public TrustChainSet retrieve(EntityStatement entityStatement, Set<EntityID> set) {
        EntityID entityID;
        if (CollectionUtils.isEmpty(set)) {
            throw new IllegalArgumentException("The trust anchors must not be empty");
        }
        this.accumulatedExceptions.clear();
        this.accumulatedTrustAnchorJWKSets.clear();
        List<EntityID> list = entityStatement.getClaimsSet().getAuthorityHints();
        if (CollectionUtils.isEmpty(list)) {
            this.accumulatedExceptions.add(new ResolveException("Entity " + entityStatement.getEntityID() + " has no authorities listed (authority_hints)"));
            return new TrustChainSet();
        }
        try {
            entityID = EntityID.parse(entityStatement.getClaimsSet().getSubject());
        }
        catch (ParseException parseException) {
            this.accumulatedExceptions.add(new ResolveException("Entity " + entityStatement.getEntityID() + " subject is illegal: " + parseException.getMessage(), parseException));
            return new TrustChainSet();
        }
        Set<List<EntityStatement>> set2 = this.fetchStatementsFromAuthorities(entityID, list, set, Collections.emptyList());
        TrustChainSet trustChainSet = new TrustChainSet();
        for (List<EntityStatement> list2 : set2) {
            trustChainSet.add(new TrustChain(entityStatement, list2));
        }
        return trustChainSet;
    }

    private Set<List<EntityStatement>> fetchStatementsFromAuthorities(EntityID entityID, List<EntityID> list, Set<EntityID> set, List<EntityStatement> list2) {
        Object object;
        Object object2;
        HashSet<List<EntityStatement>> hashSet = new HashSet<List<EntityStatement>>();
        HashMap<EntityID, List<EntityID>> hashMap = new HashMap<EntityID, List<EntityID>>();
        for (EntityID serializable2 : list) {
            FederationEntityMetadata federationEntityMetadata;
            EntityStatement entityStatement;
            if (serializable2 == null) continue;
            if (!this.constraints.isPermitted(list2.size())) {
                this.accumulatedExceptions.add(new ResolveException("Reached max number of intermediates in chain at " + entityID));
                continue;
            }
            if (!this.constraints.isPermitted(serializable2)) {
                this.accumulatedExceptions.add(new ResolveException("Reached authority which isn't permitted according to constraints: " + serializable2));
                continue;
            }
            try {
                entityStatement = this.retriever.fetchSelfIssuedEntityStatement(serializable2);
                hashMap.put(serializable2, entityStatement.getClaimsSet().getAuthorityHints());
            }
            catch (ResolveException resolveException) {
                this.accumulatedExceptions.add(new ResolveException("Couldn't fetch self-issued entity statement from " + serializable2 + ": " + resolveException.getMessage(), resolveException));
                continue;
            }
            if (set.contains(entityStatement.getEntityID())) {
                this.accumulatedTrustAnchorJWKSets.put(entityStatement.getEntityID(), entityStatement.getClaimsSet().getJWKSet());
            }
            if ((federationEntityMetadata = entityStatement.getClaimsSet().getFederationEntityMetadata()) == null) {
                this.accumulatedExceptions.add(new ResolveException("No federation entity metadata for " + serializable2));
                continue;
            }
            object2 = federationEntityMetadata.getFederationAPIEndpointURI();
            if (object2 == null) {
                this.accumulatedExceptions.add(new ResolveException("No federation API URI in metadata for " + serializable2));
                continue;
            }
            try {
                object = this.retriever.fetchEntityStatement((URI)object2, serializable2, entityID);
            }
            catch (ResolveException resolveException) {
                this.accumulatedExceptions.add(new ResolveException("Couldn't fetch entity statement from " + object2 + ": " + resolveException.getMessage(), resolveException));
                continue;
            }
            LinkedList<EntityStatement> linkedList = new LinkedList<EntityStatement>(list2);
            linkedList.add((EntityStatement)object);
            hashSet.add(Collections.unmodifiableList(linkedList));
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        LinkedHashSet<List> linkedHashSet2 = new LinkedHashSet<List>();
        for (List list3 : hashSet) {
            object2 = (EntityStatement)list3.get(list3.size() - 1);
            if (set.contains(((EntityStatement)object2).getClaimsSet().getIssuerEntityID())) {
                linkedHashSet.add(list3);
                continue;
            }
            if (CollectionUtils.isEmpty(((EntityStatement)object2).getClaimsSet().getAuthorityHints())) continue;
            linkedHashSet2.add(list3);
        }
        for (List list4 : linkedHashSet2) {
            object2 = (EntityStatement)list4.get(list4.size() - 1);
            object = (List)hashMap.get(((EntityStatement)object2).getClaimsSet().getIssuerEntityID());
            if (CollectionUtils.isEmpty(object)) continue;
            linkedHashSet.addAll(this.fetchStatementsFromAuthorities(((EntityStatement)object2).getClaimsSet().getIssuerEntityID(), (List<EntityID>)object, set, list4));
        }
        return linkedHashSet;
    }

    @Override
    public Map<EntityID, JWKSet> getAccumulatedTrustAnchorJWKSets() {
        return this.accumulatedTrustAnchorJWKSets;
    }

    @Override
    public List<Throwable> getAccumulatedExceptions() {
        return this.accumulatedExceptions;
    }
}

