/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.BooleanConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.OperationName;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.PolicyViolationException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.StringConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.StringListConfiguration;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.language.UntypedOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.ConfigurationType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.policy.operations.Utils;

public class DefaultOperation
implements BooleanConfiguration,
PolicyOperation,
StringConfiguration,
StringListConfiguration,
UntypedOperation {
    public static final OperationName NAME = new OperationName("default");
    private ConfigurationType configType;
    private boolean booleanValue;
    private String stringValue;
    private List<String> stringListValue;

    @Override
    public OperationName getOperationName() {
        return NAME;
    }

    @Override
    public void configure(boolean bl2) {
        this.configType = ConfigurationType.BOOLEAN;
        this.booleanValue = bl2;
    }

    @Override
    public void configure(String string) {
        this.configType = ConfigurationType.STRING;
        this.stringValue = string;
    }

    @Override
    public void configure(List<String> list) {
        this.configType = ConfigurationType.STRING_LIST;
        this.stringListValue = list;
    }

    @Override
    public void parseConfiguration(Object object) throws ParseException {
        if (object instanceof Boolean) {
            this.configure(JSONUtils.toBoolean(object));
        } else if (object instanceof String) {
            this.configure(JSONUtils.toString(object));
        } else {
            this.configure(JSONUtils.toStringList(object));
        }
    }

    @Override
    public Map.Entry<String, Object> toJSONObjectEntry() {
        Object object;
        if (this.configType == null) {
            throw new IllegalStateException("The policy is not initialized");
        }
        if (this.configType.equals((Object)ConfigurationType.BOOLEAN)) {
            object = this.getBooleanConfiguration();
        } else if (this.configType.equals((Object)ConfigurationType.STRING_LIST)) {
            object = this.getStringListConfiguration();
        } else if (this.configType.equals((Object)ConfigurationType.STRING)) {
            object = this.getStringConfiguration();
        } else {
            throw new IllegalStateException("Unsupported configuration type: " + (Object)((Object)this.configType));
        }
        return new AbstractMap.SimpleImmutableEntry<String, Object>(this.getOperationName().getValue(), object);
    }

    @Override
    public boolean getBooleanConfiguration() {
        return this.booleanValue;
    }

    @Override
    public String getStringConfiguration() {
        return this.stringValue;
    }

    @Override
    public List<String> getStringListConfiguration() {
        return this.stringListValue;
    }

    @Override
    public PolicyOperation merge(PolicyOperation policyOperation) throws PolicyViolationException {
        DefaultOperation defaultOperation = Utils.castForMerge(policyOperation, DefaultOperation.class);
        if (this.configType == null || defaultOperation.configType == null) {
            throw new PolicyViolationException("The default operation is not initialized");
        }
        if (this.configType.equals((Object)ConfigurationType.STRING_LIST) && this.getStringListConfiguration() != null && this.getStringListConfiguration().equals(defaultOperation.getStringListConfiguration())) {
            DefaultOperation defaultOperation2 = new DefaultOperation();
            defaultOperation2.configure(this.getStringListConfiguration());
            return defaultOperation2;
        }
        if (this.configType.equals((Object)ConfigurationType.STRING) && this.getStringConfiguration() != null && this.getStringConfiguration().equals(defaultOperation.getStringConfiguration())) {
            DefaultOperation defaultOperation3 = new DefaultOperation();
            defaultOperation3.configure(this.getStringConfiguration());
            return defaultOperation3;
        }
        if (this.configType.equals((Object)ConfigurationType.BOOLEAN) && this.getBooleanConfiguration() == defaultOperation.getBooleanConfiguration()) {
            DefaultOperation defaultOperation4 = new DefaultOperation();
            defaultOperation4.configure(this.getBooleanConfiguration());
            return defaultOperation4;
        }
        throw new PolicyViolationException("Default value mismatch");
    }

    @Override
    public Object apply(Object object) {
        if (this.configType == null) {
            throw new IllegalStateException("The policy is not initialized");
        }
        if (object != null) {
            return object;
        }
        if (this.stringListValue != null) {
            return this.stringListValue;
        }
        if (this.stringValue != null) {
            return this.stringValue;
        }
        return this.booleanValue;
    }
}

