/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities;

import java.security.PublicKey;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.factories.DefaultJWSVerifierFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.AsymmetricJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetKeyPair;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.BadJOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.CollectionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatementClaimsVerifier;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public final class EntityStatement {
    private final SignedJWT statementJWT;
    private final EntityStatementClaimsSet statementClaimsSet;

    private EntityStatement(SignedJWT signedJWT, EntityStatementClaimsSet entityStatementClaimsSet) {
        if (signedJWT == null) {
            throw new IllegalArgumentException("The entity statement must not be null");
        }
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new IllegalArgumentException("The statement is not signed");
        }
        this.statementJWT = signedJWT;
        if (entityStatementClaimsSet == null) {
            throw new IllegalArgumentException("The entity statement claims set must not be null");
        }
        this.statementClaimsSet = entityStatementClaimsSet;
    }

    public EntityID getEntityID() {
        return this.getClaimsSet().getSubjectEntityID();
    }

    public SignedJWT getSignedStatement() {
        return this.statementJWT;
    }

    public EntityStatementClaimsSet getClaimsSet() {
        return this.statementClaimsSet;
    }

    public boolean isTrustAnchor() {
        return this.getClaimsSet().isSelfStatement() && CollectionUtils.isEmpty(this.getClaimsSet().getAuthorityHints());
    }

    public Base64URL verifySignatureOfSelfStatement() throws BadJOSEException, JOSEException {
        if (!this.getClaimsSet().isSelfStatement()) {
            throw new BadJOSEException("Entity statement not self-issued");
        }
        return this.verifySignature(this.getClaimsSet().getJWKSet());
    }

    public Base64URL verifySignature(JWKSet jWKSet) throws BadJOSEException, JOSEException {
        List<JWK> list = new JWKSelector(JWKMatcher.forJWSHeader(this.statementJWT.getHeader())).select(jWKSet);
        if (list.isEmpty()) {
            throw new BadJOSEException("Entity statement rejected: Another JOSE algorithm expected, or no matching key(s) found");
        }
        DefaultJWSVerifierFactory defaultJWSVerifierFactory = new DefaultJWSVerifierFactory();
        JWK jWK = null;
        for (JWK jWK2 : list) {
            if (!(jWK2 instanceof AsymmetricJWK)) continue;
            PublicKey publicKey = ((AsymmetricJWK)((Object)jWK2)).toPublicKey();
            JWSVerifier jWSVerifier = defaultJWSVerifierFactory.createJWSVerifier(this.statementJWT.getHeader(), publicKey);
            if (!this.statementJWT.verify(jWSVerifier)) continue;
            jWK = jWK2;
        }
        if (jWK == null) {
            throw new BadJOSEException("Entity statement rejected: Invalid signature");
        }
        try {
            new EntityStatementClaimsVerifier(null).verify(this.statementJWT.getJWTClaimsSet(), null);
        }
        catch (java.text.ParseException parseException) {
            throw new BadJOSEException(parseException.getMessage(), parseException);
        }
        return jWK.computeThumbprint();
    }

    public static EntityStatement sign(EntityStatementClaimsSet entityStatementClaimsSet, JWK jWK) throws JOSEException {
        return EntityStatement.sign(entityStatementClaimsSet, jWK, EntityStatement.resolveSigningAlgorithm(jWK));
    }

    public static EntityStatement sign(EntityStatementClaimsSet entityStatementClaimsSet, JWK jWK, JWSAlgorithm jWSAlgorithm) throws JOSEException {
        SignedJWT signedJWT;
        if (entityStatementClaimsSet.isSelfStatement() && !entityStatementClaimsSet.getJWKSet().containsJWK(jWK)) {
            throw new JOSEException("Signing JWK not found in JWK set of self-statement");
        }
        JWSSigner jWSSigner = new DefaultJWSSignerFactory().createJWSSigner(jWK, jWSAlgorithm);
        JWSHeader jWSHeader = new JWSHeader.Builder(jWSAlgorithm).keyID(jWK.getKeyID()).build();
        try {
            signedJWT = new SignedJWT(jWSHeader, entityStatementClaimsSet.toJWTClaimsSet());
        }
        catch (ParseException parseException) {
            throw new JOSEException(parseException.getMessage(), parseException);
        }
        signedJWT.sign(jWSSigner);
        return new EntityStatement(signedJWT, entityStatementClaimsSet);
    }

    private static JWSAlgorithm resolveSigningAlgorithm(JWK jWK) throws JOSEException {
        KeyType keyType = jWK.getKeyType();
        if (KeyType.RSA.equals(keyType)) {
            if (jWK.getAlgorithm() != null) {
                return new JWSAlgorithm(jWK.getAlgorithm().getName());
            }
            return JWSAlgorithm.RS256;
        }
        if (KeyType.EC.equals(keyType)) {
            ECKey eCKey = jWK.toECKey();
            if (jWK.getAlgorithm() != null) {
                return new JWSAlgorithm(eCKey.getAlgorithm().getName());
            }
            if (Curve.P_256.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES256;
            }
            if (Curve.P_384.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES384;
            }
            if (Curve.P_521.equals(eCKey.getCurve())) {
                return JWSAlgorithm.ES512;
            }
            throw new JOSEException("Unsupported ECDSA curve: " + eCKey.getCurve());
        }
        if (KeyType.OKP.equals(keyType)) {
            OctetKeyPair octetKeyPair = jWK.toOctetKeyPair();
            if (Curve.Ed25519.equals(octetKeyPair.getCurve())) {
                return JWSAlgorithm.EdDSA;
            }
            throw new JOSEException("Unsupported EdDSA curve: " + octetKeyPair.getCurve());
        }
        throw new JOSEException("Unsupported JWK type: " + keyType);
    }

    public static EntityStatement parse(SignedJWT signedJWT) throws ParseException {
        JWTClaimsSet jWTClaimsSet;
        if (JWSObject.State.UNSIGNED.equals((Object)signedJWT.getState())) {
            throw new ParseException("The statement is not signed");
        }
        try {
            jWTClaimsSet = signedJWT.getJWTClaimsSet();
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException(parseException.getMessage(), parseException);
        }
        EntityStatementClaimsSet entityStatementClaimsSet = new EntityStatementClaimsSet(jWTClaimsSet);
        return new EntityStatement(signedJWT, entityStatementClaimsSet);
    }

    public static EntityStatement parse(String string) throws ParseException {
        try {
            return EntityStatement.parse(SignedJWT.parse(string));
        }
        catch (java.text.ParseException parseException) {
            throw new ParseException("Invalid entity statement: " + parseException.getMessage(), parseException);
        }
    }
}

