/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTag;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.claims.ClaimRequirement;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

@Immutable
public class ClaimsSetRequest
implements JSONAware {
    private final Collection<Entry> entries;

    public ClaimsSetRequest() {
        this(Collections.emptyList());
    }

    public ClaimsSetRequest(Collection<Entry> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("The entries must not be null");
        }
        this.entries = Collections.unmodifiableCollection(collection);
    }

    public ClaimsSetRequest add(String string) {
        return this.add(new Entry(string));
    }

    public ClaimsSetRequest add(Entry entry) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>(this.getEntries());
        linkedList.add(entry);
        return new ClaimsSetRequest(linkedList);
    }

    public Collection<Entry> getEntries() {
        return this.entries;
    }

    public Set<String> getClaimNames(boolean bl2) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : this.entries) {
            hashSet.add(entry.getClaimName(bl2));
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public Entry get(String string) {
        return this.get(string, null);
    }

    public Entry get(String string, LangTag langTag) {
        for (Entry entry : this.getEntries()) {
            if (string.equals(entry.getClaimName()) && langTag == null && entry.getLangTag() == null) {
                return entry;
            }
            if (!string.equals(entry.getClaimName()) || langTag == null || !langTag.equals(entry.getLangTag())) continue;
            return entry;
        }
        return null;
    }

    public ClaimsSetRequest delete(String string, LangTag langTag) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        for (Entry entry : this.getEntries()) {
            if (string.equals(entry.getClaimName()) && langTag == null && entry.getLangTag() == null || string.equals(entry.getClaimName()) && langTag != null && langTag.equals(entry.getLangTag())) continue;
            linkedList.add(entry);
        }
        return new ClaimsSetRequest(linkedList);
    }

    public ClaimsSetRequest delete(String string) {
        LinkedList<Entry> linkedList = new LinkedList<Entry>();
        for (Entry entry : this.getEntries()) {
            if (string.equals(entry.getClaimName())) continue;
            linkedList.add(entry);
        }
        return new ClaimsSetRequest(linkedList);
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        for (Entry entry : this.entries) {
            Map.Entry<String, JSONObject> entry2 = entry.toJSONObjectEntry();
            jSONObject.put(entry2.getKey(), entry2.getValue());
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public static ClaimsSetRequest parse(JSONObject jSONObject) throws ParseException {
        ClaimsSetRequest claimsSetRequest = new ClaimsSetRequest();
        for (String string : jSONObject.keySet()) {
            if ("verified_claims".equals(string)) continue;
            JSONObject jSONObject2 = JSONObjectUtils.getJSONObject(jSONObject, string, null);
            claimsSetRequest = claimsSetRequest.add(Entry.parse(new AbstractMap.SimpleImmutableEntry<String, JSONObject>(string, jSONObject2)));
        }
        return claimsSetRequest;
    }

    public static ClaimsSetRequest parse(String string) throws ParseException {
        return ClaimsSetRequest.parse(JSONObjectUtils.parse(string));
    }

    @Immutable
    public static class Entry {
        private final String claimName;
        private final ClaimRequirement requirement;
        private final LangTag langTag;
        private final Object value;
        private final List<?> values;
        private final String purpose;
        private final Map<String, Object> additionalInformation;

        public Entry(String string) {
            this(string, ClaimRequirement.VOLUNTARY, null, null, null, null, null);
        }

        private Entry(String string, ClaimRequirement claimRequirement, LangTag langTag, Object object, List<?> list, String string2, Map<String, Object> map) {
            if (string == null) {
                throw new IllegalArgumentException("The claim name must not be null");
            }
            this.claimName = string;
            if (claimRequirement == null) {
                throw new IllegalArgumentException("The claim requirement must not be null");
            }
            this.requirement = claimRequirement;
            this.langTag = langTag;
            if (object != null && list == null) {
                this.value = object;
                this.values = null;
            } else if (object == null && list != null) {
                this.value = null;
                this.values = list;
            } else if (object == null && list == null) {
                this.value = null;
                this.values = null;
            } else {
                throw new IllegalArgumentException("Either value or values must be specified, but not both");
            }
            this.purpose = string2;
            this.additionalInformation = map;
        }

        public String getClaimName() {
            return this.getClaimName(false);
        }

        public String getClaimName(boolean bl2) {
            if (bl2 && this.langTag != null) {
                return this.claimName + "#" + this.langTag;
            }
            return this.claimName;
        }

        public Entry withClaimRequirement(ClaimRequirement claimRequirement) {
            return new Entry(this.claimName, claimRequirement, this.langTag, this.value, this.values, this.purpose, this.additionalInformation);
        }

        public ClaimRequirement getClaimRequirement() {
            return this.requirement;
        }

        public Entry withLangTag(LangTag langTag) {
            return new Entry(this.claimName, this.requirement, langTag, this.value, this.values, this.purpose, this.additionalInformation);
        }

        public LangTag getLangTag() {
            return this.langTag;
        }

        public Entry withValue(String string) {
            return new Entry(this.claimName, this.requirement, this.langTag, string, null, this.purpose, this.additionalInformation);
        }

        public Entry withValue(Number number) {
            return new Entry(this.claimName, this.requirement, this.langTag, number, null, this.purpose, this.additionalInformation);
        }

        public Entry withValue(JSONObject jSONObject) {
            return new Entry(this.claimName, this.requirement, this.langTag, jSONObject, null, this.purpose, this.additionalInformation);
        }

        public Entry withValue(Object object) {
            return new Entry(this.claimName, this.requirement, this.langTag, object, null, this.purpose, this.additionalInformation);
        }

        public String getValueAsString() {
            if (this.value instanceof String) {
                return (String)this.value;
            }
            return null;
        }

        @Deprecated
        public String getValue() {
            return this.getValueAsString();
        }

        public Number getValueAsNumber() {
            if (this.value instanceof Number) {
                return (Number)this.value;
            }
            return null;
        }

        public JSONObject getValueAsJSONObject() {
            if (this.value instanceof JSONObject) {
                return (JSONObject)this.value;
            }
            return null;
        }

        public Object getRawValue() {
            return this.value;
        }

        public Entry withValues(List<?> list) {
            return new Entry(this.claimName, this.requirement, this.langTag, null, list, this.purpose, this.additionalInformation);
        }

        public List<String> getValuesAsListOfStrings() {
            if (this.values == null) {
                return null;
            }
            if (this.values.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> arrayList = new ArrayList<String>(this.values.size());
            for (Object obj : this.values) {
                if (obj instanceof String) {
                    arrayList.add((String)obj);
                    continue;
                }
                return null;
            }
            return arrayList;
        }

        @Deprecated
        public List<String> getValues() {
            return this.getValuesAsListOfStrings();
        }

        public List<JSONObject> getValuesAsListOfJSONObjects() {
            if (this.values == null) {
                return null;
            }
            if (this.values.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>(this.values.size());
            for (Object obj : this.values) {
                if (obj instanceof JSONObject) {
                    arrayList.add((JSONObject)obj);
                    continue;
                }
                return null;
            }
            return arrayList;
        }

        public List<?> getValuesAsRawList() {
            return this.values;
        }

        public Entry withPurpose(String string) {
            return new Entry(this.claimName, this.requirement, this.langTag, this.value, this.values, string, this.additionalInformation);
        }

        public String getPurpose() {
            return this.purpose;
        }

        public Entry withAdditionalInformation(Map<String, Object> map) {
            return new Entry(this.claimName, this.requirement, this.langTag, this.value, this.values, this.purpose, map);
        }

        public Map<String, Object> getAdditionalInformation() {
            return this.additionalInformation;
        }

        public Map.Entry<String, JSONObject> toJSONObjectEntry() {
            JSONObject jSONObject = null;
            if (this.getRawValue() != null) {
                jSONObject = new JSONObject();
                jSONObject.put("value", this.getRawValue());
            }
            if (this.getValuesAsRawList() != null) {
                jSONObject = new JSONObject();
                jSONObject.put("values", this.getValuesAsRawList());
            }
            if (this.getClaimRequirement().equals((Object)ClaimRequirement.ESSENTIAL)) {
                if (jSONObject == null) {
                    jSONObject = new JSONObject();
                }
                jSONObject.put("essential", true);
            }
            if (this.getPurpose() != null) {
                if (jSONObject == null) {
                    jSONObject = new JSONObject();
                }
                jSONObject.put("purpose", this.getPurpose());
            }
            if (this.getAdditionalInformation() != null) {
                if (jSONObject == null) {
                    jSONObject = new JSONObject();
                }
                for (Map.Entry<String, Object> entry : this.getAdditionalInformation().entrySet()) {
                    jSONObject.put(entry.getKey(), entry.getValue());
                }
            }
            return new AbstractMap.SimpleImmutableEntry<String, JSONObject>(this.getClaimName(true), jSONObject);
        }

        public static Entry parse(Map.Entry<String, JSONObject> entry) throws ParseException {
            boolean bl2;
            String string;
            Object object;
            String string2 = entry.getKey();
            LangTag langTag = null;
            if (string2.contains("#")) {
                object = string2.split("#", 2);
                string = object[0];
                try {
                    langTag = LangTag.parse(object[1]);
                }
                catch (LangTagException langTagException) {
                    throw new ParseException(langTagException.getMessage(), langTagException);
                }
            } else {
                string = string2;
            }
            if ((object = entry.getValue()) == null) {
                return new Entry(string).withLangTag(langTag);
            }
            ClaimRequirement claimRequirement = ClaimRequirement.VOLUNTARY;
            if (((HashMap)object).containsKey("essential") && (bl2 = JSONObjectUtils.getBoolean((JSONObject)object, "essential"))) {
                claimRequirement = ClaimRequirement.ESSENTIAL;
            }
            String string3 = JSONObjectUtils.getString((JSONObject)object, "purpose", null);
            if (((HashMap)object).get("value") != null) {
                Object v2 = ((HashMap)object).get("value");
                Map<String, Object> map = Entry.getAdditionalInformationFromClaim((JSONObject)object);
                return new Entry(string, claimRequirement, langTag, v2, null, string3, map);
            }
            if (((HashMap)object).get("values") != null) {
                List<Object> list = JSONObjectUtils.getList((JSONObject)object, "values");
                Map<String, Object> map = Entry.getAdditionalInformationFromClaim((JSONObject)object);
                return new Entry(string, claimRequirement, langTag, null, list, string3, map);
            }
            Map<String, Object> map = Entry.getAdditionalInformationFromClaim((JSONObject)object);
            return new Entry(string, claimRequirement, langTag, null, null, string3, map);
        }

        private static Map<String, Object> getAdditionalInformationFromClaim(JSONObject jSONObject) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList("essential", "value", "values", "purpose"));
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (Map.Entry entry : jSONObject.entrySet()) {
                if (hashSet.contains(entry.getKey())) continue;
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
            return hashMap.isEmpty() ? null : hashMap;
        }
    }
}

