/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.date.DateWithTimeZoneOffset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Attestation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidence;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityEvidenceType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.IdentityVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.ValidationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.VerificationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.attachment.Attachment;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class VouchEvidence
extends IdentityEvidence {
    private final ValidationMethod validationMethod;
    private final VerificationMethod verificationMethod;
    private final IdentityVerifier verifier;
    private final DateWithTimeZoneOffset time;
    private final Attestation attestation;

    public VouchEvidence(ValidationMethod validationMethod, VerificationMethod verificationMethod, IdentityVerifier identityVerifier, DateWithTimeZoneOffset dateWithTimeZoneOffset, Attestation attestation, List<Attachment> list) {
        super(IdentityEvidenceType.VOUCH, list);
        this.validationMethod = validationMethod;
        this.verificationMethod = verificationMethod;
        this.time = dateWithTimeZoneOffset;
        this.verifier = identityVerifier;
        this.attestation = attestation;
    }

    public ValidationMethod getValidationMethod() {
        return this.validationMethod;
    }

    public VerificationMethod getVerificationMethod() {
        return this.verificationMethod;
    }

    public IdentityVerifier getVerifier() {
        return this.verifier;
    }

    public DateWithTimeZoneOffset getVerificationTime() {
        return this.time;
    }

    public Attestation getAttestation() {
        return this.attestation;
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject jSONObject = super.toJSONObject();
        if (this.getValidationMethod() != null) {
            jSONObject.put("validation_method", this.getValidationMethod().toJSONObject());
        }
        if (this.getVerificationMethod() != null) {
            jSONObject.put("verification_method", this.getVerificationMethod().toJSONObject());
        }
        if (this.getVerifier() != null) {
            jSONObject.put("verifier", this.getVerifier().toJSONObject());
        }
        if (this.getVerificationTime() != null) {
            jSONObject.put("time", this.getVerificationTime().toISO8601String());
        }
        if (this.getAttestation() != null) {
            jSONObject.put("attestation", this.getAttestation().toJSONObject());
        }
        return jSONObject;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VouchEvidence)) {
            return false;
        }
        VouchEvidence vouchEvidence = (VouchEvidence)object;
        return Objects.equals(this.getValidationMethod(), vouchEvidence.getValidationMethod()) && Objects.equals(this.getVerificationMethod(), vouchEvidence.getVerificationMethod()) && Objects.equals(this.getVerifier(), vouchEvidence.getVerifier()) && Objects.equals(this.getVerificationTime(), vouchEvidence.getVerificationTime()) && Objects.equals(this.getAttestation(), vouchEvidence.getAttestation());
    }

    public int hashCode() {
        return Objects.hash(this.getValidationMethod(), this.getVerificationMethod(), this.getVerifier(), this.getVerificationTime(), this.getAttestation());
    }

    public static VouchEvidence parse(JSONObject jSONObject) throws ParseException {
        VouchEvidence.ensureType(IdentityEvidenceType.VOUCH, jSONObject);
        ValidationMethod validationMethod = null;
        if (jSONObject.get("validation_method") != null) {
            validationMethod = ValidationMethod.parse(JSONObjectUtils.getJSONObject(jSONObject, "validation_method"));
        }
        VerificationMethod verificationMethod = null;
        if (jSONObject.get("verification_method") != null) {
            verificationMethod = VerificationMethod.parse(JSONObjectUtils.getJSONObject(jSONObject, "verification_method"));
        }
        IdentityVerifier identityVerifier = null;
        if (jSONObject.get("verifier") != null) {
            identityVerifier = IdentityVerifier.parse(JSONObjectUtils.getJSONObject(jSONObject, "verifier"));
        }
        DateWithTimeZoneOffset dateWithTimeZoneOffset = null;
        if (jSONObject.get("time") != null) {
            dateWithTimeZoneOffset = DateWithTimeZoneOffset.parseISO8601String(JSONObjectUtils.getString(jSONObject, "time"));
        }
        Attestation attestation = null;
        if (jSONObject.get("attestation") != null) {
            attestation = Attestation.parse(JSONObjectUtils.getJSONObject(jSONObject, "attestation"));
        }
        List<Attachment> list = null;
        if (jSONObject.get("attachments") != null) {
            list = Attachment.parseList(JSONObjectUtils.getJSONArray(jSONObject, "attachments"));
        }
        return new VouchEvidence(validationMethod, verificationMethod, identityVerifier, dateWithTimeZoneOffset, attestation, list);
    }
}

