/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.assurance.evidences.Organization;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.secevent.sdk.claims.TXN;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONAware;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONObject;

public class IdentityVerifier
implements JSONAware {
    private final Organization organization;
    private final TXN txn;

    public IdentityVerifier(Organization organization, TXN tXN) {
        this.organization = organization;
        this.txn = tXN;
    }

    @Deprecated
    public IdentityVerifier(String string, TXN tXN) {
        this.organization = string != null ? new Organization(string) : null;
        this.txn = tXN;
    }

    public Organization getOrganizationEntity() {
        return this.organization;
    }

    public String getOrganizationString() {
        return this.getOrganizationEntity() != null ? this.getOrganizationEntity().getValue() : null;
    }

    @Deprecated
    public String getOrganization() {
        return this.getOrganizationString();
    }

    public TXN getTXN() {
        return this.txn;
    }

    public JSONObject toJSONObject() {
        JSONObject jSONObject = new JSONObject();
        if (this.getOrganization() != null) {
            jSONObject.put("organization", this.getOrganizationEntity().getValue());
        }
        if (this.getTXN() != null) {
            jSONObject.put("txn", this.getTXN().getValue());
        }
        return jSONObject;
    }

    @Override
    public String toJSONString() {
        return this.toJSONObject().toJSONString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof IdentityVerifier)) {
            return false;
        }
        IdentityVerifier identityVerifier = (IdentityVerifier)object;
        return Objects.equals(this.getOrganizationEntity(), identityVerifier.getOrganizationEntity()) && Objects.equals(this.getTXN(), identityVerifier.getTXN());
    }

    public int hashCode() {
        return Objects.hash(this.getOrganizationEntity(), this.getTXN());
    }

    public static IdentityVerifier parse(JSONObject jSONObject) throws ParseException {
        Organization organization = null;
        if (jSONObject.get("organization") != null) {
            organization = new Organization(JSONObjectUtils.getString(jSONObject, "organization"));
        }
        TXN tXN = null;
        if (jSONObject.get("txn") != null) {
            tXN = new TXN(JSONObjectUtils.getString(jSONObject, "txn"));
        }
        return new IdentityVerifier(organization, tXN);
    }
}

